/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.project.ui.customizer.J2MECustomizer;
import org.netbeans.modules.mobility.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class J2MECustomizerProvider
implements CustomizerProvider {
    private final Project project;
    private final AntProjectHelper antProjectHelper;
    private final ReferenceHelper refHelper;
    private final ProjectConfigurationsHelper configHelper;
    Dialog dialog = null;
    private static final int OPTION_OK = 0;
    private static final int OPTION_CANCEL = 1;
    private static final String COMMAND_OK = "OK";
    private static final String COMMAND_CANCEL = "CANCEL";
    private DialogDescriptor dialogDescriptor;

    public J2MECustomizerProvider(Project project, AntProjectHelper antProjectHelper, ReferenceHelper refHelper, ProjectConfigurationsHelper configHelper) {
        this.project = project;
        this.antProjectHelper = antProjectHelper;
        this.refHelper = refHelper;
        this.configHelper = configHelper;
    }

    public void showCustomizer() {
        this.showCustomizer(false);
    }

    public void showCustomizer(boolean addConfig) {
        Object[] options = new JButton[]{new JButton(NbBundle.getMessage(J2MECustomizerProvider.class, (String)"LBL_Customizer_Ok_Option")), new JButton(NbBundle.getMessage(J2MECustomizerProvider.class, (String)"LBL_Customizer_Cancel_Option"))};
        options[0].setActionCommand(COMMAND_OK);
        options[1].setActionCommand(COMMAND_CANCEL);
        J2MEProjectProperties j2meProperties = new J2MEProjectProperties(this.project, this.antProjectHelper, this.refHelper, this.configHelper);
        OptionListener optionsListener = new OptionListener(this, this.project, j2meProperties);
        options[0].addActionListener(optionsListener);
        options[1].addActionListener(optionsListener);
        J2MECustomizer customizer = addConfig ? new J2MECustomizer(j2meProperties, "AddConfigDialog") : new J2MECustomizer(j2meProperties);
        this.dialogDescriptor = new DialogDescriptor((Object)customizer, ProjectUtils.getInformation((Project)this.project).getDisplayName(), true, options, (Object)options[0], 0, new HelpCtx(J2MECustomizerProvider.class), null);
        this.dialogDescriptor.setClosingOptions(new Object[]{options[1]});
        customizer.setDialogDescriptor(this.dialogDescriptor);
        this.dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        this.dialog.setVisible(true);
    }

    Dialog getDialog() {
        return this.dialog;
    }

    private static class OptionListener
    implements ActionListener {
        private final Project project;
        private final J2MEProjectProperties j2meProperties;
        private final J2MECustomizerProvider provider;

        OptionListener(J2MECustomizerProvider provider, Project project, J2MEProjectProperties j2meProperties) {
            this.project = project;
            this.j2meProperties = j2meProperties;
            this.provider = provider;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (J2MECustomizerProvider.COMMAND_OK.equals(command)) {
                this.j2meProperties.store();
                if (this.provider.getDialog() != null) {
                    this.provider.getDialog().dispose();
                }
            }
        }
    }
}

