/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.management.api.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.impl.ServiceInfoDataStorageImpl;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.impl.DLightSessionAccessor;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageFactory;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.storage.PersistentDataStorage;
import org.netbeans.modules.dlight.spi.storage.PersistentDataStorageFactory;
import org.netbeans.modules.dlight.spi.storage.ProxyDataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.openide.util.Lookup;

public final class DataStorageManager {
    private Collection<? extends DataStorageFactory> dataStorageFactories;
    private final Collection<? extends PersistentDataStorageFactory> perstistentDataStorageFactories;
    private Map<DLightSession, List<DataStorage>> activeDataStorages = new HashMap<DLightSession, List<DataStorage>>();
    private Map<String, List<DataStorage>> activeStorages = new HashMap<String, List<DataStorage>>();
    private Map<String, ServiceInfoDataStorage> serviceInfoStorages = new HashMap<String, ServiceInfoDataStorage>();
    private static final Logger log = DLightLogger.getLogger(DataStorageManager.class);
    private static final DataStorageManager instance = new DataStorageManager();
    private DLightSession lastSession;

    private DataStorageManager() {
        this.dataStorageFactories = Lookup.getDefault().lookupAll(DataStorageFactory.class);
        log.fine(this.dataStorageFactories.size() + " data storage(s) found!");
        this.perstistentDataStorageFactories = Lookup.getDefault().lookupAll(PersistentDataStorageFactory.class);
        log.fine(this.dataStorageFactories.size() + " persistent data storage(s) found!");
    }

    public static DataStorageManager getInstance() {
        return instance;
    }

    public List<DataStorage> closeSession(DLightSession session) {
        if (session == null) {
            return null;
        }
        List<DataStorage> storages = this.activeDataStorages.get(session);
        if (storages != null) {
            for (DataStorage storage : storages) {
                if (!storage.shutdown()) {
                    log.finest("DataStorage " + storage + " is not closed");
                    continue;
                }
                log.finest("DataStorage " + storage + " successfully closed");
            }
        }
        return this.activeDataStorages.remove(session);
    }

    public void clearActiveStorages(DLightSession session) {
        List<DataStorage> storages = this.activeDataStorages.get(session);
        if (storages != null) {
            storages.clear();
        }
        this.lastSession = session;
    }

    public Map<DataStorageType, DataStorage> getDataStoragesFor(DLightSession session, DataCollector<?> collector) {
        HashMap<DataStorageType, DataStorage> result = new HashMap<DataStorageType, DataStorage>();
        for (DataStorageType type : collector.getRequiredDataStorageTypes()) {
            result.put(type, this.getDataStorageFor(session, type, collector.getDataTablesMetadata()));
        }
        return result;
    }

    public synchronized ServiceInfoDataStorage getServiceInfoDataStorageFor(String uniqueKey) {
        if (uniqueKey == null) {
            return null;
        }
        ServiceInfoDataStorage result = this.serviceInfoStorages.get(uniqueKey);
        if (result == null) {
            result = new ServiceInfoDataStorageImpl();
            this.serviceInfoStorages.put(uniqueKey, result);
        }
        return result;
    }

    public synchronized Collection<DataStorage> getStorages(String uniqueKey) {
        if (uniqueKey == null) {
            return null;
        }
        ArrayList<DataStorage> result = (ArrayList<DataStorage>)this.activeStorages.get(uniqueKey);
        if (result != null) {
            return result;
        }
        result = new ArrayList<DataStorage>();
        for (PersistentDataStorageFactory persistentDataStorageFactory : this.perstistentDataStorageFactories) {
            try {
                PersistentDataStorage storage = persistentDataStorageFactory.openStorage(uniqueKey);
                if (storage == null) continue;
                result.add((DataStorage)storage);
            }
            catch (Throwable e) {}
        }
        return result;
    }

    private synchronized DataStorage getDataStorage(String uniqueKey, DataStorageType storageType, List<DataTableMetadata> tableMetadatas) {
        if (uniqueKey == null) {
            return null;
        }
        List<DataStorage> uniqueStorages = this.activeStorages.get(uniqueKey);
        if (uniqueStorages != null) {
            for (DataStorage dataStorage : uniqueStorages) {
                if (!dataStorage.supportsType(storageType)) continue;
                dataStorage.createTables(tableMetadatas);
                return dataStorage;
            }
        }
        if (this.perstistentDataStorageFactories != null) {
            for (PersistentDataStorageFactory persistentDataStorageFactory : this.perstistentDataStorageFactories) {
                if (!persistentDataStorageFactory.getStorageTypes().contains(storageType)) continue;
                PersistentDataStorage newStorage = persistentDataStorageFactory.openStorage(uniqueKey);
                if (newStorage != null) {
                    if (newStorage instanceof ProxyDataStorage) {
                        ProxyDataStorage proxyStorage = (ProxyDataStorage)newStorage;
                        DataStorage backendStorage = this.getDataStorage(uniqueKey, proxyStorage.getBackendDataStorageType(), proxyStorage.getBackendTablesMetadata());
                        proxyStorage.attachTo(backendStorage);
                    }
                    newStorage.createTables(tableMetadatas);
                    if (uniqueStorages == null) {
                        uniqueStorages = new ArrayList<DataStorage>();
                    }
                    uniqueStorages.add((DataStorage)newStorage);
                    this.activeStorages.put(uniqueKey, uniqueStorages);
                    return newStorage;
                }
                newStorage = persistentDataStorageFactory.createStorage(uniqueKey);
                if (newStorage instanceof ProxyDataStorage) {
                    ProxyDataStorage proxyStorage = (ProxyDataStorage)newStorage;
                    DataStorage backendStorage = this.getDataStorage(uniqueKey, proxyStorage.getBackendDataStorageType(), proxyStorage.getBackendTablesMetadata());
                    proxyStorage.attachTo(backendStorage);
                }
                newStorage.createTables(tableMetadatas);
                if (uniqueStorages == null) {
                    uniqueStorages = new ArrayList<DataStorage>();
                }
                uniqueStorages.add((DataStorage)newStorage);
                this.activeStorages.put(uniqueKey, uniqueStorages);
                return newStorage;
            }
        } else {
            for (DataStorageFactory dataStorageFactory : this.dataStorageFactories) {
                if (!(dataStorageFactory instanceof PersistentDataStorageFactory) || !dataStorageFactory.getStorageTypes().contains(storageType)) continue;
                PersistentDataStorage newStorage = ((PersistentDataStorageFactory)dataStorageFactory).openStorage(uniqueKey);
                if (newStorage instanceof ProxyDataStorage) {
                    ProxyDataStorage proxyStorage = (ProxyDataStorage)newStorage;
                    DataStorage backendStorage = this.getDataStorage(uniqueKey, proxyStorage.getBackendDataStorageType(), proxyStorage.getBackendTablesMetadata());
                    proxyStorage.attachTo(backendStorage);
                }
                if (newStorage == null) continue;
                newStorage.createTables(tableMetadatas);
                if (uniqueStorages == null) {
                    uniqueStorages = new ArrayList<DataStorage>();
                }
                uniqueStorages.add((DataStorage)newStorage);
                this.activeStorages.put(uniqueKey, uniqueStorages);
                return newStorage;
            }
        }
        return null;
    }

    private DataStorage getDataStorageFor(DLightSession session, DataStorageType storageType, List<DataTableMetadata> tableMetadatas) {
        if (session == null) {
            return null;
        }
        DLightSessionAccessor accessor = DLightSessionAccessor.getDefault();
        if (accessor.isUsingSharedStorage(session)) {
            return this.getDataStorage(accessor.getSharedStorageUniqueKey(session), storageType, tableMetadatas);
        }
        List<DataStorage> activeSessionStorages = this.activeDataStorages.get(session);
        if (activeSessionStorages != null) {
            for (DataStorage dataStorage : activeSessionStorages) {
                if (!dataStorage.supportsType(storageType)) continue;
                dataStorage.createTables(tableMetadatas);
                return dataStorage;
            }
        }
        for (DataStorageFactory dataStorageFactory : this.dataStorageFactories) {
            if (!dataStorageFactory.getStorageTypes().contains(storageType)) continue;
            DataStorage newStorage = dataStorageFactory.createStorage();
            if (newStorage instanceof ProxyDataStorage) {
                ProxyDataStorage proxyStorage = (ProxyDataStorage)newStorage;
                DataStorage backendStorage = this.getDataStorageFor(session, proxyStorage.getBackendDataStorageType(), proxyStorage.getBackendTablesMetadata());
                proxyStorage.attachTo(backendStorage);
            }
            if (newStorage == null) continue;
            newStorage.createTables(tableMetadatas);
            if (activeSessionStorages == null) {
                activeSessionStorages = new ArrayList<DataStorage>();
            }
            activeSessionStorages.add(newStorage);
            this.activeDataStorages.put(session, activeSessionStorages);
            return newStorage;
        }
        return null;
    }
}

