/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.editor.ext.html.parser.AstNode;

public class AstPath {
    private AstNode first;
    private AstNode last;

    AstPath(AstNode first, AstNode last) {
        this.first = first;
        this.last = last;
    }

    public AstNode first() {
        return this.first;
    }

    public AstNode last() {
        return this.last;
    }

    public List<AstNode> path() {
        ArrayList<AstNode> path = new ArrayList<AstNode>();
        for (AstNode node = this.last; node != null; node = node.parent()) {
            path.add(node);
            if (node == this.first) break;
        }
        return path;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (AstNode node : this.path()) {
            AstNode parent = node.parent();
            int myIndex = parent == null ? 0 : AstPath.indexInSimilarNodes(node.parent(), node);
            sb.append(node.name() + "[" + (Object)((Object)node.type()) + "]( " + myIndex + ")/");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AstPath)) {
            return false;
        }
        AstPath path = (AstPath)o;
        List<AstNode> p1 = this.path();
        List<AstNode> p2 = path.path();
        if (p1.size() != p2.size()) {
            return false;
        }
        for (int i = 0; i < p1.size(); ++i) {
            int n2Index;
            AstNode n1 = p1.get(i);
            AstNode n2 = p2.get(i);
            AstNode n1Parent = n1.parent();
            AstNode n2Parent = n2.parent();
            if (n1Parent == null && n2Parent == null) continue;
            int n1Index = AstPath.indexInSimilarNodes(n1Parent, n1);
            if (n1Index != (n2Index = AstPath.indexInSimilarNodes(n2Parent, n2))) {
                return false;
            }
            if (n1.signature().equals(n2.signature())) continue;
            return false;
        }
        return true;
    }

    public static int indexInSimilarNodes(AstNode parent, AstNode node) {
        int index = -1;
        for (AstNode child : parent.children()) {
            if (node.name().equals(child.name()) && node.type() == child.type()) {
                ++index;
            }
            if (child != node) continue;
            break;
        }
        return index;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.first != null ? this.first.hashCode() : 0);
        hash = 47 * hash + (this.last != null ? this.last.hashCode() : 0);
        return hash;
    }

    public static boolean isDescendant(AstNode amcestor, AstNode descendant) {
        if (amcestor == descendant) {
            return false;
        }
        AstNode node = descendant;
        while ((node = node.parent()) != null) {
            if (amcestor != node) continue;
            return true;
        }
        return false;
    }
}

