/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import org.netbeans.modules.cnd.discovery.wizard.ConsolidationStrategyWizard;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ConsolidationStrategyPanel
extends JPanel {
    private ConsolidationStrategyWizard wizard;
    public static final String PROJECT_LEVEL = "project";
    public static final String FOLDER_LEVEL = "folder";
    public static final String FILE_LEVEL = "file";
    private String level = "file";
    private ButtonGroup consolidationGroup;
    private JRadioButton fileConsolidation;
    private JRadioButton folderConsolidation;
    private JPanel instructionPanel;
    private JTextArea instructionsTextArea;
    private JLabel jLabel1;
    private JRadioButton projectConsolidation;

    public ConsolidationStrategyPanel(ConsolidationStrategyWizard wizard) {
        this.wizard = wizard;
        this.initComponents();
        this.addListeners();
        this.fileConsolidation.setSelected(true);
        this.update(FILE_LEVEL);
    }

    private void addListeners() {
        this.fileConsolidation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsolidationStrategyPanel.this.update(ConsolidationStrategyPanel.FILE_LEVEL);
            }
        });
        this.folderConsolidation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsolidationStrategyPanel.this.update(ConsolidationStrategyPanel.FOLDER_LEVEL);
            }
        });
        this.projectConsolidation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsolidationStrategyPanel.this.update(ConsolidationStrategyPanel.PROJECT_LEVEL);
            }
        });
    }

    void read(DiscoveryDescriptor wizardDescriptor) {
    }

    void store(DiscoveryDescriptor wizardDescriptor) {
        wizardDescriptor.setLevel(this.level);
    }

    boolean valid(DiscoveryDescriptor settings) {
        return true;
    }

    private void update(String level) {
        this.level = level;
        this.wizard.stateChanged(null);
        String description = NbBundle.getMessage(ConsolidationStrategyPanel.class, (String)("ConsolidationDescription_" + level));
        this.instructionsTextArea.setText(description);
    }

    private void initComponents() {
        this.consolidationGroup = new ButtonGroup();
        this.instructionPanel = new JPanel();
        this.instructionsTextArea = new JTextArea();
        this.projectConsolidation = new JRadioButton();
        this.folderConsolidation = new JRadioButton();
        this.fileConsolidation = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.instructionPanel.setLayout(new GridBagLayout());
        this.instructionPanel.setVerifyInputWhenFocusTarget(false);
        this.instructionsTextArea.setBackground(this.instructionPanel.getBackground());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setWrapStyleWord(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.instructionPanel.add((Component)this.instructionsTextArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.instructionPanel, gridBagConstraints);
        this.consolidationGroup.add(this.projectConsolidation);
        Mnemonics.setLocalizedText((AbstractButton)this.projectConsolidation, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle").getString("ConsolidateToProjectLabel"));
        this.projectConsolidation.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.projectConsolidation.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 12, 0, 0);
        this.add((Component)this.projectConsolidation, gridBagConstraints);
        this.consolidationGroup.add(this.folderConsolidation);
        Mnemonics.setLocalizedText((AbstractButton)this.folderConsolidation, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle").getString("ConsolidateToFolderLabel"));
        this.folderConsolidation.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.folderConsolidation.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 12, 0, 0);
        this.add((Component)this.folderConsolidation, gridBagConstraints);
        this.consolidationGroup.add(this.fileConsolidation);
        Mnemonics.setLocalizedText((AbstractButton)this.fileConsolidation, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle").getString("FileConsolidateLabel"));
        this.fileConsolidation.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fileConsolidation.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 12, 0, 0);
        this.add((Component)this.fileConsolidation, gridBagConstraints);
        this.jLabel1.setLabelFor(this.projectConsolidation);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle").getString("ConsolidationLevelText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel1, gridBagConstraints);
    }
}

