/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.QmakeConfiguration;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.EnvUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;

public abstract class QtInfoProvider {
    private static final QtInfoProvider DEFAULT = new Default();
    private static final Logger LOGGER = Logger.getLogger(QtInfoProvider.class.getName());

    private QtInfoProvider() {
    }

    public static QtInfoProvider getDefault() {
        return DEFAULT;
    }

    public abstract List<String> getQtIncludeDirectories(MakeConfiguration var1);

    private static class Default
    extends QtInfoProvider {
        private final Map<String, String> cache = new HashMap<String, String>();

        private Default() {
        }

        @Override
        public List<String> getQtIncludeDirectories(MakeConfiguration conf) {
            List<String> result;
            String baseDir = this.getBaseQtIncludeDir(conf);
            if (baseDir != null) {
                String uiDir;
                result = new ArrayList();
                result.add(baseDir);
                QmakeConfiguration qmakeConfiguration = conf.getQmakeConfiguration();
                if (qmakeConfiguration.isCoreEnabled().getValue()) {
                    result.add(baseDir + File.separator + "QtCore");
                }
                if (qmakeConfiguration.isGuiEnabled().getValue()) {
                    result.add(baseDir + File.separator + "QtGui");
                }
                if (qmakeConfiguration.isNetworkEnabled().getValue()) {
                    result.add(baseDir + File.separator + "QtNetwork");
                }
                if (qmakeConfiguration.isOpenglEnabled().getValue()) {
                    result.add(baseDir + File.separator + "QtOpenGL");
                }
                if (qmakeConfiguration.isPhononEnabled().getValue()) {
                    result.add(baseDir + File.separator + "phonon");
                }
                if (qmakeConfiguration.isQt3SupportEnabled().getValue()) {
                    result.add(baseDir + File.separator + "Qt3Support");
                }
                if (qmakeConfiguration.isSqlEnabled().getValue()) {
                    result.add(baseDir + File.separator + "QtSql");
                }
                if (qmakeConfiguration.isSvgEnabled().getValue()) {
                    result.add(baseDir + File.separator + "QtSvg");
                }
                if (qmakeConfiguration.isXmlEnabled().getValue()) {
                    result.add(baseDir + File.separator + "QtXml");
                }
                if (qmakeConfiguration.isWebkitEnabled().getValue()) {
                    result.add(baseDir + File.separator + "QtWebKit");
                }
                if (CndPathUtilitities.isPathAbsolute((String)(uiDir = qmakeConfiguration.getUiDir().getValue()))) {
                    result.add(uiDir);
                } else {
                    result.add(conf.getBaseDir() + File.separator + uiDir);
                }
            } else {
                result = Collections.emptyList();
            }
            return result;
        }

        private static String getQmakePath(MakeConfiguration conf) {
            Tool qmakeTool;
            CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
            if (compilerSet != null && (qmakeTool = compilerSet.getTool((ToolKind)PredefinedToolKind.QMakeTool)) != null && 0 < qmakeTool.getPath().length()) {
                return qmakeTool.getPath();
            }
            return "qmake";
        }

        private static String getCacheKey(MakeConfiguration conf) {
            return conf.getDevelopmentHost().getHostKey() + '/' + Default.getQmakePath(conf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getBaseQtIncludeDir(MakeConfiguration conf) {
            String baseDir;
            String cacheKey = Default.getCacheKey(conf);
            Map<String, String> map = this.cache;
            synchronized (map) {
                if (this.cache.containsKey(cacheKey)) {
                    baseDir = this.cache.get(cacheKey);
                } else {
                    ExecutionEnvironment execEnv = conf.getDevelopmentHost().getExecutionEnvironment();
                    String qmakePath = Default.getQmakePath(conf);
                    if (ConnectionManager.getInstance().isConnectedTo(execEnv)) {
                        baseDir = Default.queryBaseQtIncludeDir(execEnv, qmakePath);
                        if (baseDir != null && execEnv.isRemote()) {
                            baseDir = CndUtils.getIncludeFilePrefix((String)EnvUtils.toHostID((ExecutionEnvironment)execEnv)) + baseDir;
                        }
                        this.cache.put(cacheKey, baseDir);
                    } else {
                        baseDir = CndUtils.getIncludeFilePrefix((String)EnvUtils.toHostID((ExecutionEnvironment)execEnv)) + Default.guessBaseQtIncludeDir(qmakePath);
                    }
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Qt include dir for {0} = {1}", new Object[]{cacheKey, baseDir});
            }
            return baseDir;
        }

        private static String queryBaseQtIncludeDir(ExecutionEnvironment execEnv, String qmakePath) {
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv);
            npb.setExecutable(qmakePath);
            npb.setArguments(new String[]{"-query", "QT_INSTALL_HEADERS"});
            try {
                NativeProcess process = npb.call();
                String output = ProcessUtils.readProcessOutputLine((Process)process).trim();
                if (process.waitFor() == 0 && 0 < output.length()) {
                    return output;
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            return null;
        }

        private static String guessBaseQtIncludeDir(String qmakePath) {
            String baseDir;
            String binDir = CndPathUtilitities.getDirName((String)qmakePath);
            if (binDir != null && (baseDir = CndPathUtilitities.getDirName((String)binDir)) != null) {
                return baseDir + "/include/qt4";
            }
            return "/usr/include/qt4";
        }
    }
}

