/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.refactoring;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.netbeans.modules.html.editor.refactoring.DeclarationItem;
import org.netbeans.modules.html.editor.refactoring.ResolveDeclarationItem;
import org.openide.util.NbBundle;

public class ResolveDeclarationsPanel
extends JPanel {
    private List<ResolveDeclarationItem> items;
    private List<JComboBox> combos;
    private JPanel contentPanel;

    public ResolveDeclarationsPanel(Collection<ResolveDeclarationItem> items) {
        this.items = new ArrayList<ResolveDeclarationItem>(items);
        this.initComponents();
        this.initComponentsMore();
        this.setAccessible();
    }

    private void initComponentsMore() {
        this.contentPanel.setLayout(new GridBagLayout());
        this.contentPanel.setBackground(UIManager.getColor("Table.background"));
        int row = 0;
        this.combos = new ArrayList<JComboBox>(this.items.size());
        Font monoSpaced = new Font("Monospaced", 0, new JLabel().getFont().getSize());
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Component c = e.getComponent();
                Rectangle r = c.getBounds();
                ResolveDeclarationsPanel.this.contentPanel.scrollRectToVisible(r);
            }
        };
        for (int i = 0; i < this.items.size(); ++i) {
            ResolveDeclarationItem item = this.items.get(i);
            JComboBox jComboBox = this.createComboBox(item, monoSpaced, focusListener);
            this.combos.add(jComboBox);
            JLabel lblSimpleName = new JLabel(item.getName());
            lblSimpleName.setOpaque(false);
            lblSimpleName.setFont(monoSpaced);
            lblSimpleName.setLabelFor(jComboBox);
            this.contentPanel.add((Component)lblSimpleName, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 2, 5), 0, 0));
            this.contentPanel.add((Component)jComboBox, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 5, 2, 5), 0, 0));
        }
        this.contentPanel.add((Component)new JLabel(), new GridBagConstraints(2, row, 2, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        Dimension d = this.contentPanel.getPreferredSize();
        d.height = this.getRowHeight() * Math.min(this.combos.size(), 6);
    }

    private JComboBox createComboBox(ResolveDeclarationItem resolveDeclarationItem, Font font, FocusListener listener) {
        List<DeclarationItem> declarations = resolveDeclarationItem.getPossibleDeclarations();
        if (declarations.isEmpty()) {
            JComboBox<String> combo = new JComboBox<String>(new String[]{NbBundle.getMessage(ResolveDeclarationItem.class, (String)"MSG_No_Selector_Definion")});
            combo.setEnabled(false);
            return combo;
        }
        String[] choices = new String[declarations.size()];
        for (int i = 0; i < choices.length; ++i) {
            String lineText;
            DeclarationItem item = declarations.get(i);
            StringBuilder b = new StringBuilder();
            b.append(item.getSource().getNameExt());
            int line = item.getDeclaration().entry().getLineOffset();
            if (line != -1) {
                b.append(':');
                b.append(line);
            }
            if ((lineText = ((Object)item.getDeclaration().entry().getLineText()).toString()) != null) {
                b.append(" (");
                b.append(lineText.trim());
                b.append(')');
            }
            choices[i] = b.toString();
        }
        JComboBox<String> combo = new JComboBox<String>(choices);
        combo.setOpaque(false);
        combo.setFont(font);
        combo.addFocusListener(listener);
        combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    JComboBox source = (JComboBox)e.getSource();
                    int sourceComboIndex = ResolveDeclarationsPanel.this.combos.indexOf(source);
                    ResolveDeclarationItem resolveDeclarationItem = (ResolveDeclarationItem)ResolveDeclarationsPanel.this.items.get(sourceComboIndex);
                    int selectedTargetIndex = source.getSelectedIndex();
                    DeclarationItem selectedItem = resolveDeclarationItem.getPossibleDeclarations().get(selectedTargetIndex);
                    resolveDeclarationItem.resolve(selectedItem);
                }
            }
        });
        combo.setEnabled(choices.length > 1);
        combo.setSelectedIndex(0);
        resolveDeclarationItem.resolve(resolveDeclarationItem.getPossibleDeclarations().get(0));
        InputMap inputMap = combo.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "showPopup");
        combo.getActionMap().put("showPopup", new TogglePopupAction());
        return combo;
    }

    private int getRowHeight() {
        return this.combos.size() == 0 ? 0 : this.combos.get((int)0).getPreferredSize().height + 6;
    }

    private void setAccessible() {
    }

    private void initComponents() {
        this.contentPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new GridBagLayout());
        this.add((Component)this.contentPanel, "Center");
    }

    private static class TogglePopupAction
    extends AbstractAction {
        private TogglePopupAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() instanceof JComboBox) {
                JComboBox combo;
                combo.setPopupVisible(!(combo = (JComboBox)e.getSource()).isPopupVisible());
            }
        }
    }
}

