/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup.implspi;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ActiveQueue {
    private static final Logger LOGGER = Logger.getLogger(ActiveQueue.class.getName().replace('$', '.'));
    private static Impl activeReferenceQueue;

    private ActiveQueue() {
    }

    public static synchronized ReferenceQueue<Object> queue() {
        if (activeReferenceQueue == null) {
            activeReferenceQueue = new Impl();
        }
        activeReferenceQueue.ping();
        return activeReferenceQueue;
    }

    private static final class Impl
    extends ReferenceQueue<Object>
    implements Runnable {
        private int count;

        Impl() {
        }

        @Override
        public Reference<Object> poll() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Reference<Object> remove(long timeout) throws IllegalArgumentException, InterruptedException {
            throw new InterruptedException();
        }

        @Override
        public Reference<Object> remove() throws InterruptedException {
            throw new InterruptedException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Reference ref;
                    while (true) {
                        ref = super.remove(0L);
                        LOGGER.finer("dequeued reference");
                        if (ref instanceof Runnable) break;
                        LOGGER.log(Level.WARNING, "A reference not implementing runnable has been added to the Utilities.activeReferenceQueue(): {0}", ref.getClass());
                    }
                    try {
                        ((Runnable)((Object)ref)).run();
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        LOGGER.log(Level.WARNING, null, t);
                    }
                    finally {
                        ref = null;
                    }
                }
                catch (InterruptedException ex) {
                    continue;
                }
                Impl impl = this;
                synchronized (impl) {
                    assert (this.count > 0);
                    --this.count;
                    if (this.count == 0) {
                        LOGGER.fine("stopping thread");
                        break;
                    }
                }
            }
        }

        synchronized void ping() {
            if (this.count == 0) {
                Thread t = new Thread((Runnable)this, "Active Reference Queue Daemon");
                t.setPriority(1);
                t.setDaemon(true);
                t.start();
                LOGGER.fine("starting thread");
            } else {
                LOGGER.finer("enqueuing reference");
            }
            ++this.count;
        }
    }
}

