/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;

public class StringReferenceInitializer
extends SimplifiedVisitor
implements ConstantVisitor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;

    public StringReferenceInitializer(ClassPool classPool, ClassPool classPool2) {
        this.programClassPool = classPool;
        this.libraryClassPool = classPool2;
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        if (stringConstant.referencedClass == null) {
            stringConstant.referencedClass = this.findClass(ClassUtil.internalClassName(stringConstant.getString(clazz)));
        }
    }

    private Clazz findClass(String string) {
        Clazz clazz = this.programClassPool.getClass(string);
        if (clazz == null) {
            clazz = this.libraryClassPool.getClass(string);
        }
        return clazz;
    }
}

