/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.loaders;

import java.io.IOException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.loaders.DataObject;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

final class ExternalProgramOpenCookie
implements OpenCookie {
    private final DataObject dao;
    private final String program;
    private final String failmsg;

    public ExternalProgramOpenCookie(DataObject dao, String program, String failmsg) {
        Parameters.notNull((CharSequence)"dao", (Object)dao);
        Parameters.notNull((CharSequence)"program", (Object)program);
        this.dao = dao;
        this.program = program;
        this.failmsg = failmsg;
    }

    public void open() {
        boolean success = false;
        ProcessBuilder pb = new ProcessBuilder(this.program, this.dao.getPrimaryFile().getPath());
        try {
            pb.start();
            success = true;
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (!success && Utilities.isMac()) {
            pb = new ProcessBuilder("open", "-a", this.program, this.dao.getPrimaryFile().getPath());
            try {
                int exitCode = pb.start().waitFor();
                success = exitCode == 0;
            }
            catch (IOException ex) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!success && this.failmsg != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)this.failmsg));
        }
    }
}

