/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.util.List;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.refactoring.HibernateMappingRenameTransaction;
import org.netbeans.modules.hibernate.refactoring.HibernateRefactoringUtil;
import org.netbeans.modules.hibernate.refactoring.HibernateRenameRefactoringElement;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class HibernateMappingRenamePlugin
implements RefactoringPlugin {
    private RenameRefactoring refactoring;
    private FileObject fo;
    private String oldResourceName;
    private String newResourceName;

    public HibernateMappingRenamePlugin(RenameRefactoring renameRefactoring) {
        this.refactoring = renameRefactoring;
        this.fo = (FileObject)renameRefactoring.getRefactoringSource().lookup(FileObject.class);
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        Project project;
        HibernateEnvironment hibernateEnvironment;
        List<String> list;
        String string;
        Problem problem = null;
        String string2 = this.fo.getName();
        if (string2.equals(string = this.refactoring.getNewName())) {
            problem = HibernateRefactoringUtil.createProblem(problem, true, NbBundle.getMessage(HibernateMappingRenamePlugin.class, (String)"MSG_NameNotChanged"));
            return problem;
        }
        if (!HibernateRefactoringUtil.isValidMappingFileName(string)) {
            problem = HibernateRefactoringUtil.createProblem(problem, true, NbBundle.getMessage(HibernateMappingRenamePlugin.class, (String)"MSG_Invalid_Name"));
        }
        this.getOldNewResourceName();
        if (this.oldResourceName == null || this.newResourceName == null) {
            problem = HibernateRefactoringUtil.createProblem(problem, true, NbBundle.getMessage(HibernateMappingRenamePlugin.class, (String)"MSG_Invalid_Name"));
        }
        if ((list = (hibernateEnvironment = (HibernateEnvironment)(project = FileOwnerQuery.getOwner((FileObject)this.fo)).getLookup().lookup(HibernateEnvironment.class)).getAllHibernateMappings()).contains(this.newResourceName)) {
            problem = HibernateRefactoringUtil.createProblem(problem, true, NbBundle.getMessage(HibernateMappingRenamePlugin.class, (String)"MSG_NameNotUnique", (Object)string));
        }
        return problem;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        if (this.fo == null || !this.fo.getMIMEType().equals("text/x-hibernate-mapping+xml")) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)this.fo);
        HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
        List<FileObject> list = hibernateEnvironment.getAllHibernateConfigFileObjects();
        if (list.isEmpty()) {
            return null;
        }
        Map<FileObject, List<HibernateRefactoringUtil.OccurrenceItem>> map = HibernateRefactoringUtil.getMappingResourceOccurrences(list, this.oldResourceName, false);
        for (FileObject fileObject : map.keySet()) {
            List<HibernateRefactoringUtil.OccurrenceItem> list2 = map.get(fileObject);
            for (HibernateRefactoringUtil.OccurrenceItem occurrenceItem : list2) {
                HibernateRenameRefactoringElement hibernateRenameRefactoringElement = new HibernateRenameRefactoringElement(fileObject, this.oldResourceName, this.newResourceName, occurrenceItem.getLocation(), occurrenceItem.getText());
                refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)hibernateRenameRefactoringElement);
            }
        }
        refactoringElementsBag.registerTransaction((Transaction)new HibernateMappingRenameTransaction(map.keySet(), this.oldResourceName, this.newResourceName));
        return null;
    }

    private void getOldNewResourceName() {
        Project project = FileOwnerQuery.getOwner((FileObject)this.fo);
        SourceGroup[] sourceGroupArray = SourceGroups.getJavaSourceGroups((Project)project);
        if (sourceGroupArray.length == 0) {
            return;
        }
        String string = sourceGroupArray[0].getRootFolder().getPath();
        String string2 = this.fo.getPath();
        this.oldResourceName = string2.substring(string.length() + 1);
        String string3 = this.oldResourceName.substring(0, this.oldResourceName.lastIndexOf("/") + 1);
        this.newResourceName = string3 + this.refactoring.getNewName() + ".xml";
    }
}

