/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.loaders.cfg.multiview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.hibernate.cfg.HibernateCfgProperties;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.Util;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertyPanel
extends JPanel
implements ActionListener {
    private JTextField valueTextField = null;
    private JComboBox valueComboBox = null;
    private JComboBox nameComboBox;
    private JLabel nameLabel;
    private JLabel valueLabel;
    private JPanel valuePanel;

    public PropertyPanel(String string, boolean bl, SessionFactory sessionFactory, String string2, String string3) {
        this.initComponents();
        if (bl) {
            this.nameComboBox.setModel(new DefaultComboBoxModel<String>(Util.getAvailPropNames(string, sessionFactory)));
        } else {
            this.nameComboBox.setModel(new DefaultComboBoxModel<String>(Util.getAllPropNames(string)));
            this.nameComboBox.setSelectedItem(string2);
        }
        this.valueTextField = new JTextField();
        this.valueComboBox = new JComboBox();
        String string4 = (String)this.nameComboBox.getSelectedItem();
        this.addValueComponent(string4, string3);
        this.nameComboBox.addActionListener(this);
        this.nameComboBox.setEnabled(bl);
    }

    public void addNameComboBoxListener(ActionListener actionListener) {
        this.nameComboBox.addActionListener(actionListener);
    }

    public void addValueComponent(String string, String string2) {
        this.valuePanel.removeAll();
        Object object = HibernateCfgProperties.getPossiblePropertyValue(string);
        if (object == null) {
            this.valuePanel.add((Component)this.valueTextField, "Center");
            this.valueTextField.setText(string2);
        } else if (object instanceof String[]) {
            this.valueComboBox.setModel(new DefaultComboBoxModel<String>((String[])object));
            this.valueComboBox.setEditable(true);
            this.valuePanel.add((Component)this.valueComboBox, "Center");
            if (string2 != null) {
                this.valueComboBox.setSelectedItem(string2);
            } else {
                this.valueComboBox.setSelectedIndex(0);
            }
        }
        this.revalidate();
        this.repaint();
    }

    public JTextField getValueTextField() {
        return this.valueTextField;
    }

    public JTextField getValueComboBoxTextField() {
        return (JTextField)this.valueComboBox.getEditor().getEditorComponent();
    }

    public String getPropertyName() {
        return (String)this.nameComboBox.getSelectedItem();
    }

    public String getPropertyValue() {
        Object object = HibernateCfgProperties.getPossiblePropertyValue(this.getPropertyName());
        if (object == null) {
            return this.getValueTextField().getText().trim();
        }
        return this.getValueComboBoxTextField().getText().trim();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComboBox jComboBox = (JComboBox)actionEvent.getSource();
        String string = (String)jComboBox.getSelectedItem();
        this.addValueComponent(string, null);
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.valueLabel = new JLabel();
        this.nameComboBox = new JComboBox();
        this.valuePanel = new JPanel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(PropertyPanel.class, (String)"PropertyPanel.nameLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.nameLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.valueLabel, (String)NbBundle.getMessage(PropertyPanel.class, (String)"PropertyPanel.valueLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.valueLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 12);
        this.add((Component)this.nameComboBox, gridBagConstraints);
        this.valuePanel.setPreferredSize(new Dimension(27, 22));
        this.valuePanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 12);
        this.add((Component)this.valuePanel, gridBagConstraints);
    }

    private class ValueComboBoxEditor
    implements ComboBoxEditor {
        JTextField textField = null;

        ValueComboBoxEditor(JTextField jTextField) {
            this.textField = jTextField;
        }

        @Override
        public Component getEditorComponent() {
            return this.textField;
        }

        @Override
        public void setItem(Object object) {
            this.textField.setText((String)object);
        }

        @Override
        public Object getItem() {
            return this.textField.getText().trim();
        }

        @Override
        public void selectAll() {
            this.textField.selectAll();
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
            this.textField.addActionListener(actionListener);
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
            this.textField.removeActionListener(actionListener);
        }
    }
}

