/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.maven.execute.JavaOutputHandler;
import org.openide.util.io.NullOutputStream;

public class IOBridge {
    private static int delegating = 0;
    private static InputStream origIn;
    private static PrintStream origOut;
    private static PrintStream origErr;
    private static Map<ThreadGroup, InputStream> delegateIns;
    private static Map<ThreadGroup, PrintStream> delegateOuts;
    private static Map<ThreadGroup, PrintStream> delegateErrs;
    private static List<Thread> suspendedDelegationTasks;

    static synchronized void pushSystemInOutErr(JavaOutputHandler ioput) {
        if (delegating++ == 0) {
            origIn = System.in;
            origOut = System.out;
            origErr = System.err;
            System.setIn(new MultiplexInputStream());
            System.setOut(new MultiplexPrintStream(false));
            System.setErr(new MultiplexPrintStream(true));
        }
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        delegateIns.put(tg, ioput.getIn());
        delegateOuts.put(tg, ioput.getOut());
        delegateErrs.put(tg, ioput.getErr());
    }

    public static synchronized void restoreSystemInOutErr() {
        assert (delegating > 0);
        if (--delegating == 0) {
            System.setIn(origIn);
            System.setOut(origOut);
            System.setErr(origErr);
            origIn = null;
            origOut = null;
            origErr = null;
        }
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        delegateIns.remove(tg);
        delegateOuts.remove(tg);
        delegateErrs.remove(tg);
    }

    public static synchronized void suspendDelegation() {
        Thread t = Thread.currentThread();
        suspendedDelegationTasks.add(t);
    }

    public static synchronized void resumeDelegation() {
        Thread t = Thread.currentThread();
        assert (suspendedDelegationTasks.contains(t)) : "Have not suspended delegation in " + t;
        suspendedDelegationTasks.remove(t);
    }

    static {
        delegateIns = new HashMap<ThreadGroup, InputStream>();
        delegateOuts = new HashMap<ThreadGroup, PrintStream>();
        delegateErrs = new HashMap<ThreadGroup, PrintStream>();
        suspendedDelegationTasks = new ArrayList<Thread>();
    }

    private static final class MultiplexPrintStream
    extends PrintStream {
        private final boolean err;

        public MultiplexPrintStream(boolean err) {
            this(new NullOutputStream(), err);
        }

        private MultiplexPrintStream(NullOutputStream nos, boolean err) {
            super((OutputStream)nos);
            nos.throwException = true;
            this.err = err;
        }

        private PrintStream delegate() {
            ThreadGroup tg;
            Map delegates;
            Thread t = Thread.currentThread();
            Map map = delegates = this.err ? delegateErrs : delegateOuts;
            for (tg = t.getThreadGroup(); tg != null && !delegates.containsKey(tg); tg = tg.getParent()) {
            }
            PrintStream ps = (PrintStream)delegates.get(tg);
            if (ps != null && !suspendedDelegationTasks.contains(t)) {
                return ps;
            }
            if (delegating > 0) {
                PrintStream orig;
                PrintStream printStream = orig = this.err ? origErr : origOut;
                assert (orig != null);
                return orig;
            }
            return this.err ? System.err : System.out;
        }

        @Override
        public boolean checkError() {
            return this.delegate().checkError();
        }

        @Override
        public void close() {
            this.delegate().close();
        }

        @Override
        public void flush() {
            this.delegate().flush();
        }

        @Override
        public void print(long l) {
            this.delegate().print(l);
        }

        @Override
        public void print(char[] s) {
            this.delegate().print(s);
        }

        @Override
        public void print(int i) {
            this.delegate().print(i);
        }

        @Override
        public void print(boolean b) {
            this.delegate().print(b);
        }

        @Override
        public void print(char c) {
            this.delegate().print(c);
        }

        @Override
        public void print(float f) {
            this.delegate().print(f);
        }

        @Override
        public void print(double d) {
            this.delegate().print(d);
        }

        @Override
        public void print(Object obj) {
            this.delegate().print(obj);
        }

        @Override
        public void print(String s) {
            this.delegate().print(s);
        }

        @Override
        public void println(double x) {
            this.delegate().println(x);
        }

        @Override
        public void println(Object x) {
            this.delegate().println(x);
        }

        @Override
        public void println(float x) {
            this.delegate().println(x);
        }

        @Override
        public void println(int x) {
            this.delegate().println(x);
        }

        @Override
        public void println(char x) {
            this.delegate().println(x);
        }

        @Override
        public void println(boolean x) {
            this.delegate().println(x);
        }

        @Override
        public void println(String x) {
            this.delegate().println(x);
        }

        @Override
        public void println(char[] x) {
            this.delegate().println(x);
        }

        @Override
        public void println() {
            this.delegate().println();
        }

        @Override
        public void println(long x) {
            this.delegate().println(x);
        }

        @Override
        public void write(int b) {
            this.delegate().write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate().write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.delegate().write(b, off, len);
        }
    }

    private static final class MultiplexInputStream
    extends InputStream {
        private InputStream delegate() {
            ThreadGroup tg;
            Thread t = Thread.currentThread();
            for (tg = t.getThreadGroup(); tg != null && !delegateIns.containsKey(tg); tg = tg.getParent()) {
            }
            InputStream is = (InputStream)delegateIns.get(tg);
            if (is != null && !suspendedDelegationTasks.contains(t)) {
                return is;
            }
            if (delegating > 0) {
                assert (origIn != null);
                return origIn;
            }
            return System.in;
        }

        @Override
        public int read() throws IOException {
            return this.delegate().read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.delegate().read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate().read(b, off, len);
        }

        @Override
        public int available() throws IOException {
            return this.delegate().available();
        }

        @Override
        public boolean markSupported() {
            return this.delegate().markSupported();
        }

        @Override
        public void mark(int readlimit) {
            this.delegate().mark(readlimit);
        }

        @Override
        public void close() throws IOException {
            this.delegate().close();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate().skip(n);
        }

        @Override
        public void reset() throws IOException {
            this.delegate().reset();
        }
    }
}

