/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.io.IOException;
import java.net.URL;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.SingleCopyRefactoring;
import org.netbeans.modules.refactoring.plugins.FileHandlingFactory;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class FileCopyPlugin
implements RefactoringPlugin {
    private SingleCopyRefactoring refactoring;

    public FileCopyPlugin(SingleCopyRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    @Override
    public Problem preCheck() {
        return null;
    }

    @Override
    public Problem prepare(RefactoringElementsBag elements) {
        elements.add(this.refactoring, new CopyFile((FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class), elements.getSession()));
        return null;
    }

    @Override
    public Problem fastCheckParameters() {
        return null;
    }

    @Override
    public Problem checkParameters() {
        return null;
    }

    @Override
    public void cancelRequest() {
    }

    private class CopyFile
    extends SimpleRefactoringElementImplementation {
        private FileObject fo;
        private RefactoringSession session;
        private DataObject newOne;

        public CopyFile(FileObject fo, RefactoringSession session) {
            this.fo = fo;
            this.session = session;
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(FileCopyPlugin.class, (String)"TXT_CopyFile", (Object)this.fo.getNameExt());
        }

        @Override
        public String getDisplayText() {
            return this.getText();
        }

        @Override
        public void performChange() {
            try {
                FileObject fo = FileHandlingFactory.getOrCreateFolder((URL)FileCopyPlugin.this.refactoring.getTarget().lookup(URL.class));
                FileObject source = (FileObject)FileCopyPlugin.this.refactoring.getRefactoringSource().lookup(FileObject.class);
                DataObject dob = DataObject.find((FileObject)source);
                this.newOne = dob.copy(DataFolder.findFolder((FileObject)fo));
                this.newOne.rename(FileCopyPlugin.this.refactoring.getNewName());
                FileCopyPlugin.this.refactoring.getContext().add(this.newOne.getPrimaryFile());
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        @Override
        public void undoChange() {
            try {
                if (this.newOne != null) {
                    this.newOne.delete();
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }

        @Override
        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        @Override
        public FileObject getParentFile() {
            return this.fo;
        }

        @Override
        public PositionBounds getPosition() {
            return null;
        }
    }
}

