/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui.project;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Enumeration;
import javax.swing.DefaultButtonModel;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.KenaiPopupMenu;
import org.netbeans.modules.kenai.ui.ProjectHandleImpl;
import org.netbeans.modules.kenai.ui.dashboard.DashboardImpl;
import org.netbeans.modules.kenai.ui.project.RefreshableContentPanel;
import org.netbeans.modules.kenai.ui.project.SourcesInformationPanel;
import org.netbeans.modules.kenai.ui.project.kenaiProjectTopComponent;
import org.netbeans.modules.kenai.ui.spi.KenaiIssueAccessor;
import org.netbeans.modules.kenai.ui.spi.QueryAccessor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class IssuesInformationPanel
extends JPanel
implements RefreshableContentPanel {
    private final String WAIT_STRING = String.format("<html><table cellpadding=\"0\" border=\"0\" cellspacing=\"0\"><tr><td width=\"30\"><img src=\"%s\"></td><td>%s</td></tr></table></html>", SourcesInformationPanel.class.getResource("/org/netbeans/modules/kenai/ui/resources/wait.gif"), NbBundle.getMessage(SourcesInformationPanel.class, (String)"MSG_WAIT_ISSUES"));
    private KenaiProject instPr = null;
    private JEditorPane issuesInfoPane;

    public IssuesInformationPanel(KenaiProject proj) {
        this.initComponents();
        this.instPr = proj;
        this.issuesInfoPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    IssuesInformationPanel.this.issuesInfoPane.setToolTipText(e.getDescription());
                    IssuesInformationPanel.this.issuesInfoPane.setCursor(Cursor.getPredefinedCursor(12));
                    return;
                }
                if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    IssuesInformationPanel.this.issuesInfoPane.setToolTipText("");
                    IssuesInformationPanel.this.issuesInfoPane.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (e.getDescription().startsWith("issue:")) {
                        final String issueNumber = e.getDescription().substring(6);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                KenaiIssueAccessor.getDefault().open(IssuesInformationPanel.this.instPr, issueNumber);
                            }
                        });
                        return;
                    }
                    HtmlBrowser.URLDisplayer.getDefault().showURL(e.getURL());
                    return;
                }
            }
        });
    }

    private void registerHTMLButton(HTMLDocument htm, String elementID, ActionListener action) {
        Element e = htm.getElement(elementID);
        if (e != null) {
            AttributeSet attr = e.getAttributes();
            Enumeration<?> enu = attr.getAttributeNames();
            while (enu.hasMoreElements()) {
                Object name = enu.nextElement();
                Object value = attr.getAttribute(name);
                if (!"model".equals(name.toString())) continue;
                DefaultButtonModel model = (DefaultButtonModel)value;
                model.setActionCommand(elementID);
                model.addActionListener(action);
            }
        }
    }

    private String getRecentIssuesTable(KenaiProject instProj) {
        KenaiIssueAccessor.IssueHandle[] recentIssues = KenaiIssueAccessor.getDefault().getRecentIssues(instProj);
        if (recentIssues == null || recentIssues.length == 0) {
            return "";
        }
        String issueTable = String.format("<br><h4>%s</h4><table>", NbBundle.getMessage(IssuesInformationPanel.class, (String)"MSG_RECENTLY_OPENED"));
        for (int i = 0; i < recentIssues.length; ++i) {
            KenaiIssueAccessor.IssueHandle issue = recentIssues[i];
            issueTable = issueTable + String.format("<tr><td><a href=\"issue:%s\">%s</a></td><td>%s</td></tr>", issue.getID(), issue.getID(), issue.getDisplayName());
        }
        issueTable = issueTable + "</table>";
        return issueTable;
    }

    private String buildIssueInformation(KenaiProject instProj) throws KenaiException {
        String _appStr = String.format("<html><div class=\"section\"><h2>%s</h2>", NbBundle.getMessage(IssuesInformationPanel.class, (String)"MSG_PROJECT_ISSUES"));
        KenaiFeature[] issueTrackers = instProj.getFeatures(KenaiService.Type.ISSUES);
        if (issueTrackers.length > 0) {
            if (Thread.interrupted()) {
                return this.WAIT_STRING;
            }
            KenaiFeature itrac = issueTrackers[0];
            String type = "external.png";
            if (itrac.getService().equals("bugzilla")) {
                type = "bugzilla-logo.png";
            } else if (itrac.getService().equals("jira")) {
                type = "jira-logo.png";
            }
            if (Thread.interrupted()) {
                return this.WAIT_STRING;
            }
            _appStr = _appStr + String.format("<table cellpadding=\"0\" border=\"0\" cellspacing=\"0\"><tr><td><img src=\"%s\"></td><td width=\"10px\"></td><td><h3>%s</h3></td></tr></table><br>", IssuesInformationPanel.class.getResource("/org/netbeans/modules/kenai/ui/resources/" + type), itrac.getDisplayName() + (type.equals("external.png") ? " <i>(" + NbBundle.getMessage(IssuesInformationPanel.class, (String)"MSG_UNKNOWN_IT") + ")</i>" : ""));
            if (Thread.interrupted()) {
                return this.WAIT_STRING;
            }
            if (itrac.getService().equals("bugzilla") || itrac.getService().equals("jira")) {
                _appStr = _appStr + String.format("<h4>%s</h4>", NbBundle.getMessage(IssuesInformationPanel.class, (String)"MSG_DID_YOU_FIND_ISSUE"));
                _appStr = _appStr + "<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td>";
                _appStr = _appStr + String.format("<input id=\"find\" type=\"reset\" value=\"%s\"><br>", NbBundle.getMessage(IssuesInformationPanel.class, (String)"MSG_FIND_ISSUE"));
                _appStr = _appStr + "</td></tr><tr><td>";
                _appStr = _appStr + String.format("<input id=\"enter\" type=\"reset\" value=\"%s\"><br>", NbBundle.getMessage(IssuesInformationPanel.class, (String)"MSG_NEW_REPORT"));
                _appStr = _appStr + "</td></tr></table><br>";
            }
            _appStr = _appStr + String.format("%s:<br><p>&nbsp;&nbsp;&nbsp;&nbsp;%s&nbsp;<a href=\"%s\">%s</a></p>", NbBundle.getMessage(IssuesInformationPanel.class, (String)"MSG_ISSUE_TRACKER_ONLINE"), kenaiProjectTopComponent.linkImageHTML, itrac.getWebLocation(), itrac.getWebLocation());
            _appStr = _appStr + this.getRecentIssuesTable(instProj);
        } else {
            _appStr = _appStr + String.format("<i>%s</i>", NbBundle.getMessage(IssuesInformationPanel.class, (String)"MSG_NO_ISSUE_TRACKERS"));
        }
        _appStr = _appStr + "</div></html>";
        return _appStr;
    }

    private void initComponents() {
        this.issuesInfoPane = new JEditorPane();
        this.setBackground(new Color(255, 255, 255));
        this.setPreferredSize(new Dimension(0, 800));
        this.setLayout(new BorderLayout());
        this.issuesInfoPane.setContentType(NbBundle.getMessage(IssuesInformationPanel.class, (String)"IssuesInformationPanel.issuesInfoPane.contentType"));
        this.issuesInfoPane.setEditable(false);
        this.issuesInfoPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                IssuesInformationPanel.this.issuesInfoPaneFocusGained(evt);
            }
        });
        this.add((Component)this.issuesInfoPane, "Center");
    }

    private void issuesInfoPaneFocusGained(FocusEvent evt) {
        this.issuesInfoPane.getCaret().setVisible(false);
    }

    @Override
    public void resetContent(final KenaiProject instProj) {
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { background-color: white; font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; padding: 10px;}";
        StyleSheet styleSheet = ((HTMLDocument)this.issuesInfoPane.getDocument()).getStyleSheet();
        styleSheet.addRule(bodyRule);
        styleSheet.addRule("div.section {margin-bottom: 10px;}");
        styleSheet.addRule("i {color: gray}");
        styleSheet.addRule("h2 {color: rgb(0,22,103)}; font-size: 18pt");
        styleSheet.addRule("h3 {font-size: 15pt");
        styleSheet.addRule("h4 {font-size: 12pt");
        try {
            final String _appStr = this.buildIssueInformation(instProj);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HTMLDocument doc = (HTMLDocument)IssuesInformationPanel.this.issuesInfoPane.getDocument();
                    IssuesInformationPanel.this.issuesInfoPane.setText(_appStr);
                    IssuesInformationPanel.this.issuesInfoPane.validate();
                    IssuesInformationPanel.this.issuesInfoPane.setCaretPosition(0);
                    IssuesInformationPanel.this.registerHTMLButton(doc, "enter", new ActionListener(){

                        @Override
                        public void actionPerformed(final ActionEvent e) {
                            final ProjectHandleImpl pHandle = new ProjectHandleImpl(instProj);
                            DashboardImpl.getInstance().addProject(pHandle, false, false);
                            RequestProcessor.getDefault().post(new Runnable(){

                                @Override
                                public void run() {
                                    ProgressHandle h = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(KenaiPopupMenu.class, (String)"CONTACTING_ISSUE_TRACKER"));
                                    h.start();
                                    QueryAccessor.getDefault().getCreateIssueAction(pHandle).actionPerformed(e);
                                    h.finish();
                                }
                            });
                        }
                    });
                    IssuesInformationPanel.this.registerHTMLButton(doc, "find", new ActionListener(){

                        @Override
                        public void actionPerformed(final ActionEvent e) {
                            try {
                                if (instProj.getFeatures(KenaiService.Type.ISSUES).length > 0) {
                                    final ProjectHandleImpl pHandle = new ProjectHandleImpl(instProj);
                                    DashboardImpl.getInstance().addProject(pHandle, false, false);
                                    RequestProcessor.getDefault().post(new Runnable(){

                                        @Override
                                        public void run() {
                                            ProgressHandle h = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(KenaiPopupMenu.class, (String)"CONTACTING_ISSUE_TRACKER"));
                                            h.start();
                                            QueryAccessor.getDefault().getFindIssueAction(pHandle).actionPerformed(e);
                                            h.finish();
                                        }
                                    });
                                }
                            }
                            catch (KenaiException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    });
                }
            });
        }
        catch (KenaiException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public void clearContent() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IssuesInformationPanel.this.issuesInfoPane.setText(IssuesInformationPanel.this.WAIT_STRING);
            }
        });
    }
}

