/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.ui.LandingPagePanel;
import org.netbeans.modules.kenai.ui.NewKenaiProjectWizardIterator;
import org.netbeans.modules.kenai.ui.Utilities;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public final class NewKenaiProjectAction
implements ActionListener {
    private Kenai kenai;

    public NewKenaiProjectAction(Kenai kenai) {
        this.kenai = kenai;
    }

    public NewKenaiProjectAction() {
        this.kenai = Utilities.getPreferredKenai();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean cancelled;
        WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)new NewKenaiProjectWizardIterator(new Node[0], this.kenai));
        wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        wizardDescriptor.setTitle(NbBundle.getMessage(NewKenaiProjectAction.class, (String)"NewKenaiProjectAction.dialogTitle"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)wizardDescriptor);
        boolean bl = cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!cancelled) {
            Set createdProjects = wizardDescriptor.getInstantiatedObjects();
            this.showLandingPage(createdProjects);
        }
    }

    private void showLandingPage(Set<NewKenaiProjectWizardIterator.CreatedProjectInfo> projects) {
        NewKenaiProjectWizardIterator.CreatedProjectInfo cpi = projects.iterator().next();
        KenaiProject kenaiPrj = cpi.project;
        String localPath = cpi.localRepoPath;
        Object[] options = new Object[]{new JButton(NbBundle.getMessage(NewKenaiProjectAction.class, (String)"NewKenaiProjectAction.goToKenai", (Object)kenaiPrj.getKenai())), new JButton(NbBundle.getMessage(NewKenaiProjectAction.class, (String)"NewKenaiProjectAction.createNewProject")), new JButton(NbBundle.getMessage(NewKenaiProjectAction.class, (String)"NewKenaiProjectAction.close"))};
        DialogDescriptor dialogDesc = new DialogDescriptor((Object)new LandingPagePanel(kenaiPrj.getName(), localPath, kenaiPrj.getKenai().getName()), NbBundle.getMessage(NewKenaiProjectAction.class, (String)"NewKenaiProjectAction.dialogTitle"), true, options, options[0], 0, null, null);
        Object option = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDesc);
        if (options[0].equals(option)) {
            URL projectUrl = kenaiPrj.getWebLocation();
            HtmlBrowser.URLDisplayer.getDefault().showURL(projectUrl);
        } else if (options[1].equals(option)) {
            Action newProjectAction = CommonProjectActions.newProjectAction();
            File projPath = null;
            if (localPath != null) {
                projPath = new File(localPath);
            }
            if (newProjectAction != null && projPath != null && projPath.exists()) {
                ProjectChooser.setProjectsFolder((File)projPath);
                newProjectAction.actionPerformed(new ActionEvent(NewKenaiProjectAction.class, 1001, "command"));
            }
        }
    }
}

