/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.parsing;

import com.meterware.httpunit.parsing.HTMLParser;
import com.meterware.httpunit.parsing.HTMLParserListener;
import java.util.Vector;

public abstract class HTMLParserFactory {
    private static Vector _listeners = new Vector();
    private static HTMLParser _jtidyParser = HTMLParserFactory.loadParserIfSupported("org.w3c.tidy.Parser", "com.meterware.httpunit.parsing.JTidyHTMLParser");
    private static HTMLParser _nekoParser = HTMLParserFactory.loadParserIfSupported("org.cyberneko.html.HTMLConfiguration", "com.meterware.httpunit.parsing.NekoHTMLParser");
    private static HTMLParser _htmlParser;
    private static boolean _preserveTagCase;
    private static boolean _returnHTMLDocument;
    private static boolean _parserWarningsEnabled;

    public static void reset() {
        _preserveTagCase = false;
        _returnHTMLDocument = true;
        _parserWarningsEnabled = false;
        _htmlParser = null;
    }

    public static void useJTidyParser() {
        if (_jtidyParser == null) {
            throw new RuntimeException("JTidy parser not available");
        }
        _htmlParser = _jtidyParser;
    }

    public static void useNekoHTMLParser() {
        if (_nekoParser == null) {
            throw new RuntimeException("NekoHTML parser not available");
        }
        _htmlParser = _nekoParser;
    }

    public static void setHTMLParser(HTMLParser htmlParser) {
        _htmlParser = htmlParser;
    }

    public static HTMLParser getHTMLParser() {
        if (_htmlParser == null) {
            if (_nekoParser != null) {
                _htmlParser = _nekoParser;
            } else if (_jtidyParser != null) {
                _htmlParser = _jtidyParser;
            } else {
                throw new RuntimeException("No HTML parser found. Make sure that either nekoHTML.jar or Tidy.jar is in the in classpath");
            }
        }
        return _htmlParser;
    }

    public static boolean isPreserveTagCase() {
        return _preserveTagCase && HTMLParserFactory.getHTMLParser().supportsPreserveTagCase();
    }

    public static void setPreserveTagCase(boolean preserveTagCase) {
        _preserveTagCase = preserveTagCase;
        if (preserveTagCase) {
            _returnHTMLDocument = false;
        }
    }

    public static boolean isReturnHTMLDocument() {
        return _returnHTMLDocument && HTMLParserFactory.getHTMLParser().supportsReturnHTMLDocument();
    }

    public static void setReturnHTMLDocument(boolean returnHTMLDocument) {
        _returnHTMLDocument = returnHTMLDocument;
        if (returnHTMLDocument) {
            _preserveTagCase = false;
        }
    }

    public static boolean isParserWarningsEnabled() {
        return _parserWarningsEnabled && HTMLParserFactory.getHTMLParser().supportsParserWarnings();
    }

    public static void setParserWarningsEnabled(boolean enabled) {
        _parserWarningsEnabled = enabled;
    }

    public static void removeHTMLParserListener(HTMLParserListener el) {
        _listeners.removeElement(el);
    }

    public static void addHTMLParserListener(HTMLParserListener el) {
        _listeners.addElement(el);
    }

    static Vector getHTMLParserListeners() {
        return _listeners;
    }

    private static HTMLParser loadParserIfSupported(String testClassName, String parserClassName) {
        try {
            Class.forName(testClassName);
            return (HTMLParser)Class.forName(parserClassName).newInstance();
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    static {
        HTMLParserFactory.reset();
    }
}

