/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityMethodController;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity.CMPFieldsNode;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.entity.MethodChildren;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.EjbViewController;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.MethodsNode;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class EntityChildren
extends Children.Keys<KEY>
implements PropertyChangeListener {
    private static final int REMOTE = 0;
    private static final int LOCAL = 1;
    private static final int CMP = 2;
    private final ClasspathInfo cpInfo;
    private final String ejbClass;
    private final EjbJar ejbModule;
    private final EntityMethodController controller;
    private final Entity model;

    public EntityChildren(EjbViewController ejbViewController) throws IOException {
        this.cpInfo = ejbViewController.getClasspathInfo();
        this.ejbClass = ejbViewController.getEjbClass();
        this.ejbModule = ejbViewController.getEjbModule();
        this.controller = new EntityMethodController(this.ejbClass, (MetadataModel<EjbJarMetadata>)this.ejbModule.getMetadataModel());
        this.model = (Entity)this.ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Entity>(){

            public Entity run(EjbJarMetadata ejbJarMetadata) throws Exception {
                return (Entity)ejbJarMetadata.findByEjbClass(EntityChildren.this.ejbClass);
            }
        });
    }

    protected void addNotify() {
        super.addNotify();
        try {
            this.updateKeys();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void updateKeys() throws IOException {
        final boolean[] blArray = new boolean[]{false, false, false};
        this.ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Void>(){

            public Void run(EjbJarMetadata ejbJarMetadata) throws Exception {
                Entity entity = (Entity)ejbJarMetadata.findByEjbClass(EntityChildren.this.ejbClass);
                if (entity != null) {
                    blArray[0] = entity.getRemote() != null;
                    blArray[1] = entity.getLocal() != null;
                    blArray[2] = "Container".equals(entity.getPersistenceType());
                }
                return null;
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ArrayList<KEY> arrayList = new ArrayList<KEY>();
                if (blArray[0]) {
                    arrayList.add(KEY.REMOTE);
                }
                if (blArray[1]) {
                    arrayList.add(KEY.LOCAL);
                }
                if (blArray[2]) {
                    arrayList.add(KEY.CMP_FIELDS);
                }
                EntityChildren.this.setKeys(arrayList);
            }
        });
    }

    protected void removeNotify() {
        this.setKeys(Collections.emptySet());
        super.removeNotify();
    }

    protected Node[] createNodes(KEY kEY) {
        if (kEY == KEY.LOCAL) {
            MethodChildren methodChildren = new MethodChildren(this.cpInfo, this.controller, this.model, this.controller.getLocalInterfaces(), true, this.ejbModule.getDeploymentDescriptor());
            MethodsNode methodsNode = new MethodsNode(this.ejbClass, this.ejbModule, (Children)methodChildren, MethodsNode.ViewType.LOCAL);
            methodsNode.setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbcore/resources/LocalMethodContainerIcon.gif");
            methodsNode.setDisplayName(NbBundle.getMessage(EjbViewController.class, (String)"LBL_LocalMethods"));
            return new Node[]{methodsNode};
        }
        if (kEY == KEY.REMOTE) {
            MethodChildren methodChildren = new MethodChildren(this.cpInfo, this.controller, this.model, this.controller.getRemoteInterfaces(), false, this.ejbModule.getDeploymentDescriptor());
            MethodsNode methodsNode = new MethodsNode(this.ejbClass, this.ejbModule, (Children)methodChildren, MethodsNode.ViewType.REMOTE);
            methodsNode.setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbcore/resources/RemoteMethodContainerIcon.gif");
            methodsNode.setDisplayName(NbBundle.getMessage(EjbViewController.class, (String)"LBL_RemoteMethods"));
            return new Node[]{methodsNode};
        }
        if (kEY == KEY.CMP_FIELDS) {
            try {
                CMPFieldsNode cMPFieldsNode = new CMPFieldsNode(this.controller, this.model, this.ejbModule.getDeploymentDescriptor());
                cMPFieldsNode.setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbcore/resources/CMFieldContainerIcon.gif");
                cMPFieldsNode.setDisplayName(NbBundle.getMessage(EntityChildren.class, (String)"LBL_CMPFields"));
                return new Node[]{cMPFieldsNode};
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    EntityChildren.this.updateKeys();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        });
    }

    protected static enum KEY {
        REMOTE,
        LOCAL,
        CMP_FIELDS;

    }
}

