/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.ui.actions;

import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.ui.actions.ViewWSDLAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class ViewApiDocAction
extends NodeAction {
    protected boolean enable(Node[] nodes) {
        return this.getApiDocUrl(nodes) != null && HtmlBrowser.URLDisplayer.getDefault() != null;
    }

    private String getApiDocUrl(Node[] nodes) {
        Saas saas;
        if (nodes != null && nodes.length == 1 && (saas = (Saas)nodes[0].getLookup().lookup(Saas.class)) != null) {
            return saas.getApiDoc();
        }
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return NbBundle.getMessage(ViewWSDLAction.class, (String)"VIEW_API_Action");
    }

    protected void performAction(Node[] activatedNodes) {
        HtmlBrowser.URLDisplayer displayer = HtmlBrowser.URLDisplayer.getDefault();
        if (displayer == null) {
            String msg = NbBundle.getMessage(ViewApiDocAction.class, (String)"MSG_NoDefaultBrowser");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 2));
            return;
        }
        String apiUrl = this.getApiDocUrl(activatedNodes);
        if (apiUrl == null) {
            throw new IllegalArgumentException("ViewApiDoc should not be allowed without a api doc URL");
        }
        try {
            URL href = new URL(apiUrl);
            displayer.showURL(href);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public boolean asynchronous() {
        return true;
    }
}

