/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source;

import java.io.IOException;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.DeclarationFinder;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsfret.navigation.Icons;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.text.NbDocument;

public final class UiUtils {
    private UiUtils() {
    }

    public static Icon getElementIcon(ElementKind elementKind, Collection<Modifier> modifiers) {
        return Icons.getElementIcon(elementKind, modifiers);
    }

    public static boolean open(Source js, ElementHandle handle) {
        DeclarationFinder.DeclarationLocation location = UiUtils.getOpenInfo(js, handle);
        if (location != DeclarationFinder.DeclarationLocation.NONE) {
            return UiUtils.doOpen(location.getFileObject(), location.getOffset());
        }
        return false;
    }

    private static DeclarationFinder.DeclarationLocation getOpenInfo(Source js, ElementHandle handle) {
        assert (js != null);
        assert (handle != null);
        try {
            FileObject fo = js.getFileObjects().iterator().next();
            return UiUtils.getElementLocation(fo, handle);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return DeclarationFinder.DeclarationLocation.NONE;
        }
    }

    public static boolean open(final FileObject fo, final int offset) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UiUtils.doOpen(fo, offset);
                }
            });
            return true;
        }
        return UiUtils.doOpen(fo, offset);
    }

    private static boolean doOpen(FileObject fo, int offset) {
        try {
            OpenCookie oc;
            StyledDocument doc;
            DataObject od = DataObject.find((FileObject)fo);
            EditorCookie ec = (EditorCookie)od.getCookie(EditorCookie.class);
            LineCookie lc = (LineCookie)od.getCookie(LineCookie.class);
            if (ec != null && lc != null && offset != -1 && (doc = ec.openDocument()) != null) {
                Line l;
                int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
                int lineOffset = NbDocument.findLineOffset((StyledDocument)doc, (int)line);
                int column = offset - lineOffset;
                if (line != -1 && (l = lc.getLineSet().getCurrent(line)) != null) {
                    l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, column);
                    return true;
                }
            }
            if ((oc = (OpenCookie)od.getCookie(OpenCookie.class)) != null) {
                oc.open();
                return true;
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return false;
    }

    private static DeclarationFinder.DeclarationLocation getElementLocation(final FileObject fo, final ElementHandle handle) throws IOException {
        assert (handle != null);
        final DeclarationFinder.DeclarationLocation[] result = new DeclarationFinder.DeclarationLocation[]{DeclarationFinder.DeclarationLocation.NONE};
        Source js = Source.forFileObject(fo);
        js.runUserActionTask(new CancellableTask<CompilationController>(){

            public void cancel() {
            }

            public void run(CompilationController info) {
                block9: {
                    try {
                        info.toPhase(Phase.RESOLVED);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                    FileObject fileObject = info.getFileObject();
                    if (handle != null) {
                        fileObject = handle.getFileObject();
                    }
                    if (fileObject == null) {
                        fileObject = fo;
                    }
                    if (fileObject == info.getFileObject()) {
                        Language language = LanguageRegistry.getInstance().getLanguageByMimeType(handle.getMimeType());
                        Parser parser = language.getParser();
                        try {
                            OffsetRange range = parser.getPositionManager().getOffsetRange((CompilationInfo)info, handle);
                            if (range != OffsetRange.NONE && range != null) {
                                result[0] = new DeclarationFinder.DeclarationLocation(fileObject, range.getStart());
                                break block9;
                            }
                            result[0] = new DeclarationFinder.DeclarationLocation(fileObject, -1);
                        }
                        catch (IllegalArgumentException iae) {
                            result[0] = new DeclarationFinder.DeclarationLocation(fileObject, 0);
                        }
                    } else {
                        result[0] = new DeclarationFinder.DeclarationLocation(fileObject, -1);
                    }
                }
            }
        }, true);
        return result[0];
    }
}

