/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.profiles.activation;

import hidden.org.codehaus.plexus.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Activation;
import org.apache.maven.model.Profile;
import org.apache.maven.profiles.activation.DetectedProfileActivator;
import org.apache.maven.profiles.activation.ProfileActivationContext;

public class JdkPrefixProfileActivator
extends DetectedProfileActivator {
    public static final String JDK_VERSION = "java.version";

    public boolean isActive(Profile profile, ProfileActivationContext context) {
        Activation activation = profile.getActivation();
        String jdk = activation.getJdk();
        Properties props = context.getExecutionProperties();
        String javaVersion = props.getProperty(JDK_VERSION);
        if (javaVersion == null) {
            this.getLogger().warn("Cannot locate java version property: java.version. NOT enabling profile: " + profile.getId());
            return false;
        }
        return this.isActive(javaVersion, jdk);
    }

    public boolean isActive(String jdkVersion, String expression) {
        boolean reverse = false;
        if (expression.startsWith("!")) {
            reverse = true;
            expression = expression.substring(1);
        }
        boolean result = false;
        result = expression.endsWith("+") ? JdkPrefixProfileActivator.compareTo(JdkPrefixProfileActivator.asIntArray(jdkVersion), JdkPrefixProfileActivator.asIntArray(expression)) >= 0 : (expression.endsWith("-") ? JdkPrefixProfileActivator.compareTo(JdkPrefixProfileActivator.asIntArray(jdkVersion), JdkPrefixProfileActivator.asIntArray(expression)) <= 0 : jdkVersion.startsWith(expression));
        if (reverse) {
            return !result;
        }
        return result;
    }

    protected boolean canDetectActivation(Profile profile, ProfileActivationContext context) {
        return profile.getActivation() != null && StringUtils.isNotEmpty(profile.getActivation().getJdk());
    }

    private static void parseNum(List pList, StringBuffer pBuffer) {
        if (pBuffer.length() > 0) {
            pList.add(new Integer(pBuffer.toString()));
            pBuffer.setLength(0);
        }
    }

    private static int[] asIntArray(String pVersion) {
        ArrayList nums = new ArrayList();
        StringBuffer sb = new StringBuffer();
        while (pVersion.length() > 0) {
            char c = pVersion.charAt(0);
            pVersion = pVersion.substring(1);
            if (Character.isDigit(c)) {
                sb.append(c);
                continue;
            }
            JdkPrefixProfileActivator.parseNum(nums, sb);
        }
        JdkPrefixProfileActivator.parseNum(nums, sb);
        int[] result = new int[nums.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (Integer)nums.get(i);
            ++i;
        }
        return result;
    }

    private static int compareTo(int[] pVersion1, int[] pVersion2) {
        int len = Math.max(pVersion1.length, pVersion2.length);
        int i = 0;
        while (i < len) {
            int n2;
            int n1 = pVersion1.length > i ? pVersion1[i] : 0;
            int result = n1 - (n2 = pVersion2.length > i ? pVersion2[i] : 0);
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return 0;
    }
}

