/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.openide.awt.HtmlBrowser;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class OutputLogger {
    private InputOutput log;
    private boolean ignoreCommand = false;
    private String repositoryRootString;
    private boolean empty;
    private boolean writable;
    private static final RequestProcessor rp = new RequestProcessor("MercurialOutput", 1);
    public static final int MAX_LINES_TO_PRINT = 500;
    private static final String MSG_TOO_MANY_LINES = "The number of output lines is greater than 500; see message log for complete output";
    private static final HashSet<String> openedWindows = new HashSet(5);
    private AbstractAction action;

    public static OutputLogger getLogger(String repositoryRoot) {
        if (repositoryRoot != null) {
            return new OutputLogger(repositoryRoot);
        }
        return new NullLogger();
    }

    private OutputLogger(String repositoryRoot) {
        this.repositoryRootString = repositoryRoot;
    }

    private OutputLogger() {
    }

    private InputOutput getLog() {
        this.writable = true;
        if (this.log == null) {
            Mercurial.LOG.fine("Creating OutputLogger for " + this.repositoryRootString);
            this.log = IOProvider.getDefault().getIO(this.repositoryRootString, false);
            if (!openedWindows.contains(this.repositoryRootString)) {
                this.writable = HgModuleConfig.getDefault().getAutoOpenOutput();
                openedWindows.add(this.repositoryRootString);
                if (!this.writable) {
                    this.log.closeInputOutput();
                }
            }
        }
        if (this.log.isClosed()) {
            if (HgModuleConfig.getDefault().getAutoOpenOutput()) {
                Mercurial.LOG.fine("Creating OutputLogger for " + this.repositoryRootString);
                this.log = IOProvider.getDefault().getIO(this.repositoryRootString, false);
                try {
                    this.log.getOut().reset();
                }
                catch (IOException e) {
                    Mercurial.LOG.log(Level.SEVERE, null, e);
                }
            } else {
                this.writable = false;
            }
        }
        return this.log;
    }

    public void closeLog() {
        rp.post(new Runnable(){

            @Override
            public void run() {
                if (OutputLogger.this.log != null && OutputLogger.this.writable) {
                    OutputLogger.this.log.getOut().close();
                    OutputLogger.this.log.getErr().close();
                }
            }
        });
    }

    public void flushLog() {
        rp.post(new Runnable(){

            @Override
            public void run() {
                OutputLogger.this.getLog();
                if (OutputLogger.this.writable) {
                    OutputLogger.this.getLog().getOut().flush();
                    OutputLogger.this.getLog().getErr().flush();
                }
            }
        });
    }

    public void output(final List<String> list) {
        if (list.isEmpty()) {
            return;
        }
        rp.post(new Runnable(){

            @Override
            public void run() {
                OutputWriter out = OutputLogger.this.getLog().getOut();
                if (OutputLogger.this.writable) {
                    for (String s : list) {
                        out.println(s);
                    }
                    out.flush();
                }
            }
        });
    }

    public void output(final String msg) {
        if (msg == null) {
            return;
        }
        rp.post(new Runnable(){

            @Override
            public void run() {
                OutputWriter out = OutputLogger.this.getLog().getOut();
                if (OutputLogger.this.writable) {
                    out.println(msg);
                    out.flush();
                }
            }
        });
    }

    public void outputInRed(final String msg) {
        if (msg == null) {
            return;
        }
        rp.post(new Runnable(){

            @Override
            public void run() {
                OutputWriter out = OutputLogger.this.getLog().getErr();
                if (OutputLogger.this.writable) {
                    out.println(msg);
                    out.flush();
                }
            }
        });
    }

    public void outputLink(final String sURL) {
        if (sURL == null) {
            return;
        }
        rp.post(new Runnable(){

            @Override
            public void run() {
                try {
                    OutputWriter out = OutputLogger.this.getLog().getOut();
                    if (OutputLogger.this.writable) {
                        OutputListener listener = new OutputListener(){

                            public void outputLineAction(OutputEvent ev) {
                                try {
                                    HtmlBrowser.URLDisplayer.getDefault().showURL(new URL(sURL));
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }

                            public void outputLineSelected(OutputEvent ev) {
                            }

                            public void outputLineCleared(OutputEvent ev) {
                            }
                        };
                        out.println(sURL, listener, true);
                        out.flush();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public void clearOutput() {
        rp.post(new Runnable(){

            @Override
            public void run() {
                OutputWriter out = OutputLogger.this.getLog().getOut();
                if (OutputLogger.this.writable) {
                    try {
                        out.reset();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    out.flush();
                }
            }
        });
    }

    public Action getOpenOutputAction() {
        if (this.action == null) {
            this.action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OutputLogger.this.writable = true;
                    OutputLogger.this.getLog().select();
                }
            };
        }
        return this.action;
    }

    private static class NullLogger
    extends OutputLogger {
        private NullLogger() {
        }

        @Override
        public void closeLog() {
        }

        @Override
        public void flushLog() {
        }

        @Override
        public void output(List<String> list) {
        }

        @Override
        public void output(String msg) {
        }

        @Override
        public void outputInRed(String msg) {
        }

        @Override
        public void outputLink(String sURL) {
        }

        @Override
        public void clearOutput() {
        }
    }
}

