/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.menu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.menu.DropTargetLayer;
import org.netbeans.modules.form.menu.MenuEditLayer;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.palette.PaletteUtils;

class DragOperation {
    private MenuEditLayer menuEditLayer;
    private JComponent dragComponent;
    private boolean started = false;
    private JComponent targetComponent;
    private Op op = Op.PICK_AND_PLOP_FROM_PALETTE;
    private JMenuItem payloadComponent;
    private List<JMenuItem> payloadComponents;
    private PaletteItem currentItem;

    public boolean isPickAndPlop() {
        return this.op == Op.PICK_AND_PLOP_FROM_PALETTE;
    }

    public DragOperation(MenuEditLayer menuEditLayer) {
        this.menuEditLayer = menuEditLayer;
        this.started = false;
    }

    public JComponent getDragComponent() {
        return this.dragComponent;
    }

    void start(JMenuItem jMenuItem, Point point) {
        this.op = Op.INTER_MENU_DRAG;
        this.started = true;
        List<RADComponent> list = this.menuEditLayer.getSelectedRADComponents();
        this.payloadComponents = new ArrayList<JMenuItem>();
        if (list.size() > 1) {
            for (RADComponent rADComponent : list) {
                Object object = this.menuEditLayer.formDesigner.getComponent(rADComponent);
                if (object instanceof JMenuItem) {
                    this.payloadComponents.add((JMenuItem)object);
                    continue;
                }
                this.fastEnd();
                return;
            }
        } else {
            this.payloadComponents.add(jMenuItem);
        }
        this.dragComponent = (JMenuItem)this.createDragFeedbackComponent(jMenuItem, null);
        this.dragComponent.setSize(this.dragComponent.getPreferredSize());
        this.dragComponent.setLocation(point);
        this.menuEditLayer.layers.add((Component)this.dragComponent, JLayeredPane.DRAG_LAYER);
        this.menuEditLayer.repaint();
        this.payloadComponent = jMenuItem;
    }

    void setTargetVisible(boolean bl) {
        if (!bl) {
            this.menuEditLayer.layers.remove(this.dragComponent);
        } else {
            this.menuEditLayer.layers.add((Component)this.dragComponent, JLayeredPane.DRAG_LAYER);
        }
        this.menuEditLayer.repaint();
    }

    private JComponent createDragFeedbackComponent(JMenuItem jMenuItem, Class clazz) {
        Object object;
        Object object2;
        Object object3;
        PaletteItem paletteItem = PaletteUtils.getSelectedItem();
        if (paletteItem != null && (object3 = ((MetaComponentCreator)(object2 = this.menuEditLayer.formDesigner.getFormModel().getComponentCreator())).precreateVisualComponent(paletteItem.getComponentClassSource())) != null && (object = ((RADComponent)object3).getBeanInstance()) instanceof JComponent) {
            JComponent jComponent = (JComponent)object;
            if (object instanceof JMenuItem) {
                JMenuItem jMenuItem2 = (JMenuItem)object;
                jMenuItem2.setBorder(MenuEditLayer.DRAG_MENU_BORDER);
                jMenuItem2.setIcon(new MenuEditLayer.WrapperIcon());
                jMenuItem2.setMargin(new Insets(1, 1, 1, 1));
                jMenuItem2.setBorderPainted(true);
            }
            if (object instanceof JSeparator) {
                jComponent.setPreferredSize(new Dimension(50, 10));
                jComponent.setVisible(false);
            }
            return jComponent;
        }
        object2 = null;
        object2 = new JMenuItem();
        if (jMenuItem == null && clazz != null && JComponent.class.isAssignableFrom(clazz)) {
            try {
                object2 = (JComponent)clazz.newInstance();
            }
            catch (Exception exception) {
                System.out.println("exception: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        if (jMenuItem instanceof JMenu) {
            object2 = new JMenu();
        }
        if (jMenuItem instanceof JCheckBoxMenuItem) {
            object2 = new JCheckBoxMenuItem();
            ((JCheckBoxMenuItem)object2).setSelected(true);
        }
        if (jMenuItem instanceof JRadioButtonMenuItem) {
            object2 = new JRadioButtonMenuItem();
            ((JRadioButtonMenuItem)object2).setSelected(true);
        }
        if (object2 instanceof JMenuItem) {
            object3 = (JMenuItem)object2;
            if (jMenuItem != null) {
                ((AbstractButton)object3).setText(jMenuItem.getText());
                ((AbstractButton)object3).setIcon(jMenuItem.getIcon());
                if (!(jMenuItem instanceof JMenu) && !DropTargetLayer.isMetal()) {
                    ((JMenuItem)object3).setAccelerator(jMenuItem.getAccelerator());
                }
            } else {
                ((AbstractButton)object3).setText("a new menu item");
            }
            ((AbstractButton)object3).setMargin(new Insets(1, 1, 1, 1));
            ((AbstractButton)object3).setBorderPainted(true);
        }
        ((JComponent)object2).setBorder(MenuEditLayer.DRAG_MENU_BORDER);
        return object2;
    }

    void start(PaletteItem paletteItem, Point point) {
        if (this.dragComponent != null) {
            this.menuEditLayer.layers.remove(this.dragComponent);
            this.dragComponent = null;
        }
        if (!this.menuEditLayer.doesFormContainMenuBar()) {
            this.menuEditLayer.showMenubarWarning = true;
            FormEditor.getAssistantModel(this.menuEditLayer.formDesigner.getFormModel()).setContext("missingMenubar");
            this.menuEditLayer.repaint();
        }
        this.op = Op.PICK_AND_PLOP_FROM_PALETTE;
        this.started = true;
        this.dragComponent = this.createDragFeedbackComponent(null, paletteItem.getComponentClass());
        this.dragComponent.setSize(this.dragComponent.getPreferredSize());
        this.dragComponent.setLocation(point);
        this.menuEditLayer.layers.add((Component)this.dragComponent, JLayeredPane.DRAG_LAYER);
        this.menuEditLayer.repaint();
        this.currentItem = paletteItem;
        this.menuEditLayer.glassLayer.requestFocusInWindow();
    }

    void move(Point point) {
        if (this.dragComponent != null) {
            this.dragComponent.setLocation(point);
            RADComponent rADComponent = this.menuEditLayer.formDesigner.getHandleLayer().getMetaComponentAt(point, 0);
            if (rADComponent != null && JMenuBar.class.isAssignableFrom(rADComponent.getBeanClass()) && JMenu.class.isAssignableFrom(this.dragComponent.getClass())) {
                this.menuEditLayer.dropTargetLayer.setDropTarget(rADComponent, point);
                this.targetComponent = (JComponent)this.menuEditLayer.formDesigner.getComponent(rADComponent);
            }
            if (rADComponent != null && JMenu.class.isAssignableFrom(rADComponent.getBeanClass())) {
                this.targetComponent = (JComponent)this.menuEditLayer.formDesigner.getComponent(rADComponent);
                this.menuEditLayer.openMenu(rADComponent, this.targetComponent);
                if (JMenu.class.isAssignableFrom(this.dragComponent.getClass())) {
                    this.menuEditLayer.dropTargetLayer.setDropTarget(rADComponent, point);
                } else {
                    this.menuEditLayer.dropTargetLayer.setDropTarget(rADComponent, point, DropTargetLayer.DropTargetType.INTO_SUBMENU);
                }
                return;
            }
            JComponent jComponent = this.getDeepestComponentInPopups(point);
            if (jComponent instanceof JMenuItem && jComponent != this.dragComponent) {
                this.targetComponent = jComponent;
                if (this.targetComponent != null) {
                    this.menuEditLayer.dropTargetLayer.setDropTarget(this.targetComponent, point, DropTargetLayer.DropTargetType.INTER_MENU);
                }
                this.menuEditLayer.repaint();
            }
            if (jComponent instanceof JMenu) {
                Point point2 = SwingUtilities.convertPoint(this.menuEditLayer.glassLayer, point, jComponent);
                JMenu jMenu = (JMenu)jComponent;
                Point point3 = point2;
                jMenu.setBorderPainted(true);
                if (DropTargetLayer.isSubMenuRightEdge(point3, jMenu)) {
                    this.menuEditLayer.dropTargetLayer.setDropTarget(jMenu, point3, DropTargetLayer.DropTargetType.INTO_SUBMENU);
                    jMenu.repaint();
                } else {
                    this.menuEditLayer.dropTargetLayer.setDropTarget(jMenu, point, DropTargetLayer.DropTargetType.INTER_MENU);
                }
                this.menuEditLayer.showMenuPopup(jMenu);
            }
            if (jComponent == null) {
                this.menuEditLayer.dropTargetLayer.clearDropTarget();
            }
        }
    }

    void end(Point point) {
        this.end(point, true);
    }

    void end(Point point, boolean bl) {
        this.started = false;
        this.currentItem = null;
        if (this.dragComponent == null) {
            return;
        }
        this.menuEditLayer.layers.remove(this.dragComponent);
        this.menuEditLayer.dropTargetLayer.clearDropTarget();
        switch (this.op) {
            case PICK_AND_PLOP_FROM_PALETTE: {
                this.completePickAndPlopFromPalette(point, bl);
                break;
            }
            case INTER_MENU_DRAG: {
                this.completeInterMenuDrag(point);
                break;
            }
        }
        this.menuEditLayer.glassLayer.requestFocusInWindow();
        this.payloadComponent = null;
        this.targetComponent = null;
        this.menuEditLayer.repaint();
    }

    void fastEnd() {
        this.started = false;
        if (this.dragComponent != null) {
            this.menuEditLayer.layers.remove(this.dragComponent);
            this.menuEditLayer.repaint();
        }
        this.menuEditLayer.dropTargetLayer.clearDropTarget();
    }

    JComponent getDeepestComponent(Point point) {
        if (point == null) {
            return null;
        }
        RADComponent rADComponent = this.menuEditLayer.formDesigner.getHandleLayer().getMetaComponentAt(point, 0);
        if (rADComponent != null && (JMenu.class.isAssignableFrom(rADComponent.getBeanClass()) || JMenuBar.class.isAssignableFrom(rADComponent.getBeanClass()))) {
            return (JComponent)this.menuEditLayer.formDesigner.getComponent(rADComponent);
        }
        return this.getDeepestComponentInPopups(point);
    }

    public JComponent getTargetComponent() {
        return this.targetComponent;
    }

    private void completeInterMenuDrag(Point point) {
        if (this.targetComponent == null) {
            return;
        }
        JComponent jComponent = this.getDeepestComponent(point);
        if (this.targetComponent != jComponent) {
            this.menuEditLayer.formDesigner.toggleSelectionMode();
            return;
        }
        Point point2 = SwingUtilities.convertPoint(this.menuEditLayer.glassLayer, point, jComponent);
        if (jComponent instanceof JMenu) {
            JMenu jMenu = (JMenu)jComponent;
            if (jMenu.getParent() instanceof JMenuBar && this.isOnlyJMenus(this.payloadComponents)) {
                if (DropTargetLayer.isMenuLeftEdge(point2, jMenu)) {
                    this.menuEditLayer.moveRadComponentToBefore(this.payloadComponent, jMenu);
                    return;
                }
                if (DropTargetLayer.isMenuRightEdge(point2, jMenu)) {
                    this.menuEditLayer.moveRadComponentToAfter(this.payloadComponent, jMenu);
                    return;
                }
                this.menuEditLayer.moveRadComponentInto(this.payloadComponent, jMenu);
                return;
            }
            if (DropTargetLayer.isSubMenuRightEdge(point2, jMenu)) {
                this.menuEditLayer.moveRadComponentInto(this.payloadComponent, jMenu);
            } else if (DropTargetLayer.isBelowItem(point2, jMenu)) {
                this.menuEditLayer.moveRadComponentToAfter(this.payloadComponent, this.targetComponent);
            } else {
                this.menuEditLayer.moveRadComponentToBefore(this.payloadComponent, this.targetComponent);
            }
            return;
        }
        if (jComponent instanceof JMenuBar) {
            if (this.payloadComponent instanceof JMenu) {
                this.menuEditLayer.moveRadComponentInto(this.payloadComponent, this.targetComponent);
                return;
            }
            return;
        }
        if (DropTargetLayer.isBelowItem(point2, jComponent)) {
            this.menuEditLayer.moveRadComponentToAfter(this.payloadComponent, this.targetComponent);
        } else {
            this.menuEditLayer.moveRadComponentToBefore(this.payloadComponent, this.targetComponent);
        }
    }

    private void completePickAndPlopFromPalette(Point point, boolean bl) {
        Object object;
        PaletteItem paletteItem = PaletteUtils.getSelectedItem();
        if (paletteItem == null) {
            return;
        }
        if (this.targetComponent == null) {
            return;
        }
        JComponent jComponent = this.getDeepestComponent(point);
        if (this.targetComponent != jComponent) {
            if (bl) {
                this.menuEditLayer.formDesigner.toggleSelectionMode();
            }
            return;
        }
        JComponent jComponent2 = null;
        MetaComponentCreator metaComponentCreator = this.menuEditLayer.formDesigner.getFormModel().getComponentCreator();
        if (metaComponentCreator != null && (object = metaComponentCreator.precreateVisualComponent(paletteItem.getComponentClassSource())) != null) {
            jComponent2 = (JComponent)((RADComponent)object).getBeanInstance();
        }
        if (jComponent2 == null) {
            try {
                jComponent2 = (JComponent)paletteItem.getComponentClass().newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        metaComponentCreator.getPrecreatedLayoutComponent();
        object = SwingUtilities.convertPoint(this.menuEditLayer.glassLayer, point, this.targetComponent);
        if (this.targetComponent instanceof JMenu) {
            if (this.targetComponent.getParent() instanceof JMenuBar) {
                if (DropTargetLayer.isMenuLeftEdge((Point)object, this.targetComponent) && this.isMenuPayload(metaComponentCreator)) {
                    this.menuEditLayer.addRadComponentToBefore(this.targetComponent, metaComponentCreator);
                } else if (DropTargetLayer.isMenuRightEdge((Point)object, this.targetComponent) && this.isMenuPayload(metaComponentCreator)) {
                    this.menuEditLayer.addRadComponentToAfter(this.targetComponent, metaComponentCreator);
                } else {
                    this.menuEditLayer.addRadComponentToEnd(this.targetComponent, metaComponentCreator);
                }
            } else if (DropTargetLayer.isSubMenuRightEdge((Point)object, this.targetComponent)) {
                this.menuEditLayer.addRadComponentToEnd(this.targetComponent, metaComponentCreator);
            } else if (DropTargetLayer.isBelowItem((Point)object, this.targetComponent)) {
                this.menuEditLayer.addRadComponentToAfter(this.targetComponent, metaComponentCreator);
            } else {
                this.menuEditLayer.addRadComponentToBefore(this.targetComponent, metaComponentCreator);
            }
        } else if (this.targetComponent instanceof JMenuBar) {
            this.menuEditLayer.addRadComponentToEnd(this.targetComponent, metaComponentCreator);
        } else if (DropTargetLayer.isBelowItem((Point)object, this.targetComponent)) {
            this.menuEditLayer.addRadComponentToAfter(this.targetComponent, metaComponentCreator);
        } else {
            this.menuEditLayer.addRadComponentToBefore(this.targetComponent, metaComponentCreator);
        }
        if (bl) {
            this.menuEditLayer.formDesigner.toggleSelectionMode();
        }
    }

    private boolean isOnlyJMenus(List<JMenuItem> list) {
        for (JMenuItem jMenuItem : list) {
            if (jMenuItem instanceof JMenu) continue;
            return false;
        }
        return true;
    }

    private boolean isMenuPayload(MetaComponentCreator metaComponentCreator) {
        return JMenu.class.isAssignableFrom(metaComponentCreator.getPrecreatedMetaComponent().getBeanClass());
    }

    public JComponent getDeepestComponentInPopups(Point point) {
        Component[] componentArray;
        for (Component component : componentArray = this.menuEditLayer.layers.getComponentsInLayer(JLayeredPane.DEFAULT_LAYER)) {
            if (!component.isVisible()) continue;
            Point point2 = SwingUtilities.convertPoint(this.menuEditLayer, point, component);
            JComponent jComponent = (JComponent)SwingUtilities.getDeepestComponentAt(component, point2.x, point2.y);
            if (jComponent == null) continue;
            return jComponent;
        }
        return null;
    }

    public boolean isStarted() {
        return this.started;
    }

    public PaletteItem getCurrentItem() {
        return this.currentItem;
    }

    private static enum Op {
        PICK_AND_PLOP_FROM_PALETTE,
        INTER_MENU_DRAG,
        NO_MENUBAR;

    }
}

