/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.cldcplatform;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.cldcplatform.PlatformConvertor;
import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.io.NullOutputStream;
import org.openide.util.io.ReaderInputStream;

public final class UEIEmulatorConfiguratorImpl {
    private static final String CMD_VERSION = "-version";
    private static final String CMD_QUERY = "-Xquery";
    private static final String[][] APIs = new String[][]{{"CLDC", "1.1", "java/lang/Object.class", "java/lang/Double.class", "java/io/InputStream.class", "java/util/Date.class", "javax/microedition/io/Connection.class"}, {"CLDC", "1.0", "java/lang/Object.class", "java/io/InputStream.class", "java/util/Date.class", "javax/microedition/io/Connection.class"}, {"MIDP", "2.0", "java/lang/IllegalStateException.class", "java/util/Timer.class", "javax/microedition/io/PushRegistry.class", "javax/microedition/lcdui/CustomItem.class", "javax/microedition/lcdui/game/GameCanvas.class", "javax/microedition/rms/RecordStore.class", "javax/microedition/midlet/MIDlet.class", "javax/microedition/pki/Certificate.class"}, {"MIDP", "1.0", "java/lang/IllegalStateException.class", "java/util/Timer.class", "javax/microedition/io/HttpConnection.class", "javax/microedition/lcdui/Display.class", "javax/microedition/rms/RecordStore.class", "javax/microedition/midlet/MIDlet.class"}, {"JSR172", "1.0", "javax/microedition/xml/rpc/Element.class"}, {"JSR82", "1.0", "javax/bluetooth/DiscoveryAgent.class"}, {"OBEX", "1.0", "javax/obex/ClientSession.class"}, {"JSR75", "1.0", "javax/microedition/io/file/FileConnection.class", "javax/microedition/pim/PIM.class"}, {"JSR177", "1.0", "javax/microedition/apdu/APDUConnection.class", "javax/microedition/jcrmi/JavaCardRMIConnection.class"}, {"JSR179", "1.0", "javax/microedition/location/Location.class"}, {"JSR184", "1.0", "javax/microedition/m3g/Object3D.class"}, {"JSR211", "1.0", "javax/microedition/content/ContentHandler.class"}, {"JSR238", "1.0", "javax/microedition/global/ResourceManager.class"}, {"MMAPI", "1.0", "javax/microedition/media/TimeBase.class", "javax/microedition/media/control/VolumeControl.class", "javax/microedition/media/protocol/ContentDescriptor.class"}, {"WMA", "2.0", "javax/wireless/messaging/MultipartMessage.class"}, {"WMA", "1.1", "javax/wireless/messaging/Message.class"}, {"NOKIAUI", "1.0", "com/nokia/mid/ui/FullCanvas.class"}, {"IMP", "1.0", "java/lang/IllegalStateException.class", "java/util/Timer.class", "javax/microedition/io/HttpConnection.class", "javax/microedition/rms/RecordStore.class", "javax/microedition/midlet/MIDlet.class"}, {"IMP-NG", "1.0", "java/lang/IllegalStateException.class", "java/util/Timer.class", "javax/microedition/rms/RecordStore.class", "javax/microedition/midlet/MIDlet.class", "javax/microedition/pki/Certificate.class"}, {"AJOF", "1.0", "com/siemens/icm/ajof/WmMIDlet.class"}};
    private String platformPath;
    private String process;
    private String platformName;
    private Properties properties;
    private String platformType;
    private Process emulatorProcess;
    private StringBuffer emulatorOutput;
    private StringBuffer emulatorError;

    private static File getFile(File root, String path) {
        File f = new File(path = path.trim());
        if (!f.exists()) {
            f = new File(root, path);
        }
        return FileUtil.normalizeFile((File)f);
    }

    private static String cutPath(File root, Object o) {
        String path;
        String rootPath = root.getPath();
        String string = path = o instanceof JarFile ? ((JarFile)o).getName() : ((File)o).getPath();
        if (path.length() > rootPath.length() && path.startsWith(rootPath)) {
            path = "${platform.home}/" + path.substring(rootPath.length() + 1);
        }
        return path.replace('\\', '/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static List<J2MEPlatform.J2MEProfile> analyzePath(File froot, String classpath, String defaultClasspath) {
        ArrayList<J2MEPlatform.J2MEProfile> result = new ArrayList<J2MEPlatform.J2MEProfile>();
        StringTokenizer st = new StringTokenizer(defaultClasspath, ",");
        HashSet<String> defaultCp = new HashSet<String>();
        while (st.hasMoreTokens()) {
            defaultCp.add(UEIEmulatorConfiguratorImpl.cutPath(froot, UEIEmulatorConfiguratorImpl.getFile(froot, st.nextToken())));
        }
        st = new StringTokenizer(classpath, ",");
        HashSet<Object> files = new HashSet<Object>();
        try {
            HashSet<File> ff = new HashSet<File>();
            while (st.hasMoreTokens()) {
                try {
                    String name;
                    File f = UEIEmulatorConfiguratorImpl.getFile(froot, st.nextToken());
                    if (!ff.add(f)) continue;
                    if (f.isDirectory()) {
                        files.add(f);
                        continue;
                    }
                    if (!f.isFile() || !(name = f.getName().toLowerCase()).endsWith(".zip") && !name.endsWith(".jar")) continue;
                    files.add(new JarFile(f));
                }
                catch (IOException ioe) {}
            }
            HashMap assignedRoots = new HashMap();
            HashMap<String, Object> foundAPIs = new HashMap<String, Object>();
            HashMap<String, String> dependencies = new HashMap<String, String>();
            HashMap<String, String> dispNames = new HashMap<String, String>();
            boolean foundMIDP = false;
            for (Object arrayList : files) {
                HashSet old;
                Manifest m = UEIEmulatorConfiguratorImpl.getManifest(arrayList);
                if (m == null) continue;
                String string = m.getMainAttributes().getValue("API");
                String version = m.getMainAttributes().getValue("API-Specification-Version");
                if (string == null) continue;
                boolean bl = foundMIDP = foundMIDP || "MIDP".equals(string);
                if (version == null) {
                    version = "1.0";
                }
                String string2 = string + '-' + version;
                String d = m.getMainAttributes().getValue("API-Dependencies");
                if (d != null) {
                    dependencies.put(string2, d);
                }
                if ((d = m.getMainAttributes().getValue("API-Name")) != null) {
                    dispNames.put(string, d);
                }
                if ((old = (HashSet)foundAPIs.get(string2)) != null) {
                    old = new HashSet(old);
                    old.add(arrayList);
                    foundAPIs.put(string2, old);
                } else {
                    foundAPIs.put(string2, Collections.singleton(arrayList));
                }
                HashSet s = (HashSet)assignedRoots.get(string);
                if (s == null) {
                    s = new HashSet();
                    assignedRoots.put(string, s);
                }
                s.add(arrayList);
            }
            for (int i = 0; i < APIs.length; ++i) {
                void var14_25;
                void var14_23;
                if (foundAPIs.containsKey(APIs[i][0] + '-' + APIs[i][1])) continue;
                Object var14_19 = null;
                HashSet ignoreRoots = (HashSet)assignedRoots.get(APIs[i][0]);
                if (ignoreRoots == null) {
                    ignoreRoots = new HashSet();
                    assignedRoots.put(APIs[i][0], ignoreRoots);
                }
                boolean[] blArray = new boolean[APIs[i].length - 2];
                for (Object e : files) {
                    void var14_20;
                    if (ignoreRoots.contains(e)) continue;
                    boolean all = true;
                    boolean any = false;
                    for (int j = 2; j < APIs[i].length; ++j) {
                        if (UEIEmulatorConfiguratorImpl.contains(e, APIs[i][j])) {
                            blArray[j - 2] = true;
                            any = true;
                            continue;
                        }
                        all = false;
                    }
                    if (all) {
                        Set set = Collections.singleton(e);
                        break;
                    }
                    if (!any) continue;
                    if (var14_20 == null) {
                        HashSet hashSet = new HashSet();
                    }
                    var14_20.add(e);
                }
                if (var14_23 instanceof HashSet) {
                    for (int j = 0; j < blArray.length; ++j) {
                        if (blArray[j]) continue;
                        Object var14_24 = null;
                        break;
                    }
                }
                if (var14_25 == null) continue;
                foundMIDP = foundMIDP || "MIDP".equals(APIs[i][0]);
                ignoreRoots.addAll(var14_25);
                foundAPIs.put(APIs[i][0] + '-' + APIs[i][1], var14_25);
            }
            HashSet undetected = new HashSet(files);
            for (Map.Entry e : foundAPIs.entrySet()) {
                String string = (String)e.getKey();
                int i = string.lastIndexOf(45);
                String string3 = string.substring(i + 1);
                String string4 = string.substring(0, i);
                if (foundMIDP && ("IMP".equals(string4) || "IMP-NG".equals(string4))) continue;
                String dispName = (String)dispNames.get(string4);
                try {
                    dispName = NbBundle.getMessage(UEIEmulatorConfiguratorImpl.class, (String)string4);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                String type = "CLDC".equals(string4) ? "configuration" : ("MIDP".equals(string4) || "IMP".equals(string4) || "IMP-NG".equals(string4) ? "profile" : "optional");
                StringBuffer cp = new StringBuffer();
                boolean def = true;
                for (Object obj : (Set)e.getValue()) {
                    String cpEl = UEIEmulatorConfiguratorImpl.cutPath(froot, obj);
                    if (cp.length() > 0) {
                        cp.append(':');
                    }
                    cp.append(cpEl);
                    if (defaultCp.contains(cpEl)) continue;
                    def = false;
                }
                result.add(new J2MEPlatform.J2MEProfile(string4, string3, dispName, type, (String)dependencies.get(e.getKey()), cp.toString(), def));
                undetected.removeAll((Collection)e.getValue());
            }
            for (Object obj : undetected) {
                String string = UEIEmulatorConfiguratorImpl.cutPath(froot, obj);
                String dispName = string.startsWith("${platform.home}/") ? string.substring("${platform.home}/".length()) : string;
                J2MEPlatform.J2MEProfile j2MEProfile = new J2MEPlatform.J2MEProfile(dispName, "1.0", dispName, "optional", null, string, defaultCp.contains(string));
                result.add(j2MEProfile);
            }
            ArrayList<J2MEPlatform.J2MEProfile> arrayList = result;
            return arrayList;
        }
        finally {
            for (Object e : files) {
                if (!(e instanceof JarFile)) continue;
                try {
                    ((JarFile)e).close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private static boolean contains(Object root, String file) {
        if (root instanceof JarFile) {
            return ((JarFile)root).getEntry(file) != null;
        }
        return new File((File)root, file).isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Manifest getManifest(Object root) {
        try {
            if (root instanceof JarFile) {
                return ((JarFile)root).getManifest();
            }
            File f = new File((File)root, "META-INF/manifest.mf");
            if (!f.isFile()) return null;
            if (!f.canRead()) return null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(f);
                Manifest manifest = new Manifest(fis);
                return manifest;
            }
            catch (IOException e) {
                return null;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public UEIEmulatorConfiguratorImpl(String platformPath) {
        this.platformPath = FileUtil.normalizeFile((File)new File(platformPath)).getPath();
        this.process = platformPath + File.separatorChar + "bin" + File.separatorChar + "emulator";
        if (Utilities.isWindows()) {
            this.process = this.process + ".exe";
        }
    }

    public String getPlatformPath() {
        return this.platformPath;
    }

    public J2MEPlatform getPlatform() {
        return this.getPlatform(new OutputStreamWriter((OutputStream)new NullOutputStream()));
    }

    public J2MEPlatform getPlatform(Writer writer) {
        PrintWriter pw;
        PrintWriter printWriter = pw = writer != null ? new PrintWriter(writer) : null;
        if (pw != null) {
            pw.println(NbBundle.getMessage(UEIEmulatorConfiguratorImpl.class, (String)"LAB_GettingConfiguration"));
        }
        if (!this.processVersion(pw)) {
            if (pw != null) {
                pw.println(NbBundle.getMessage(UEIEmulatorConfiguratorImpl.class, (String)"LAB_Failed"));
            }
            if (pw != null) {
                pw.flush();
            }
            return null;
        }
        if (pw != null) {
            pw.println(NbBundle.getMessage(UEIEmulatorConfiguratorImpl.class, (String)"LAB_GettingProperties"));
        }
        if (!this.processProperties(pw)) {
            if (pw != null) {
                pw.println(NbBundle.getMessage(UEIEmulatorConfiguratorImpl.class, (String)"LAB_Failed"));
            }
            if (pw != null) {
                pw.flush();
            }
            return null;
        }
        if (pw != null) {
            pw.println(NbBundle.getMessage(UEIEmulatorConfiguratorImpl.class, (String)"LAB_GettingAllProfiles"));
        }
        this.platformType = "UEI-1.0";
        ArrayList<J2MEPlatform.Device> devices = this.resolveDevices(pw);
        if (pw != null) {
            pw.println(NbBundle.getMessage(UEIEmulatorConfiguratorImpl.class, (String)"LAB_Success"));
        }
        if (pw != null) {
            pw.flush();
        }
        String srcpath = null;
        String docpath = this.findDocsPath();
        J2MEPlatform.Device[] devicesArray = devices.toArray(new J2MEPlatform.Device[devices.size()]);
        if (devicesArray.length <= 0) {
            if (pw != null) {
                pw.println(NbBundle.getMessage(UEIEmulatorConfiguratorImpl.class, (String)"LAB_Failed"));
            }
            if (pw != null) {
                pw.flush();
            }
            return null;
        }
        return new J2MEPlatform(J2MEPlatform.computeUniqueName(this.platformName), this.platformPath, this.platformType, this.platformName, srcpath, docpath, null, null, null, devicesArray);
    }

    private ArrayList<J2MEPlatform.Device> resolveDevices(PrintWriter pw) {
        ArrayList<J2MEPlatform.Device> devices = new ArrayList<J2MEPlatform.Device>();
        StringTokenizer devicesTokens = new StringTokenizer(this.properties.getProperty("device.list", ""), ",");
        File plDir = new File(this.platformPath);
        File libDir = new File(this.platformPath, "lib");
        File[] libFiles = null;
        if (libDir.exists() && libDir.isDirectory()) {
            libFiles = libDir.listFiles();
        }
        File libextFile = new File(this.platformPath, "lib/ext");
        File[] files = null;
        if (libextFile.exists() && libextFile.isDirectory()) {
            files = libextFile.listFiles();
        }
        while (devicesTokens.hasMoreTokens()) {
            String jarsString;
            String deviceName = devicesTokens.nextToken().trim();
            String deviceDescription = this.properties.getProperty(deviceName + ".description");
            String securitydomains = this.properties.getProperty(deviceName + ".security.domains");
            String[] securitydomainsArray = PlatformConvertor.string2array(securitydomains);
            String bootClassPathString = this.properties.getProperty(deviceName + ".bootclasspath");
            if (bootClassPathString == null) {
                StringBuffer sb = null;
                if (libFiles != null) {
                    for (int a = 0; a < libFiles.length; ++a) {
                        String name;
                        File file = libFiles[a];
                        if (!file.exists() || !file.isFile() || (name = file.getName().toLowerCase()) == null || !name.endsWith(".jar") && !name.endsWith(".zip")) continue;
                        if (sb == null) {
                            sb = new StringBuffer(file.getAbsolutePath().length() * libFiles.length);
                        } else {
                            sb.append(',');
                        }
                        sb.append(file.getAbsolutePath());
                    }
                }
                if (sb != null) {
                    bootClassPathString = sb.toString();
                }
            }
            if ((jarsString = this.properties.getProperty(deviceName + ".apis")) != null) {
                this.platformType = "UEI-1.0.1";
            } else {
                jarsString = bootClassPathString;
                if (files != null) {
                    StringBuffer sb = null;
                    for (int a = 0; a < files.length; ++a) {
                        String name;
                        File file = files[a];
                        if (!file.exists() || !file.isFile() || (name = file.getName().toLowerCase()) == null || !name.endsWith(".jar") && !name.endsWith(".zip")) continue;
                        if (sb == null) {
                            sb = new StringBuffer(file.getAbsolutePath().length() * files.length);
                        } else {
                            sb.append(',');
                        }
                        sb.append(file.getAbsolutePath());
                    }
                    if (sb != null) {
                        jarsString = jarsString == null || "".equals(jarsString) ? sb.toString() : bootClassPathString + "," + sb.toString();
                    }
                }
                if (jarsString == null) {
                    if (pw == null) continue;
                    pw.println(NbBundle.getMessage(UEIEmulatorConfiguratorImpl.class, (String)"WARN_IgnoringDevice", (Object)deviceName));
                    continue;
                }
            }
            List<J2MEPlatform.J2MEProfile> jars = UEIEmulatorConfiguratorImpl.analyzePath(plDir, jarsString, bootClassPathString);
            String configuration = this.properties.getProperty(deviceName + ".version.configuration");
            if (configuration != null && configuration.startsWith("CDC")) continue;
            String screenWidth = this.properties.getProperty(deviceName + ".screen.width");
            String screenHeight = this.properties.getProperty(deviceName + ".screen.height");
            String screenBitDepth = this.properties.getProperty(deviceName + ".screen.bitDepth");
            String screenIsColor = this.properties.getProperty(deviceName + ".screen.isColor");
            String screenIsTouch = this.properties.getProperty(deviceName + ".screen.isTouch");
            J2MEPlatform.Screen screen = new J2MEPlatform.Screen(screenWidth, screenHeight, screenBitDepth, screenIsColor, screenIsTouch);
            J2MEPlatform.J2MEProfile[] profilesArray = jars.toArray(new J2MEPlatform.J2MEProfile[jars.size()]);
            devices.add(new J2MEPlatform.Device(deviceName, deviceDescription, securitydomainsArray, profilesArray, screen));
        }
        return devices;
    }

    private void findDocAPIDirs(ArrayList<File> outputList, File directory, int depth) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (int a = 0; a < files.length; ++a) {
                File file = files[a];
                if (!file.isDirectory()) continue;
                if (file.getName().toLowerCase().indexOf("doc") >= 0) {
                    this.findDocRoots(outputList, file, 3);
                    continue;
                }
                if (depth <= 0) continue;
                this.findDocAPIDirs(outputList, file, depth - 1);
            }
        }
    }

    private void findDocRoots(ArrayList<File> outputList, File directory, int depth) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (int a = 0; a < files.length; ++a) {
                File file = files[a];
                if (file.isFile() && "index.html".equals(file.getName().toLowerCase())) {
                    outputList.add(directory);
                    continue;
                }
                if (depth <= 0 || !file.isDirectory()) continue;
                this.findDocRoots(outputList, file, depth - 1);
            }
        }
    }

    private String findDocsPath() {
        ArrayList<File> docs = new ArrayList<File>();
        this.findDocAPIDirs(docs, new File(this.platformPath), 3);
        StringBuffer ret = null;
        for (int a = 0; a < docs.size(); ++a) {
            if (ret == null) {
                ret = new StringBuffer(docs.get(a).getAbsolutePath().length() * docs.size());
            } else {
                ret.append(", ");
            }
            ret.append(FileUtil.normalizeFile((File)docs.get(a)).getPath());
        }
        return ret == null ? null : ret.toString();
    }

    private void execute(String argument, PrintWriter pw) throws IOException {
        File execFile = new File(this.process);
        File binDir = execFile.exists() ? execFile.getParentFile() : null;
        String[] s = new String[]{this.process, argument};
        this.emulatorProcess = binDir != null ? Runtime.getRuntime().exec(s, null, binDir) : Runtime.getRuntime().exec(s);
        InputStream inputStream = this.emulatorProcess.getInputStream();
        InputStream errorStream = this.emulatorProcess.getErrorStream();
        this.emulatorOutput = new StringBuffer(1024);
        this.emulatorError = new StringBuffer(1024);
        StreamCatcher out = new StreamCatcher(inputStream, this.emulatorOutput, pw);
        StreamCatcher err = new StreamCatcher(errorStream, this.emulatorError, pw);
        out.start();
        err.start();
        try {
            this.emulatorProcess.waitFor();
            out.join(10000L);
            err.join(10000L);
        }
        catch (InterruptedException ex) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(), (Throwable)ex);
        }
        finally {
            this.emulatorProcess.destroy();
        }
        if (this.emulatorProcess.exitValue() != 0) {
            throw new IOException("exec, exitCode != 0");
        }
    }

    private boolean resolveVersion(StringBuffer sb) throws IOException {
        this.platformName = null;
        BufferedReader br = new BufferedReader(new StringReader(sb.toString()));
        this.platformName = br.readLine();
        br.close();
        return this.platformName != null;
    }

    private boolean processVersion(PrintWriter pw) {
        try {
            this.execute(CMD_VERSION, pw);
            if (!this.resolveVersion(this.emulatorOutput) && !this.resolveVersion(this.emulatorError)) {
                return false;
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean processProperties(PrintWriter pw) {
        this.properties = new Properties();
        try {
            this.execute(CMD_QUERY, pw);
            String output = this.emulatorOutput.toString();
            if ("".equals(output)) {
                output = this.emulatorError.toString();
            }
            this.properties.load((InputStream)new ReaderInputStream((Reader)new StringReader(output)));
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        UEIEmulatorConfiguratorImpl c = new UEIEmulatorConfiguratorImpl("/opt/nokia/Devices/Series_60_MIDP_Concept_SDK_Beta_0_3_1_Nokia_edition");
        c.getPlatform(new OutputStreamWriter(System.out));
    }

    private static class StreamCatcher
    extends Thread {
        InputStream is;
        StringBuffer sb;
        private final PrintWriter pw;

        StreamCatcher(InputStream is, StringBuffer sb, PrintWriter pw) {
            this.is = is;
            this.sb = sb;
            this.pw = pw;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: {
                try {
                    InputStreamReader r = new InputStreamReader(this.is);
                    try {
                        int len;
                        char[] buf = new char[256];
                        while ((len = r.read(buf)) >= 0) {
                            this.sb.append(buf, 0, len);
                        }
                    }
                    finally {
                        r.close();
                    }
                }
                catch (IOException ioEx) {
                    if (this.pw == null) break block6;
                    ioEx.printStackTrace(this.pw);
                }
            }
        }

        public StringBuffer getBuffer() {
            return this.sb;
        }
    }
}

