/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display.property;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.netbeans.modules.vmd.api.io.PopupUtil;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpTypes;

public class ScreenTextFieldPropertyEditor
implements ScreenPropertyEditor {
    private String propertyName;
    private int alignment;
    private String refComponentPropertyName;
    private DesignComponent relatedComponent;

    public ScreenTextFieldPropertyEditor(String string) {
        this(string, null, 2);
    }

    public ScreenTextFieldPropertyEditor(String string, String string2) {
        this(string, string2, 2);
    }

    public ScreenTextFieldPropertyEditor(String string, int n) {
        this(string, null, n);
    }

    public ScreenTextFieldPropertyEditor(String string, String string2, int n) {
        this.alignment = n;
        assert (string != null);
        this.propertyName = string;
        this.refComponentPropertyName = string2;
    }

    public JComponent createEditorComponent(ScreenPropertyDescriptor screenPropertyDescriptor) {
        this.relatedComponent = this.refComponentPropertyName == null ? screenPropertyDescriptor.getRelatedComponent() : screenPropertyDescriptor.getRelatedComponent().readProperty(this.refComponentPropertyName).getComponent();
        StringTextField stringTextField = new StringTextField(screenPropertyDescriptor);
        stringTextField.setMinimumSize(new Dimension(128, 21));
        PropertyValue propertyValue = this.relatedComponent.readProperty(this.propertyName);
        String string = MidpTypes.getString(propertyValue);
        stringTextField.setText(string != null ? string : "");
        stringTextField.selectAll();
        return stringTextField;
    }

    public Insets getEditorComponentInsets(JComponent jComponent) {
        return jComponent.getBorder().getBorderInsets(jComponent);
    }

    private class StringTextField
    extends JTextField
    implements KeyListener {
        private ScreenPropertyDescriptor property;

        public StringTextField(ScreenPropertyDescriptor screenPropertyDescriptor) {
            this.property = screenPropertyDescriptor;
            this.addKeyListener(this);
            this.setHorizontalAlignment(ScreenTextFieldPropertyEditor.this.alignment);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() != '\n') {
                return;
            }
            this.property.getRelatedComponent().getDocument().getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    if (ScreenTextFieldPropertyEditor.this.relatedComponent == null) {
                        throw new IllegalStateException();
                    }
                    PropertyValue propertyValue = MidpTypes.createStringValue(StringTextField.this.getText());
                    ScreenTextFieldPropertyEditor.this.relatedComponent.writeProperty(ScreenTextFieldPropertyEditor.this.propertyName, propertyValue);
                }
            });
            PopupUtil.hidePopup();
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

