/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils;

import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;

public class CndUtils {
    private static final Logger LOG = Logger.getLogger("cnd.logger");
    private static boolean releaseMode;

    private CndUtils() {
    }

    public static boolean isStandalone() {
        return !CndUtils.class.getClassLoader().getClass().getName().startsWith("org.netbeans.");
    }

    public static boolean isReleaseMode() {
        return releaseMode;
    }

    public static boolean isDebugMode() {
        return !CndUtils.isReleaseMode();
    }

    public static boolean isUnitTestMode() {
        return Boolean.getBoolean("cnd.mode.unittest");
    }

    public static boolean getBoolean(String name, boolean result) {
        String text = System.getProperty(name);
        if (text != null) {
            result = Boolean.parseBoolean(text);
        }
        return result;
    }

    public static void threadsDump() {
        Set<Map.Entry<Thread, StackTraceElement[]>> stack = Thread.getAllStackTraces().entrySet();
        System.err.println("-----Start Thread Dump-----");
        for (Map.Entry<Thread, StackTraceElement[]> entry : stack) {
            System.err.println(entry.getKey().getName());
            for (StackTraceElement element : entry.getValue()) {
                System.err.println("\tat " + element.toString());
            }
            System.err.println();
        }
        System.err.println("-----End Thread Dump-----");
    }

    public static void assertTrue(boolean value) {
        if (CndUtils.isDebugMode()) {
            CndUtils.assertTrue(value, "Assertion error");
        }
    }

    public static void assertNotNull(Object object, String message) {
        if (CndUtils.isDebugMode()) {
            CndUtils.assertTrue(object != null, message);
        }
    }

    public static int getNumberCndWorkerThreads() {
        int threadCount = Integer.getInteger("cnd.modelimpl.parser.threads", Runtime.getRuntime().availableProcessors());
        return Math.max(threadCount, 1);
    }

    public static int getConcurrencyLevel() {
        return CndUtils.getNumberCndWorkerThreads();
    }

    public static String getIncludeFileBase() {
        return FileNamePrefixAccessor.path;
    }

    public static String getIncludeFilePrefix(String hostid) {
        return CndUtils.getIncludeFileBase() + hostid + "/";
    }

    public static void assertFalse(boolean value) {
        if (CndUtils.isDebugMode()) {
            CndUtils.assertTrue(!value, "Assertion error");
        }
    }

    public static void assertFalse(boolean value, String message) {
        CndUtils.assertTrue(!value, message);
    }

    public static void assertTrue(boolean value, String message) {
        if (CndUtils.isDebugMode() && !value) {
            LOG.log(Level.SEVERE, message, new Exception(message));
        }
    }

    public static void assertTrueInConsole(boolean value, String message) {
        if (CndUtils.isDebugMode() && !value) {
            LOG.log(Level.INFO, message, new Exception(message));
        }
    }

    public static void assertNonUiThread() {
        CndUtils.assertFalse(SwingUtilities.isEventDispatchThread(), "Should not be called from UI thread");
    }

    public static void assertUiThread() {
        CndUtils.assertTrue(SwingUtilities.isEventDispatchThread(), "Should be called only from UI thread");
    }

    public static void assertNormalized(File file) {
        File normFile;
        if (CndUtils.isDebugMode() && !file.equals(normFile = CndFileUtils.normalizeFile(file))) {
            CndUtils.assertTrueInConsole(false, "Parameter file was not normalized. Was " + file + " instead of " + normFile);
        }
    }

    static {
        String text = System.getProperty("cnd.release.mode");
        if (text == null) {
            releaseMode = true;
            if (!$assertionsDisabled) {
                releaseMode = false;
                if (false) {
                    throw new AssertionError();
                }
            }
        } else {
            releaseMode = Boolean.parseBoolean(text);
        }
    }

    private static final class FileNamePrefixAccessor {
        private static final String path = System.getProperty("netbeans.user").replace('\\', '/') + "/var/cache/cnd/remote-includes/";

        private FileNamePrefixAccessor() {
        }
    }
}

