/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.modules.dlight.spi.CppSymbolDemangler;
import org.netbeans.modules.dlight.spi.CppSymbolDemanglerFactory;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.util.Exceptions;

public class CppSymbolDemanglerImpl
implements CppSymbolDemangler {
    private static final String ECHO = "echo";
    private static final String DEM = "dem";
    private static final String GCPPFILT = "gc++filt";
    private static final String CPPFILT = "c++filt";
    private static final String EQUALS_EQUALS = " == ";
    private static final int MAX_CMDLINE_LENGTH = 2000;
    private static final Map<String, String> demangledCache = new HashMap<String, String>();
    private final List<String> searchPaths;
    private final ExecutionEnvironment env;
    private final CppSymbolDemanglerFactory.CPPCompiler cppCompiler;
    private String demanglerTool;
    private boolean demanglerChecked;

    public CppSymbolDemanglerImpl(ExecutionEnvironment execEnv, CppSymbolDemanglerFactory.CPPCompiler cppCompiler, String compilerBinDir) {
        this.env = execEnv;
        this.cppCompiler = cppCompiler;
        this.searchPaths = compilerBinDir == null ? Collections.emptyList() : Collections.singletonList(compilerBinDir);
        switch (cppCompiler) {
            case GNU: {
                this.demanglerTool = GCPPFILT;
                break;
            }
            case SS: {
                this.demanglerTool = DEM;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown cppCompiler " + cppCompiler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String demangle(String symbolName) {
        String mangledName = CppSymbolDemanglerImpl.stripModuleAndOffset(symbolName);
        if (!this.isToolAvailable() || !this.isMangled(mangledName)) {
            return mangledName;
        }
        String demangledName = null;
        Map<String, String> map = demangledCache;
        synchronized (map) {
            demangledName = demangledCache.get(mangledName);
        }
        if (demangledName == null) {
            List<String> list = Arrays.asList(mangledName);
            this.demangleImpl(list);
            demangledName = list.get(0);
            Map<String, String> map2 = demangledCache;
            synchronized (map2) {
                demangledCache.put(mangledName, demangledName);
            }
        }
        return demangledName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> demangle(List<String> symbolNames) {
        int i;
        ArrayList<String> result = new ArrayList<String>(symbolNames.size());
        for (String name : symbolNames) {
            result.add(CppSymbolDemanglerImpl.stripModuleAndOffset(name));
        }
        if (!this.isToolAvailable()) {
            return result;
        }
        ArrayList<String> missedNames = new ArrayList<String>();
        ArrayList<Integer> missedIdxs = new ArrayList<Integer>();
        Map<String, String> map = demangledCache;
        synchronized (map) {
            for (i = 0; i < result.size(); ++i) {
                String mangledName = (String)result.get(i);
                if (!this.isMangled(mangledName)) continue;
                String demangledName = demangledCache.get(mangledName);
                if (demangledName == null) {
                    missedNames.add(mangledName);
                    missedIdxs.add(i);
                    continue;
                }
                result.set(i, demangledName);
            }
        }
        if (!missedNames.isEmpty()) {
            this.splitAndDemangle(missedNames);
            map = demangledCache;
            synchronized (map) {
                for (i = 0; i < missedNames.size(); ++i) {
                    int idx = (Integer)missedIdxs.get(i);
                    String mangledName = (String)result.get(idx);
                    String demangledName = (String)missedNames.get(i);
                    demangledCache.put(mangledName, demangledName);
                    result.set(idx, demangledName);
                }
            }
        }
        return result;
    }

    private boolean isMangled(String name) {
        return 0 < name.length() && name.charAt(0) == '_' || 0 <= name.indexOf("__");
    }

    private static String stripModuleAndOffset(String functionName) {
        int tickPos;
        int plusPos = functionName.indexOf("+0x");
        if (0 <= plusPos) {
            functionName = functionName.substring(0, plusPos);
        }
        if (0 <= (tickPos = functionName.indexOf(96))) {
            functionName = functionName.substring(tickPos + 1);
        }
        return functionName;
    }

    private void splitAndDemangle(List<String> mangledNames) {
        if (this.demanglerTool == null) {
            return;
        }
        ListIterator<String> it = mangledNames.listIterator();
        while (it.hasNext()) {
            String name;
            int startIdx = it.nextIndex();
            for (int cmdlineLength = ECHO.length() + this.demanglerTool.length(); it.hasNext() && cmdlineLength < 2000; cmdlineLength += name.length() + 3) {
                name = it.next();
            }
            int endIdx = it.nextIndex();
            List<String> mangledNamesSublist = mangledNames.subList(startIdx, endIdx);
            this.demangleImpl(mangledNamesSublist);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void demangleImpl(List<String> mangledNames) {
        boolean demanglerReadsStdin;
        this.checkDemanglerIfNeeded();
        if (this.demanglerTool == null) {
            return;
        }
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.env);
        npb.setExecutable(this.demanglerTool);
        boolean bl = demanglerReadsStdin = this.demanglerTool.contains(GCPPFILT) || this.demanglerTool.contains(CPPFILT);
        if (!demanglerReadsStdin) {
            npb.setArguments(mangledNames.toArray(new String[mangledNames.size()]));
        }
        Future task = DLightExecutorService.submit((Callable)npb, (String)"CPPSymbolDemangler call");
        try {
            NativeProcess np = (NativeProcess)task.get();
            DemanglerOutputCollector outputCollector = new DemanglerOutputCollector(np.getInputStream());
            Thread outputCollectorThread = new Thread(outputCollector);
            outputCollectorThread.start();
            if (demanglerReadsStdin) {
                try {
                    OutputStream outputStream = np.getOutputStream();
                    try {
                        for (String mangledName : mangledNames) {
                            outputStream.write(mangledName.getBytes());
                            outputStream.write(10);
                        }
                        outputStream.flush();
                    }
                    finally {
                        outputStream.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            np.waitFor();
            outputCollectorThread.join();
            List demangledNames = outputCollector.getDemangledNames();
            if (demangledNames.size() == mangledNames.size()) {
                for (int i = 0; i < mangledNames.size(); ++i) {
                    mangledNames.set(i, (String)demangledNames.get(i));
                }
            }
        }
        catch (InterruptedException e) {
        }
        catch (ExecutionException execException) {
            // empty catch block
        }
    }

    private synchronized void checkDemanglerIfNeeded() {
        if (!this.demanglerChecked) {
            String exeSuffix = "";
            try {
                HostInfo hostinfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.env);
                if (hostinfo.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
                    exeSuffix = ".exe";
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            String absPath = HostInfoUtils.searchFile((ExecutionEnvironment)this.env, this.searchPaths, (String)(this.demanglerTool + exeSuffix), (boolean)true);
            this.demanglerTool = absPath == null ? ((absPath = HostInfoUtils.searchFile((ExecutionEnvironment)this.env, this.searchPaths, (String)(CPPFILT + exeSuffix), (boolean)true)) == null ? null : absPath) : absPath;
            this.demanglerChecked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache() {
        Map<String, String> map = demangledCache;
        synchronized (map) {
            demangledCache.clear();
        }
    }

    boolean isToolAvailable() {
        this.checkDemanglerIfNeeded();
        return this.demanglerTool != null;
    }

    private static class DemanglerOutputCollector
    implements Runnable {
        private final InputStream inputStream;
        private final List<String> demangledNames;

        private DemanglerOutputCollector(InputStream inputStream) {
            this.inputStream = inputStream;
            this.demangledNames = new ArrayList<String>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (line.length() == 0) continue;
                        int eqPos = line.indexOf(CppSymbolDemanglerImpl.EQUALS_EQUALS);
                        this.demangledNames.add(0 <= eqPos ? line.substring(eqPos + CppSymbolDemanglerImpl.EQUALS_EQUALS.length()) : line);
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private List<String> getDemangledNames() {
            return this.demangledNames;
        }
    }
}

