/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

public class IntConfiguration {
    private IntConfiguration master;
    private byte def;
    private String[] names;
    private String[] options;
    private byte value;
    private boolean modified;
    private boolean dirty = false;

    public IntConfiguration(IntConfiguration master, int def, String[] names, String[] options) {
        this.master = master;
        this.def = (byte)def;
        this.names = names;
        this.options = options;
        this.reset();
    }

    protected IntConfiguration() {
    }

    public void setMaster(IntConfiguration master) {
        this.master = master;
    }

    public void setValue(int value) {
        this.value = (byte)value;
        if (this.master != null) {
            this.setModified(true);
        } else {
            this.setModified(value != this.getDefault());
        }
    }

    public void setValue(String s) {
        if (s != null) {
            for (int i = 0; i < this.names.length; ++i) {
                if (!s.equals(this.names[i])) continue;
                this.setValue(i);
                break;
            }
        }
    }

    public int getValue() {
        if (this.master != null && !this.getModified()) {
            return this.master.getValue();
        }
        return this.value;
    }

    public final void setModified(boolean b) {
        this.modified = b;
    }

    public boolean getModified() {
        return this.modified;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public int getDefault() {
        return this.def;
    }

    public void setDefault(int def) {
        this.def = (byte)def;
        this.setModified(this.value != this.getDefault());
    }

    public final void reset() {
        this.value = (byte)this.getDefault();
        this.setModified(false);
    }

    public String getName() {
        if (this.getValue() < this.names.length) {
            return this.names[this.getValue()];
        }
        return "???";
    }

    public String[] getNames() {
        return this.names;
    }

    public String getOption() {
        return this.options[this.getValue()] + " ";
    }

    public void assign(IntConfiguration conf) {
        this.dirty = this.getValue() != conf.getValue();
        this.setValue(conf.getValue());
        this.setModified(conf.getModified());
    }

    public IntConfiguration clone() {
        IntConfiguration clone = new IntConfiguration(this.master, this.def, this.names, this.options);
        clone.setValue(this.getValue());
        clone.setModified(this.getModified());
        return clone;
    }

    public String toString() {
        return "(" + this.getValue() + ")" + this.getName();
    }
}

