/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.universe.ClusterUtils;

public final class ClusterInfo {
    private File clusterDir;
    private boolean isPlatformCluster;
    private Project project;
    private boolean enabled;
    private URL[] sourceRoots;
    private URL[] javadocRoots;

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClusterInfo other = (ClusterInfo)obj;
        if (!(this.clusterDir == other.clusterDir || this.clusterDir != null && this.clusterDir.equals(other.clusterDir))) {
            return false;
        }
        if (this.isPlatformCluster != other.isPlatformCluster) {
            return false;
        }
        if (!(this.project == other.project || this.project != null && this.project.equals(other.project))) {
            return false;
        }
        if (this.enabled != other.enabled) {
            return false;
        }
        if (!Arrays.deepEquals(this.sourceRoots, other.sourceRoots)) {
            return false;
        }
        return Arrays.deepEquals(this.javadocRoots, other.javadocRoots);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.clusterDir != null ? this.clusterDir.hashCode() : 0);
        hash = 47 * hash + (this.isPlatformCluster ? 1 : 0);
        hash = 47 * hash + (this.project != null ? this.project.hashCode() : 0);
        hash = 47 * hash + (this.enabled ? 1 : 0);
        hash = 47 * hash + Arrays.deepHashCode(this.sourceRoots);
        hash = 47 * hash + Arrays.deepHashCode(this.javadocRoots);
        return hash;
    }

    public String toString() {
        return this.clusterDir.getAbsolutePath() + (this.isEnabled() ? "" : " (DISABLED)") + (this.project != null ? " (from " + this.project.getProjectDirectory() + ")" : "") + (this.isPlatformCluster ? " (PLATFORM)" : "") + (this.sourceRoots != null ? " (src=" + Arrays.toString(this.sourceRoots) + ")" : "") + (this.javadocRoots != null ? " (javadoc=" + Arrays.toString(this.javadocRoots) + ")" : "");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isPlatformCluster() {
        return this.isPlatformCluster;
    }

    public boolean isExternalCluster() {
        return !this.isPlatformCluster && this.project == null;
    }

    public File getClusterDir() {
        return this.clusterDir;
    }

    private ClusterInfo(File clusterDir) {
        this.clusterDir = clusterDir;
    }

    public static ClusterInfo createFromCP(File evaluatedPath, Project prj, boolean isPlatformCluster, URL[] sourceRoots, URL[] javadocRoots, boolean enabled) {
        ClusterInfo ret = new ClusterInfo(evaluatedPath);
        ret.isPlatformCluster = isPlatformCluster;
        ret.project = prj;
        ret.enabled = enabled;
        ret.sourceRoots = sourceRoots;
        ret.javadocRoots = javadocRoots;
        return ret;
    }

    public static ClusterInfo create(File clusterDir, boolean isPlatformCluster, boolean enabled) {
        ClusterInfo ret = new ClusterInfo(clusterDir);
        ret.isPlatformCluster = isPlatformCluster;
        ret.enabled = enabled;
        return ret;
    }

    public static ClusterInfo createExternal(File clusterDir, URL[] sourceRoots, URL[] javadocRoots, boolean enabled) {
        ClusterInfo ret = new ClusterInfo(clusterDir);
        ret.isPlatformCluster = false;
        ret.enabled = enabled;
        ret.sourceRoots = sourceRoots;
        ret.javadocRoots = javadocRoots;
        return ret;
    }

    public static QueryResult canCreate(Project project) {
        NbModuleProvider nbmp = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
        SuiteProvider sprv = (SuiteProvider)project.getLookup().lookup(SuiteProvider.class);
        if (sprv != null) {
            if (nbmp == null) {
                return QueryResult.OK;
            }
            assert (nbmp.getModuleType() == NbModuleProvider.SUITE_COMPONENT);
            return QueryResult.SUITE_COMP_NOT_ALLOWED;
        }
        if (nbmp != null) {
            if (nbmp.getModuleType() == NbModuleProvider.STANDALONE) {
                return QueryResult.OK;
            }
            return QueryResult.NBORG_PROJECT_NOT_ALLOWED;
        }
        return QueryResult.NOT_A_NBM_PROJECT;
    }

    public static ClusterInfo create(Project project, boolean enabled) {
        QueryResult res = ClusterInfo.canCreate(project);
        if (res != QueryResult.OK) {
            throw new IllegalArgumentException(res.getExceptionMessage());
        }
        NbModuleProvider nbmp = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
        SuiteProvider sprv = (SuiteProvider)project.getLookup().lookup(SuiteProvider.class);
        assert (nbmp != null || sprv != null);
        File clusterDir = nbmp != null ? ClusterUtils.getClusterDirectory(project) : sprv.getClusterDirectory();
        ClusterInfo ret = new ClusterInfo(clusterDir);
        ret.project = project;
        ret.enabled = enabled;
        return ret;
    }

    public Project getProject() {
        return this.project;
    }

    public URL[] getSourceRoots() {
        return this.sourceRoots;
    }

    public URL[] getJavadocRoots() {
        return this.javadocRoots;
    }

    public static enum QueryResult {
        OK("OK"),
        NOT_A_NBM_PROJECT("Not a NetBeans Module project"),
        NBORG_PROJECT_NOT_ALLOWED("NB.org projects are not allowed"),
        SUITE_COMP_NOT_ALLOWED("Suite component projects are not allowed, call for suite project instead");

        private String msg;

        private QueryResult(String exceptionMsg) {
            this.msg = exceptionMsg;
        }

        public String getExceptionMessage() {
            return this.msg;
        }
    }
}

