/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.toolsui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.util.NbBundle;

public class ListEditorPanel<E>
extends JPanel {
    private JList targetList = null;
    protected Vector<E> listData = new Vector();
    private boolean allowedToRemoveAll = true;
    private boolean isChanged = false;
    private JButton addButton;
    private JPanel controlsPanel;
    private JButton copyButton;
    private JPanel dataPanel;
    private JLabel listLabel;
    private JButton removeButton;
    private JButton renameButton;
    private JScrollPane scrollPane;

    public ListEditorPanel(List<E> objects) {
        this.initComponents();
        this.scrollPane.getViewport().setBackground(Color.WHITE);
        this.listLabel.setText(this.getListLabelText());
        this.listLabel.setDisplayedMnemonic(this.getListLabelMnemonic());
        this.addButton.setText(this.getAddButtonText());
        this.addButton.setMnemonic(this.getAddButtonMnemonics());
        this.addButton.getAccessibleContext().setAccessibleDescription(this.getAddButtonAD());
        this.copyButton.setText(this.getCopyButtonText());
        this.copyButton.setMnemonic(this.getCopyButtonMnemonics());
        this.copyButton.getAccessibleContext().setAccessibleDescription(this.getCopyButtonAD());
        this.renameButton.setText(this.getRenameButtonText());
        this.renameButton.setMnemonic(this.getRenameButtonMnemonics());
        this.renameButton.getAccessibleContext().setAccessibleDescription(this.getRenameButtonAD());
        this.removeButton.setText(this.getRemoveButtonText());
        this.removeButton.setMnemonic(this.getRemoveButtonMnemonics());
        this.removeButton.getAccessibleContext().setAccessibleDescription(this.getRemoveButtonAD());
        if (objects != null) {
            for (int i = 0; i < objects.size(); ++i) {
                this.listData.add(objects.get(i));
            }
        }
        this.targetList = new JList();
        this.targetList.setVisibleRowCount(6);
        this.targetList.setListData(this.listData);
        this.targetList.addListSelectionListener(new TargetSelectionListener());
        this.targetList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                Object[] ob = ListEditorPanel.this.targetList.getSelectedValues();
                if (ob.length != 1) {
                    return;
                }
                if (me.getClickCount() == 2) {
                    me.consume();
                    ListEditorPanel.this.editObjectAction();
                }
            }
        });
        this.targetList.getSelectionModel().setSelectionMode(0);
        this.scrollPane.setViewportView(this.getViewComponent());
        this.listLabel.setLabelFor(this.targetList);
        this.initAccessibility();
        if (this.targetList.getModel().getSize() > 0) {
            this.setSelectedIndex(0);
            this.targetList.requestFocus();
        } else {
            this.addButton.requestFocus();
        }
        this.checkSelection();
    }

    public void addExtraButton(JButton button, int index) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.controlsPanel.add(button, gridBagConstraints, index);
    }

    public void setAllowedToRemoveAll(boolean b) {
        this.allowedToRemoveAll = b;
        this.checkSelection();
    }

    public boolean getAllowedToRemoveAll() {
        return this.allowedToRemoveAll;
    }

    public JLabel getListLabel() {
        return this.listLabel;
    }

    public String getListLabelText() {
        return ListEditorPanel.getString("TARGET_EDITOR_LIST_LBL");
    }

    public char getListLabelMnemonic() {
        return ListEditorPanel.getString("TARGET_EDITOR_LIST_MNEMONIC").toCharArray()[0];
    }

    public String getAddButtonText() {
        return ListEditorPanel.getString("TARGET_EDITOR_ADD_BUTTON_LBL");
    }

    public char getAddButtonMnemonics() {
        return ListEditorPanel.getString("TARGET_EDITOR_ADD_BUTTON_MNEMONIC").toCharArray()[0];
    }

    public String getAddButtonAD() {
        return ListEditorPanel.getString("TARGET_EDITOR_ADD_BUTTON_AD");
    }

    public String getCopyButtonText() {
        return ListEditorPanel.getString("TARGET_EDITOR_COPY_BUTTON_LBL");
    }

    public char getCopyButtonMnemonics() {
        return ListEditorPanel.getString("TARGET_EDITOR_COPY_BUTTON_MNEMONIC").toCharArray()[0];
    }

    public String getCopyButtonAD() {
        return ListEditorPanel.getString("TARGET_EDITOR_COPY_BUTTON_AD");
    }

    public String getRenameButtonText() {
        return ListEditorPanel.getString("TARGET_EDITOR_RENAME_BUTTON_LBL");
    }

    public char getRenameButtonMnemonics() {
        return ListEditorPanel.getString("TARGET_EDITOR_RENAME_BUTTON_MNEMONIC").toCharArray()[0];
    }

    public String getRenameButtonAD() {
        return ListEditorPanel.getString("TARGET_EDITOR_RENAME_BUTTON_AD");
    }

    public String getRemoveButtonText() {
        return ListEditorPanel.getString("TARGET_EDITOR_REMOVE_BUTTON_LBL");
    }

    public char getRemoveButtonMnemonics() {
        return ListEditorPanel.getString("TARGET_EDITOR_REMOVE_BUTTON_MNEMONIC").toCharArray()[0];
    }

    public String getRemoveButtonAD() {
        return ListEditorPanel.getString("TARGET_EDITOR_REMOVE_BUTTON_AD");
    }

    public String getUpButtonText() {
        return ListEditorPanel.getString("TARGET_EDITOR_UP_BUTTON_LBL");
    }

    public char getUpButtonMnemonics() {
        return ListEditorPanel.getString("TARGET_EDITOR_UP_BUTTON_MNEMONIC").toCharArray()[0];
    }

    public String getUpButtonAD() {
        return ListEditorPanel.getString("TARGET_EDITOR_UP_BUTTON_AD");
    }

    public String getDownButtonText() {
        return ListEditorPanel.getString("TARGET_EDITOR_DOWN_BUTTON_LBL");
    }

    public char getDownButtonMnemonics() {
        return ListEditorPanel.getString("TARGET_EDITOR_DOWN_BUTTON_MNEMONIC").toCharArray()[0];
    }

    public String getDownButtonAD() {
        return ListEditorPanel.getString("TARGET_EDITOR_DOWN_BUTTON_AD");
    }

    public String getDefaultButtonText() {
        return ListEditorPanel.getString("TARGET_EDITOR_DEFAULT_BUTTON_LBL");
    }

    public char getDefaultButtonMnemonics() {
        return ListEditorPanel.getString("TARGET_EDITOR_DEFAULT_BUTTON_MNEMONIC").toCharArray()[0];
    }

    public String getDefaultButtonAD() {
        return ListEditorPanel.getString("TARGET_EDITOR_DEFAULT_BUTTON_AD");
    }

    public JButton getAddButton() {
        return this.addButton;
    }

    public JButton getCopyButton() {
        return this.copyButton;
    }

    public JButton getEditButton() {
        return this.renameButton;
    }

    public JButton getRemoveButton() {
        return this.removeButton;
    }

    @Override
    public void setEnabled(boolean b) {
        this.listLabel.setEnabled(b);
        this.targetList.setEnabled(b);
        this.addButton.setEnabled(b);
        this.copyButton.setEnabled(b);
        this.renameButton.setEnabled(b);
        this.removeButton.setEnabled(b);
    }

    private void initAccessibility() {
        AccessibleContext context = this.getAccessibleContext();
        context.setAccessibleName(ListEditorPanel.getString("ACSN_TARGET_EDITOR"));
        context.setAccessibleDescription(ListEditorPanel.getString("ACSD_TARGET_EDITOR"));
        context = this.targetList.getAccessibleContext();
        context.setAccessibleName(ListEditorPanel.getString("ACSN_TARGET_LIST"));
        context.setAccessibleDescription(ListEditorPanel.getString("ACSD_TARGET_LIST"));
        context = this.scrollPane.getAccessibleContext();
        context.setAccessibleName(ListEditorPanel.getString("ACSN_TARGET_LIST"));
        context.setAccessibleDescription(ListEditorPanel.getString("ACSD_TARGET_LIST"));
        context = this.scrollPane.getHorizontalScrollBar().getAccessibleContext();
        context.setAccessibleName(ListEditorPanel.getString("ACSN_TARGET_LIST"));
        context.setAccessibleDescription(ListEditorPanel.getString("ACSD_TARGET_LIST"));
        context = this.scrollPane.getVerticalScrollBar().getAccessibleContext();
        context.setAccessibleName(ListEditorPanel.getString("ACSN_TARGET_LIST"));
        context.setAccessibleDescription(ListEditorPanel.getString("ACSD_TARGET_LIST"));
    }

    private void initComponents() {
        this.dataPanel = new JPanel();
        this.listLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.controlsPanel = new JPanel();
        this.addButton = new JButton();
        this.copyButton = new JButton();
        this.renameButton = new JButton();
        this.removeButton = new JButton();
        this.setOpaque(false);
        this.setRequestFocusEnabled(false);
        this.setLayout(new GridBagLayout());
        this.dataPanel.setRequestFocusEnabled(false);
        this.dataPanel.setLayout(new GridBagLayout());
        this.listLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/dlight/toolsui/Bundle").getString("TARGET_EDITOR_LIST_MNEMONIC").charAt(0));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/dlight/toolsui/Bundle");
        this.listLabel.setText(bundle.getString("TARGET_EDITOR_LIST_LBL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.dataPanel.add((Component)this.listLabel, gridBagConstraints);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.dataPanel.add((Component)this.scrollPane, gridBagConstraints);
        this.controlsPanel.setOpaque(false);
        this.controlsPanel.setRequestFocusEnabled(false);
        this.controlsPanel.setLayout(new GridBagLayout());
        this.addButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/dlight/toolsui/Bundle").getString("TARGET_EDITOR_ADD_BUTTON_MNEMONIC").charAt(0));
        this.addButton.setText(bundle.getString("TARGET_EDITOR_ADD_BUTTON_LBL"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListEditorPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.controlsPanel.add((Component)this.addButton, gridBagConstraints);
        this.copyButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/dlight/toolsui/Bundle").getString("TARGET_EDITOR_COPY_BUTTON_MNEMONIC").charAt(0));
        this.copyButton.setText(bundle.getString("TARGET_EDITOR_COPY_BUTTON_LBL"));
        this.copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListEditorPanel.this.copyButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.controlsPanel.add((Component)this.copyButton, gridBagConstraints);
        this.renameButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/dlight/toolsui/Bundle").getString("TARGET_EDITOR_RENAME_BUTTON_MNEMONIC").charAt(0));
        this.renameButton.setText(bundle.getString("TARGET_EDITOR_RENAME_BUTTON_LBL"));
        this.renameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListEditorPanel.this.renameButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.controlsPanel.add((Component)this.renameButton, gridBagConstraints);
        this.removeButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/dlight/toolsui/Bundle").getString("TARGET_EDITOR_REMOVE_BUTTON_MNEMONIC").charAt(0));
        this.removeButton.setText(bundle.getString("TARGET_EDITOR_REMOVE_BUTTON_LBL"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListEditorPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.controlsPanel.add((Component)this.removeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.dataPanel.add((Component)this.controlsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        this.add((Component)this.dataPanel, gridBagConstraints);
    }

    public void defaultAction(E o) {
    }

    public void editAction(E o) {
    }

    private void editObjectAction() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        if (selectedIndex >= this.listData.size()) {
            return;
        }
        this.editAction(this.listData.elementAt(selectedIndex));
        this.isChanged = true;
        this.setData(this.listData);
        this.setSelectedIndex(selectedIndex);
        this.renameButton.requestFocus();
        this.checkSelection();
        this.renameButton.requestFocus();
    }

    private void renameButtonActionPerformed(ActionEvent evt) {
        this.editObjectAction();
    }

    public E copyAction(E o) {
        return null;
    }

    private void copyObjectAction() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        if (selectedIndex >= this.listData.size()) {
            return;
        }
        E newObject = this.copyAction(this.listData.elementAt(selectedIndex));
        if (newObject == null) {
            return;
        }
        this.isChanged = true;
        int addAtIndex = this.listData.size();
        this.listData.add(addAtIndex, newObject);
        this.setData(this.listData);
        this.setSelectedIndex(addAtIndex);
        this.copyButton.requestFocus();
        this.checkSelection();
        this.copyButton.requestFocus();
    }

    private void copyButtonActionPerformed(ActionEvent evt) {
        this.copyObjectAction();
    }

    public void removeAction(E o) {
    }

    private void removeObjectAction() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex < 0) {
            return;
        }
        this.removeAction(this.listData.elementAt(selectedIndex));
        this.isChanged = true;
        this.listData.removeElementAt(selectedIndex);
        this.setData(this.listData);
        int n = selectedIndex = selectedIndex >= this.listData.size() ? selectedIndex - 1 : selectedIndex;
        if (selectedIndex >= 0) {
            this.ensureIndexIsVisible(selectedIndex);
            this.checkSelection(selectedIndex);
            this.setSelectedIndex(selectedIndex);
        } else {
            this.checkSelection();
        }
        if (this.removeButton.isEnabled()) {
            this.removeButton.requestFocus();
        } else {
            this.addButton.requestFocus();
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.removeObjectAction();
    }

    public E addAction() {
        return null;
    }

    private void addObjectAction() {
        this.addObjectAction(this.addAction());
    }

    public void addObjectAction(E newObject) {
        if (newObject == null) {
            return;
        }
        ArrayList<E> listToAdd = new ArrayList<E>();
        listToAdd.add(newObject);
        this.addObjectsAction(listToAdd);
    }

    public void addObjectsAction(List<E> listToAdd) {
        if (listToAdd == null || listToAdd.size() == 0) {
            return;
        }
        this.isChanged = true;
        int addAtIndex = this.listData.size();
        Vector<E> newListData = new Vector<E>();
        newListData.addAll(this.listData);
        newListData.addAll(listToAdd);
        this.listData = newListData;
        this.setData(this.listData);
        this.setSelectedIndex(addAtIndex);
        this.ensureIndexIsVisible(addAtIndex);
        this.checkSelection();
        this.addButton.requestFocus();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.addObjectAction();
    }

    public JPanel getDataPanel() {
        return this.dataPanel;
    }

    protected void checkSelection() {
        this.checkSelection(this.getSelectedIndex());
    }

    protected void checkSelection(int i) {
        if (i >= 0 && this.listData.size() > 0) {
            this.addButton.setEnabled(true);
            this.copyButton.setEnabled(true);
            this.renameButton.setEnabled(true);
            if (this.allowedToRemoveAll) {
                this.removeButton.setEnabled(true);
            } else {
                this.removeButton.setEnabled(this.listData.size() > 1);
            }
        } else {
            this.addButton.setEnabled(true);
            this.copyButton.setEnabled(false);
            this.renameButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    public Vector<E> getListData() {
        return this.listData;
    }

    public void setListData(List<E> objects) {
        this.listData.removeAllElements();
        if (objects != null) {
            for (int i = 0; i < objects.size(); ++i) {
                this.listData.add(objects.get(i));
            }
        }
        this.setData(this.listData);
        if (this.listData.size() > 0) {
            this.setSelectedIndex(0);
        }
        this.addButton.requestFocus();
        this.checkSelection();
        this.addButton.requestFocus();
    }

    public int getSelectedIndex() {
        int index = this.targetList.getSelectedIndex();
        if (index >= 0 && index < this.listData.size()) {
            return index;
        }
        return 0;
    }

    protected void setSelectedIndex(int i) {
        this.targetList.setSelectedIndex(i);
    }

    protected void setData(Vector data) {
        this.targetList.setListData(data);
    }

    protected void ensureIndexIsVisible(int selectedIndex) {
        this.targetList.ensureIndexIsVisible(selectedIndex);
    }

    protected Component getViewComponent() {
        return this.targetList;
    }

    private static String getString(String key) {
        return NbBundle.getMessage(ListEditorPanel.class, (String)key);
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public boolean isDataValid() {
        return true;
    }

    private class TargetSelectionListener
    implements ListSelectionListener {
        private TargetSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListEditorPanel.this.checkSelection();
        }
    }
}

