/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.folding;

import java.io.PrintStream;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.spi.editor.fold.FoldOperation;

public class JspFoldUtils {
    public static void printFolds(FoldOperation fo) {
        JspFoldUtils.printFolds(fo.getHierarchy(), System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printFolds(FoldHierarchy fh, PrintStream out) {
        fh.lock();
        try {
            Fold rootFold = fh.getRootFold();
            JspFoldUtils.printChildren(rootFold, 0, out);
        }
        finally {
            fh.unlock();
        }
    }

    private static void printChildren(Fold f, int level, PrintStream out) {
        int i;
        int foldCount = f.getFoldCount();
        for (i = 0; i < level; ++i) {
            System.out.print(" ");
        }
        out.println(f.getDescription() + "[" + f.getType().toString() + "; " + f.getStartOffset() + " - " + f.getEndOffset() + "]");
        System.out.println(f.getDescription() + "[" + f.getType().toString() + "; " + f.getStartOffset() + " - " + f.getEndOffset() + "]");
        for (i = 0; i < foldCount; ++i) {
            Fold childFold = f.getFold(i);
            JspFoldUtils.printChildren(childFold, level + 4, out);
        }
    }

    public static String getContextName(int typeId) {
        switch (typeId) {
            case 4: {
                return "comment";
            }
            case 6: {
                return "content language";
            }
            case 3: {
                return "directive";
            }
            case 2: {
                return "end tag";
            }
            case 7: {
                return "scripting";
            }
            case 1: {
                return "tag";
            }
            case 5: {
                return "text";
            }
        }
        return "?";
    }
}

