/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import javax.swing.JRadioButton;

class ButtonWithExtraInfo
extends JRadioButton {
    private static final String START = "(";
    private static final String END = ")";
    private static final String SP = " ";
    private static final String ELLIPSIS = "...";
    private static final int MAX_EXTRA_INFO_LEN = 10;
    private String extraInfo;

    public ButtonWithExtraInfo(String extraInfo) {
        this.extraInfo = extraInfo;
    }

    @Override
    public void setText(String text) {
        if (this.isExtraInfoExists()) {
            this.setToolTipText(this.getFullText(text, this.extraInfo));
            super.setText(this.getTextForLabel(text));
        } else {
            super.setText(text);
        }
    }

    private boolean isExtraInfoExists() {
        return this.extraInfo != null && this.extraInfo.length() > 0;
    }

    private String getTextForLabel(String text) {
        String extraText = this.extraInfo;
        if (this.extraInfo.length() > 10 && (extraText = this.extraInfo.substring(0, 10) + ELLIPSIS).length() >= this.extraInfo.length()) {
            extraText = this.extraInfo;
        }
        return this.getFullText(text, extraText);
    }

    private String getFullText(String text, String extraText) {
        return text + SP + START + SP + extraText + SP + END;
    }
}

