/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.util;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.File;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.LayoutStyle;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiUtil;
import org.netbeans.modules.bugtracking.kenai.spi.RecentIssue;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.issue.IssueAction;
import org.netbeans.modules.bugtracking.ui.issue.IssueTopComponent;
import org.netbeans.modules.bugtracking.ui.issue.PatchContextChooser;
import org.netbeans.modules.bugtracking.ui.query.QueryAction;
import org.netbeans.modules.bugtracking.ui.query.QueryTopComponent;
import org.netbeans.modules.bugtracking.ui.search.QuickSearchComboBar;
import org.netbeans.modules.bugtracking.ui.selectors.RepositorySelector;
import org.netbeans.modules.bugtracking.util.Scrambler;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.TopComponent;

public class BugtrackingUtil {
    private static Logger METRICS_LOG = Logger.getLogger("org.netbeans.ui.metrics.bugtracking");
    public static final String USG_BUGTRACKING_AUTOMATIC_REFRESH = "USG_BUGTRACKING_AUTOMATIC_REFRESH";
    public static final String USG_BUGTRACKING_QUERY = "USG_BUGTRACKING_QUERY";
    private static final String USG_ISSUE_TRACKING = "USG_ISSUE_TRACKING";
    private static Set<String> loggedParams;
    private static Pattern netbeansUrlPattern;

    public static boolean show(JPanel panel, String title, String okName) {
        JButton ok = new JButton(okName);
        ok.getAccessibleContext().setAccessibleDescription(ok.getText());
        JButton cancel = new JButton(NbBundle.getMessage(BugtrackingUtil.class, (String)"LBL_Cancel"));
        cancel.getAccessibleContext().setAccessibleDescription(cancel.getText());
        DialogDescriptor dd = new DialogDescriptor((Object)panel, title, true, new Object[]{ok, cancel}, (Object)ok, 0, new HelpCtx(panel.getClass()), null);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == ok;
    }

    public static Issue[] getOpenIssues() {
        Set tcs = TopComponent.getRegistry().getOpened();
        ArrayList<Issue> issues = new ArrayList<Issue>();
        for (TopComponent tc : tcs) {
            Issue issue;
            if (!(tc instanceof IssueTopComponent) || (issue = ((IssueTopComponent)tc).getIssue()).isNew()) continue;
            issues.add(issue);
        }
        return issues.toArray(new Issue[issues.size()]);
    }

    public static boolean isOpened(Issue issue) {
        IssueTopComponent tc = IssueTopComponent.find(issue, false);
        return tc != null ? tc.isOpened() : false;
    }

    public static boolean isShowing(Issue issue) {
        IssueTopComponent tc = IssueTopComponent.find(issue, false);
        return tc != null ? tc.isShowing() : false;
    }

    public static boolean isOpened(Query query) {
        QueryTopComponent tc = QueryTopComponent.find(query);
        return tc != null ? tc.isOpened() : false;
    }

    public static boolean isShowing(Query query) {
        QueryTopComponent tc = QueryTopComponent.find(query);
        return tc != null ? tc.isShowing() : false;
    }

    public static Issue[] getByIdOrSummary(Issue[] issues, String criteria) {
        if (criteria == null) {
            return issues;
        }
        if ((criteria = criteria.trim()).equals("")) {
            return issues;
        }
        criteria = criteria.toLowerCase();
        ArrayList<Issue> ret = new ArrayList<Issue>();
        for (Issue issue : issues) {
            String id;
            if (issue.isNew() || (id = issue.getID()) == null) continue;
            String summary = issue.getSummary();
            if (!id.toLowerCase().startsWith(criteria) && (summary == null || summary.toLowerCase().indexOf(criteria) <= -1)) continue;
            ret.add(issue);
        }
        return ret.toArray(new Issue[ret.size()]);
    }

    public static Repository createRepository() {
        RepositorySelector rs = new RepositorySelector();
        Repository repo = rs.create();
        return repo;
    }

    public static boolean editRepository(Repository repository, String errorMessage) {
        RepositorySelector rs = new RepositorySelector();
        return rs.edit(repository, errorMessage);
    }

    public static boolean editRepository(Repository repository) {
        return BugtrackingUtil.editRepository(repository, null);
    }

    public static Repository[] getKnownRepositories(boolean pingOpenProjects) {
        return BugtrackingManager.getInstance().getKnownRepositories(pingOpenProjects);
    }

    public static BugtrackingConnector[] getBugtrackingConnectors() {
        return BugtrackingManager.getInstance().getConnectors();
    }

    public static String scramble(String str) {
        return Scrambler.getInstance().scramble(str);
    }

    public static String descramble(String str) {
        return Scrambler.getInstance().descramble(str);
    }

    public static Issue selectIssue(String message, Repository repository, JPanel caller, HelpCtx helpCtx) {
        QuickSearchComboBar bar = new QuickSearchComboBar(caller);
        bar.setRepository(repository);
        bar.setAlignmentX(0.0f);
        bar.setMaximumSize(new Dimension(Short.MAX_VALUE, bar.getPreferredSize().height));
        JPanel panel = new JPanel();
        BoxLayout layout = new BoxLayout(panel, 3);
        panel.setLayout(layout);
        JLabel label = new JLabel();
        Mnemonics.setLocalizedText((JLabel)label, (String)message);
        panel.add(label);
        label.setLabelFor(bar.getIssueComponent());
        LayoutStyle layoutStyle = LayoutStyle.getSharedInstance();
        int gap = layoutStyle.getPreferredGap((JComponent)label, (JComponent)bar, 0, 5, (Container)panel);
        panel.add(Box.createVerticalStrut(gap));
        panel.add(bar);
        panel.add(Box.createVerticalStrut(gap));
        ResourceBundle bundle = NbBundle.getBundle(BugtrackingUtil.class);
        JLabel hintLabel = new JLabel(bundle.getString("MSG_SelectIssueHint"));
        hintLabel.setEnabled(false);
        panel.add(hintLabel);
        panel.add(Box.createVerticalStrut(80));
        panel.setBorder(BorderFactory.createEmptyBorder(layoutStyle.getContainerGap((JComponent)panel, 1, null), layoutStyle.getContainerGap((JComponent)panel, 7, null), 0, layoutStyle.getContainerGap((JComponent)panel, 3, null)));
        panel.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_IssueSelector"));
        Issue issue = null;
        JButton ok = new JButton(bundle.getString("LBL_Select"));
        ok.getAccessibleContext().setAccessibleDescription(ok.getText());
        JButton cancel = new JButton(bundle.getString("LBL_Cancel"));
        cancel.getAccessibleContext().setAccessibleDescription(cancel.getText());
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, bundle.getString("LBL_Issues"), true, 2, (Object)ok, null);
        descriptor.setOptions(new Object[]{ok, cancel});
        descriptor.setHelpCtx(helpCtx);
        DialogDisplayer.getDefault().createDialog(descriptor).setVisible(true);
        if (descriptor.getValue() == ok) {
            issue = bar.getIssue();
        }
        return issue;
    }

    public static File selectPatchContext() {
        PatchContextChooser chooser = new PatchContextChooser();
        ResourceBundle bundle = NbBundle.getBundle(BugtrackingUtil.class);
        JButton ok = new JButton(bundle.getString("LBL_Apply"));
        JButton cancel = new JButton(bundle.getString("LBL_Cancel"));
        DialogDescriptor descriptor = new DialogDescriptor((Object)chooser, bundle.getString("LBL_ApplyPatch"), true, 2, (Object)ok, null);
        descriptor.setOptions(new Object[]{ok, cancel});
        descriptor.setHelpCtx(new HelpCtx("org.netbeans.modules.bugtracking.patchContextChooser"));
        File context = null;
        DialogDisplayer.getDefault().createDialog(descriptor).setVisible(true);
        if (descriptor.getValue() == ok) {
            context = chooser.getSelectedFile();
        }
        return context;
    }

    public static void deleteRecursively(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                BugtrackingUtil.deleteRecursively(files[i]);
            }
        }
        file.delete();
    }

    public static void logQueryEvent(String connector, String name, int count, boolean isKenai, boolean isAutoRefresh) {
        name = BugtrackingUtil.obfuscateQueryName(name);
        BugtrackingUtil.logBugtrackingEvents(USG_BUGTRACKING_QUERY, new Object[]{connector, name, count, isKenai, isAutoRefresh});
    }

    public static void logAutoRefreshEvent(String connector, String queryName, boolean isKenai, boolean on) {
        queryName = BugtrackingUtil.obfuscateQueryName(queryName);
        BugtrackingUtil.logBugtrackingEvents(USG_BUGTRACKING_AUTOMATIC_REFRESH, new Object[]{connector, queryName, isKenai, on});
    }

    public static synchronized void logBugtrackingUsage(Repository repository, String operation) {
        if (repository == null) {
            return;
        }
        String btType = BugtrackingUtil.getBugtrackingType(repository);
        if (btType == null) {
            return;
        }
        if (KenaiUtil.isKenai(repository)) {
            KenaiUtil.logKenaiUsage("ISSUE_TRACKING", btType);
        }
        if (operation == null) {
            return;
        }
        String paramStr = BugtrackingUtil.getParamString(btType, operation);
        if (loggedParams == null || !loggedParams.contains(paramStr)) {
            LogRecord rec = new LogRecord(Level.INFO, USG_ISSUE_TRACKING);
            rec.setParameters(new Object[]{btType, operation});
            rec.setLoggerName(METRICS_LOG.getName());
            METRICS_LOG.log(rec);
            if (loggedParams == null) {
                loggedParams = new HashSet<String>();
            }
            loggedParams.add(paramStr);
        }
    }

    private static String getParamString(Object ... parameters) {
        if (parameters == null || parameters.length == 0) {
            return "";
        }
        if (parameters.length == 1) {
            return parameters[0].toString();
        }
        StringBuilder buf = new StringBuilder();
        for (Object p : parameters) {
            buf.append(p.toString());
        }
        return buf.toString();
    }

    private static String getBugtrackingType(Repository repository) {
        String clsName = repository.getClass().getName();
        if (clsName.contains(".bugzilla.")) {
            return "Bugzilla";
        }
        if (clsName.contains(".jira.")) {
            return "Jira";
        }
        return null;
    }

    private static void logBugtrackingEvents(String key, Object[] parameters) {
        LogRecord rec = new LogRecord(Level.INFO, key);
        rec.setParameters(parameters);
        rec.setLoggerName(METRICS_LOG.getName());
        METRICS_LOG.log(rec);
    }

    private static String getMD5(String name) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        digest.update(name.getBytes());
        byte[] hash = digest.digest();
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(hash[i] & 0xFF);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            ret.append(hex);
        }
        return ret.toString();
    }

    private static String obfuscateQueryName(String name) {
        name = name == null ? "Find Issues" : BugtrackingUtil.getMD5(name);
        return name;
    }

    public static void openPluginManager() {
        try {
            ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            Class<?> clz = cl.loadClass("org.netbeans.modules.autoupdate.ui.actions.PluginManagerAction");
            final CallableSystemAction a = (CallableSystemAction)CallableSystemAction.findObject(clz, (boolean)true);
            a.putValue("InitialTab", (Object)"available");
            Runnable inAWT = new Runnable(){

                @Override
                public void run() {
                    a.performAction();
                }
            };
            if (EventQueue.isDispatchThread()) {
                inAWT.run();
            } else {
                EventQueue.invokeLater(inAWT);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static boolean isNbRepository(Repository repo) {
        String url = repo.getUrl();
        return BugtrackingUtil.isNbRepository(url);
    }

    public static boolean isNbRepository(String url) {
        boolean ret = netbeansUrlPattern.matcher(url).matches();
        if (ret) {
            return true;
        }
        String nbUrl = System.getProperty("netbeans.bugzilla.url");
        if (nbUrl == null || nbUrl.equals("")) {
            return false;
        }
        return url.startsWith(nbUrl);
    }

    public static void savePassword(String password, String prefix, String user, String url) throws MissingResourceException {
        if (password != null && !password.trim().equals("")) {
            Keyring.save((String)BugtrackingUtil.getPasswordKey(prefix, user, url), (char[])password.toCharArray(), (String)NbBundle.getMessage(BugtrackingUtil.class, (String)"password_keyring_description", (Object)url));
        } else {
            Keyring.delete((String)BugtrackingUtil.getPasswordKey(prefix, user, url));
        }
    }

    public static char[] readPassword(String scrambledPassword, String keyPrefix, String user, String url) {
        if (!scrambledPassword.equals("")) {
            return BugtrackingUtil.descramble(scrambledPassword).toCharArray();
        }
        char[] password = Keyring.read((String)BugtrackingUtil.getPasswordKey(keyPrefix, user, url));
        return password != null ? password : new char[]{};
    }

    private static String getPasswordKey(String prefix, String user, String url) {
        return (prefix != null ? prefix + "-" : "") + user + "@" + url;
    }

    public static boolean isJiraInstalled() {
        BugtrackingConnector[] connectors;
        for (BugtrackingConnector c : connectors = BugtrackingManager.getInstance().getConnectors()) {
            if (!c.getClass().getName().startsWith("org.netbeans.modules.jira")) continue;
            return true;
        }
        return false;
    }

    public static void openQuery(Query query, Repository repository, boolean suggestedSelectionOnly) {
        QueryAction.openQuery(query, repository, suggestedSelectionOnly);
    }

    public static void openIssue(File file, String issueId) {
        IssueAction.openIssue(file, issueId);
    }

    public static Map<String, List<RecentIssue>> getAllRecentIssues() {
        return BugtrackingManager.getInstance().getAllRecentIssues();
    }

    public static Collection<Issue> getRecentIssues(Repository repo) {
        return BugtrackingManager.getInstance().getRecentIssues(repo);
    }

    public static void closeQuery(Query query) {
        QueryAction.closeQuery(query);
    }

    public static void createIssue(Repository repo) {
        IssueAction.createIssue(repo);
    }

    public static String getPasswordLog(String psswd) {
        if (psswd == null) {
            return "";
        }
        if ("true".equals(System.getProperty("org.netbeans.modules.bugtracking.logPasswords", "false"))) {
            return psswd;
        }
        return "******";
    }

    static {
        netbeansUrlPattern = Pattern.compile("(https|http)://(([a-z]|\\d)+\\.)*([a-z]|\\d)*netbeans([a-z]|\\d)*(([a-z]|\\d)*\\.)+org(.*)");
    }
}

