/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.io.File;
import java.util.Properties;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.spi.AntSession;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class JUnitExecutionManager
implements RerunHandler {
    private File scriptFile = null;
    private String[] targets = null;
    private Properties properties;
    private TestSession testSession;
    private Lookup lookup = Lookup.EMPTY;

    public JUnitExecutionManager(AntSession session, TestSession testSession, Properties props) {
        this.testSession = testSession;
        this.properties = props;
        try {
            this.scriptFile = session.getOriginatingScript();
            this.targets = session.getOriginatingTargets();
            for (int i = 0; i < this.targets.length; ++i) {
                if (this.targets[i].equals("test-single")) {
                    this.targets[i] = "test.single";
                    continue;
                }
                if (!this.targets[i].equals("debug-test")) continue;
                this.targets[i] = "debug.test.single";
            }
            String javacIncludes = this.properties.getProperty("javac.includes");
            if (javacIncludes != null) {
                FileObject testFO = testSession.getFileLocator().find(javacIncludes);
                this.lookup = Lookups.fixed((Object[])new Object[]{DataObject.find((FileObject)testFO)});
            }
            if (this.targets.length == 0) {
                String className = this.properties.getProperty("classname");
                String methodName = this.properties.getProperty("methodname");
                if (className != null) {
                    FileObject testFO = testSession.getFileLocator().find(className.replace('.', '/') + ".java");
                    if (methodName != null) {
                        SingleMethod methodSpec = new SingleMethod(testFO, methodName);
                        this.lookup = Lookups.singleton((Object)methodSpec);
                    } else {
                        this.lookup = Lookups.fixed((Object[])new Object[]{DataObject.find((FileObject)testFO)});
                    }
                }
                if (this.scriptFile.getName().equals("junit.xml")) {
                    this.targets = methodName != null ? new String[]{"run.single.method"} : new String[]{"test.single"};
                } else if (this.scriptFile.getName().equals("junit-debug.xml")) {
                    this.targets = methodName != null ? new String[]{"debug.single.method"} : new String[]{"debug.test.single"};
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void rerun() {
        Project project = this.testSession.getProject();
        ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        actionProvider.invokeAction(this.targets[0], this.lookup);
    }

    public boolean enabled() {
        if (this.scriptFile == null || this.targets == null || this.targets.length == 0) {
            return false;
        }
        Project project = this.testSession.getProject();
        ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (actionProvider != null) {
            boolean runSupported = false;
            for (String action : actionProvider.getSupportedActions()) {
                if (!action.equals(this.targets[0])) continue;
                runSupported = true;
                break;
            }
            if (runSupported && actionProvider.isActionEnabled(this.targets[0], this.lookup)) {
                return true;
            }
        }
        return false;
    }

    public void addChangeListener(ChangeListener listener) {
    }

    public void removeChangeListener(ChangeListener listener) {
    }
}

