/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cplusplus;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.Filter;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.editor.cplusplus.BracketCompletion;
import org.netbeans.modules.cnd.editor.cplusplus.DeleteToNextCamelCasePosition;
import org.netbeans.modules.cnd.editor.cplusplus.DeleteToPreviousCamelCasePosition;
import org.netbeans.modules.cnd.editor.cplusplus.InsertSemicolonAction;
import org.netbeans.modules.cnd.editor.cplusplus.NextCamelCasePosition;
import org.netbeans.modules.cnd.editor.cplusplus.PreviousCamelCasePosition;
import org.netbeans.modules.cnd.editor.cplusplus.SelectNextCamelCasePosition;
import org.netbeans.modules.cnd.editor.cplusplus.SelectPreviousCamelCasePosition;
import org.netbeans.modules.cnd.editor.indent.HotCharIndent;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.openide.util.Exceptions;

public class CCKit
extends NbEditorKit {
    static final String previousCamelCasePosition = "previous-camel-case-position";
    static final String nextCamelCasePosition = "next-camel-case-position";
    static final String selectPreviousCamelCasePosition = "select-previous-camel-case-position";
    static final String selectNextCamelCasePosition = "select-next-camel-case-position";
    static final String deletePreviousCamelCasePosition = "delete-previous-camel-case-position";
    static final String deleteNextCamelCasePosition = "delete-next-camel-case-position";
    private InputAttributes lexerAttrs = null;

    public String getContentType() {
        return "text/x-c++";
    }

    public Document createDefaultDocument() {
        Document doc = super.createDefaultDocument();
        return doc;
    }

    protected void initDocument(BaseDocument doc) {
        super.initDocument(doc);
        doc.putProperty(InputAttributes.class, (Object)this.getLexerAttributes());
        doc.putProperty(Language.class, this.getLanguage());
    }

    protected Language<CppTokenId> getLanguage() {
        return CppTokenId.languageCpp();
    }

    protected final synchronized InputAttributes getLexerAttributes() {
        if (this.lexerAttrs == null) {
            this.lexerAttrs = new InputAttributes();
            this.lexerAttrs.setValue(this.getLanguage(), (Object)"lexer-filter", this.getFilter(), true);
        }
        return this.lexerAttrs;
    }

    protected Filter<CppTokenId> getFilter() {
        return CndLexerUtilities.getGccCppFilter();
    }

    protected Action getCommentAction() {
        return new ExtKit.CommentAction("//");
    }

    protected Action getUncommentAction() {
        return new ExtKit.UncommentAction("//");
    }

    protected Action getToggleCommentAction() {
        return new ExtKit.ToggleCommentAction("//");
    }

    protected Action[] createActions() {
        Action[] superActions = super.createActions();
        Action[] ccActions = new Action[]{new CCDefaultKeyTypedAction(), new CCFormatAction(), new CCInsertBreakAction(), new CCDeleteCharAction("delete-previous", false), this.getToggleCommentAction(), this.getCommentAction(), this.getUncommentAction(), new NextCamelCasePosition(CCKit.findAction(superActions, "caret-next-word")), new PreviousCamelCasePosition(CCKit.findAction(superActions, "caret-previous-word")), new SelectNextCamelCasePosition(CCKit.findAction(superActions, "selection-next-word")), new SelectPreviousCamelCasePosition(CCKit.findAction(superActions, "selection-previous-word")), new DeleteToNextCamelCasePosition(CCKit.findAction(superActions, "remove-word-next")), new DeleteToPreviousCamelCasePosition(CCKit.findAction(superActions, "remove-word-previous")), new InsertSemicolonAction(true), new InsertSemicolonAction(false)};
        ccActions = TextAction.augmentList(superActions, ccActions);
        return ccActions;
    }

    private static Action findAction(Action[] actions, String name) {
        for (Action a : actions) {
            Object nameObj = a.getValue("Name");
            if (!(nameObj instanceof String) || !name.equals(nameObj)) continue;
            return a;
        }
        return null;
    }

    protected void updateActions() {
        super.updateActions();
        this.addSystemActionMapping("format", CCFormatAction.class);
    }

    public static class CCDeleteCharAction
    extends ExtKit.ExtDeleteCharAction {
        public CCDeleteCharAction(String nm, boolean nextChar) {
            super(nm, nextChar);
        }

        protected void charBackspaced(BaseDocument doc, int dotPos, Caret caret, char ch) throws BadLocationException {
            BracketCompletion.charBackspaced(doc, dotPos, caret, ch);
        }
    }

    public static class CCInsertBreakAction
    extends BaseKit.InsertBreakAction {
        static final long serialVersionUID = -1506173310438326380L;
        static final boolean DEBUG = false;

        protected Object beforeBreak(JTextComponent target, BaseDocument doc, Caret caret) {
            int dotPos = caret.getDot();
            if (BracketCompletion.posWithinString(doc, dotPos)) {
                try {
                    if (dotPos >= 1 && DocumentUtilities.getText((Document)doc).charAt(dotPos - 1) != '\\' || dotPos >= 2 && DocumentUtilities.getText((Document)doc).charAt(dotPos - 2) == '\\') {
                        doc.insertString(dotPos, "\"\"", null);
                        caret.setDot(++dotPos);
                        return dotPos;
                    }
                }
                catch (BadLocationException ex) {}
            } else {
                try {
                    if (BracketCompletion.isAddRightBrace(doc, dotPos)) {
                        int end = BracketCompletion.getRowOrBlockEnd(doc, dotPos);
                        String insString = "}";
                        TokenItem firstNonWhiteBwd = CndTokenUtilities.getFirstNonWhiteBwd((Document)doc, (int)end);
                        if (firstNonWhiteBwd == null || firstNonWhiteBwd.id() != CppTokenId.LBRACE) {
                            return Boolean.FALSE;
                        }
                        int lBracePos = firstNonWhiteBwd.offset();
                        int lastSepOffset = CndTokenUtilities.getLastCommandSeparator((Document)doc, (int)(lBracePos - 1));
                        if (lastSepOffset == -1 && lBracePos > 0) {
                            lastSepOffset = 0;
                        }
                        if (lastSepOffset != -1 && lastSepOffset < dotPos) {
                            TokenSequence cppTokenSequence = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)lBracePos, (boolean)false, (boolean)false);
                            block8: while (cppTokenSequence.movePrevious() && cppTokenSequence.offset() >= lastSepOffset) {
                                switch ((CppTokenId)cppTokenSequence.token().id()) {
                                    case RPAREN: 
                                    case RBRACKET: {
                                        break block8;
                                    }
                                    case CLASS: 
                                    case UNION: 
                                    case STRUCT: 
                                    case ENUM: {
                                        insString = "};";
                                        break block8;
                                    }
                                    default: {
                                        continue block8;
                                    }
                                }
                            }
                        }
                        doc.insertString(end, "\n" + insString, null);
                        Indent indent = Indent.get((Document)doc);
                        indent.reindent(end + 1);
                        caret.setDot(dotPos);
                        return Boolean.TRUE;
                    }
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
            }
            return null;
        }

        protected void afterBreak(JTextComponent target, BaseDocument doc, Caret caret, Object cookie) {
            if (cookie != null && cookie instanceof Integer) {
                int nowDotPos = caret.getDot();
                caret.setDot(nowDotPos + 1);
            }
        }
    }

    public static class CCDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkIndentHotChars(JTextComponent target, String typedText) {
            int offset;
            BaseDocument doc = Utilities.getDocument((JTextComponent)target);
            if (HotCharIndent.INSTANCE.getKeywordBasedReformatBlock(doc, offset = target.getCaretPosition(), typedText)) {
                Indent indent = Indent.get((Document)doc);
                indent.lock();
                try {
                    doc.putProperty((Object)"abbrev-ignore-modification", (Object)Boolean.TRUE);
                    indent.reindent(offset);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    doc.putProperty((Object)"abbrev-ignore-modification", (Object)Boolean.FALSE);
                    indent.unlock();
                }
            }
        }

        protected void insertString(BaseDocument doc, int dotPos, Caret caret, String str, boolean overwrite) throws BadLocationException {
            TokenItem tokenAtDot;
            boolean blockCommentStart = false;
            if (dotPos > 0 && str.charAt(0) == '*' && (tokenAtDot = CndTokenUtilities.getToken((Document)doc, (int)(dotPos - 1), (boolean)true)).id() == CppTokenId.SLASH) {
                blockCommentStart = true;
            }
            super.insertString(doc, dotPos, caret, str, overwrite);
            BracketCompletion.charInserted(doc, dotPos, caret, str.charAt(0), blockCommentStart);
        }
    }

    public class CCFormatAction
    extends BaseAction {
        public CCFormatAction() {
            super("format", 10);
            this.putValue("helpID", CCFormatAction.class.getName());
        }

        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                final BaseDocument doc = (BaseDocument)target.getDocument();
                Cursor origCursor = target.getCursor();
                target.setCursor(Cursor.getPredefinedCursor(3));
                doc.runAtomicAsUser(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Position endPosition;
                            int startPos;
                            Caret caret = target.getCaret();
                            int caretLine = Utilities.getLineOffset((BaseDocument)doc, (int)caret.getDot());
                            if (Utilities.isSelectionShowing((Caret)caret)) {
                                startPos = target.getSelectionStart();
                                endPosition = doc.createPosition(target.getSelectionEnd());
                            } else {
                                startPos = 0;
                                endPosition = doc.createPosition(doc.getLength());
                            }
                            int pos = startPos;
                            Reformat reformat = Reformat.get((Document)doc);
                            reformat.lock();
                            try {
                                reformat.reformat(pos, endPosition.getOffset());
                            }
                            finally {
                                reformat.unlock();
                            }
                            pos = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)caretLine);
                            if (pos >= 0) {
                                caret.setDot(pos);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
                target.setCursor(origCursor);
            }
        }
    }
}

