/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.ListCellRenderer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.rubyproject.GemRequirement;
import org.netbeans.modules.ruby.rubyproject.JavaClassPathUi;
import org.netbeans.modules.ruby.rubyproject.ProjectPropertyExtender;
import org.netbeans.modules.ruby.rubyproject.RequiredGems;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.GeneratedFilesHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;
import org.netbeans.modules.ruby.spi.project.support.rake.ui.StoreGroup;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.EditableProperties;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public abstract class SharedRubyProjectProperties {
    private static final Logger LOGGER = Logger.getLogger(SharedRubyProjectProperties.class.getName());
    public static final String MAIN_CLASS = "main.file";
    public static final String RUBY_OPTIONS = "ruby.options";
    public static final String DIST_DIR = "dist.dir";
    public static final String BUILD_DIR = "build.dir";
    public static final String PLATFORM_ACTIVE = "platform.active";
    public static final String JAVAC_CLASSPATH = "javac.classpath";
    public static final String RAKE_ARGS = "rake.args";
    public static final String JVM_ARGS = "jvm.args";
    public static final String SOURCE_ENCODING = "source.encoding";
    public static final String APPLICATION_ARGS = "application.args";
    public static final String RAILS_ENV = "rails.env";
    public static final String RUBY_OPTIONS_DEPRECATED = "run.jvmargs";
    public static final String SPEC_TASKS = "spec.tasks";
    public static final String TEST_TASKS = "test.tasks";
    public DefaultListModel JAVAC_CLASSPATH_MODEL;
    public ListCellRenderer CLASS_PATH_LIST_RENDERER;
    private final RubyBaseProject project;
    private RubyPlatform platform;
    protected final PropertyEvaluator evaluator;
    private final UpdateHelper updateHelper;
    private final GeneratedFilesHelper genFileHelper;
    private final ProjectPropertyExtender cs;
    private final StoreGroup privateGroup;
    private final StoreGroup projectGroup;
    private final Map<String, String> additionalProperties;
    private String activeConfig;
    private Map<String, Map<String, String>> runConfigs;
    private List<GemRequirement> gemRequirements;
    private List<GemRequirement> gemRequirementsTests;
    public static final String[] WELL_KNOWN_PATHS = new String[]{"${javac.classpath}"};
    public static final String LIBRARY_PREFIX = "${libs.";
    public static final String LIBRARY_SUFFIX = ".classpath}";
    public static final String ANT_ARTIFACT_PREFIX = "${reference.";

    public SharedRubyProjectProperties(RubyBaseProject project, PropertyEvaluator evaluator, UpdateHelper updateHelper, GeneratedFilesHelper genFileHelper, ReferenceHelper refHelper) {
        this.project = project;
        this.updateHelper = updateHelper;
        this.genFileHelper = genFileHelper;
        this.evaluator = evaluator;
        this.cs = new ProjectPropertyExtender(evaluator, refHelper, updateHelper.getRakeProjectHelper(), WELL_KNOWN_PATHS, LIBRARY_PREFIX, LIBRARY_SUFFIX, ANT_ARTIFACT_PREFIX);
        this.additionalProperties = new HashMap<String, String>();
        this.privateGroup = new StoreGroup();
        this.projectGroup = new StoreGroup();
        this.init();
    }

    protected abstract String[] getConfigProperties();

    protected abstract String[] getConfigPrivateProperties();

    protected abstract void prePropertiesStore() throws IOException;

    protected abstract void storeProperties(EditableProperties var1, EditableProperties var2) throws IOException;

    private void init() {
        this.CLASS_PATH_LIST_RENDERER = new JavaClassPathUi.ClassPathListCellRenderer(this.evaluator);
        EditableProperties projectProperties = this.getUpdateHelper().getProperties("nbproject/project.properties");
        String cp = projectProperties.get((Object)JAVAC_CLASSPATH);
        this.JAVAC_CLASSPATH_MODEL = SharedRubyProjectProperties.createListModel(this.cs.itemsIterator(cp));
        this.runConfigs = this.readRunConfigs();
        this.activeConfig = this.evaluator.getProperty("config");
    }

    protected UpdateHelper getUpdateHelper() {
        return this.updateHelper;
    }

    protected RubyBaseProject getProject() {
        return this.project;
    }

    public RubyPlatform getPlatform() {
        return this.getProject().getPlatform();
    }

    public static String getRubyOptions(RubyBaseProject project) {
        String options = project.evaluator().getProperty(RUBY_OPTIONS);
        if (SharedRubyProjectProperties.isEmpty(options)) {
            options = null;
        }
        if (options == null && SharedRubyProjectProperties.isEmpty(options = project.evaluator().getProperty(RUBY_OPTIONS_DEPRECATED))) {
            options = null;
        }
        return options;
    }

    public void setPlatform(RubyPlatform platform) {
        this.platform = platform;
    }

    public static void storePlatform(EditableProperties ep, RubyPlatform platform) {
        if (platform == null) {
            LOGGER.fine("Project has invalid platform (null).");
            return;
        }
        ep.setProperty(PLATFORM_ACTIVE, platform.getID());
    }

    public String getActiveConfig() {
        return this.activeConfig;
    }

    public void setActiveConfig(String activeConfig) {
        this.activeConfig = activeConfig;
    }

    public List<GemRequirement> getGemRequirements() {
        return this.gemRequirements;
    }

    public void setGemRequirements(List<GemRequirement> gemRequirements) {
        this.gemRequirements = gemRequirements;
    }

    public List<GemRequirement> getGemRequirementsForTests() {
        return this.gemRequirementsTests;
    }

    public void setGemRequirementsForTests(List<GemRequirement> gemRequirements) {
        this.gemRequirementsTests = gemRequirements;
    }

    public Map<String, Map<String, String>> getRunConfigs() {
        return this.runConfigs;
    }

    private boolean isPrivateConfigProperty(String prop) {
        return Arrays.asList(this.getConfigPrivateProperties()).contains(prop);
    }

    protected Map<String, Map<String, String>> readRunConfigs() {
        TreeMap<String, Map<String, String>> m = new TreeMap<String, Map<String, String>>(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1 != null ? (s2 != null ? s1.compareTo(s2) : 1) : (s2 != null ? -1 : 0);
            }
        });
        TreeMap<String, String> def = new TreeMap<String, String>();
        for (String prop : this.getConfigProperties()) {
            String v = this.getUpdateHelper().getProperties("nbproject/private/private.properties").getProperty(prop);
            if (v == null) {
                v = this.getUpdateHelper().getProperties("nbproject/project.properties").getProperty(prop);
            }
            if (v == null) continue;
            def.put(prop, v);
        }
        m.put(null, def);
        FileObject configs = this.project.getProjectDirectory().getFileObject("nbproject/configs");
        if (configs != null) {
            for (FileObject kid : configs.getChildren()) {
                if (!kid.hasExt("properties")) continue;
                m.put(kid.getName(), new TreeMap(this.getUpdateHelper().getProperties(FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)kid))));
            }
        }
        if ((configs = this.project.getProjectDirectory().getFileObject("nbproject/private/configs")) != null) {
            for (FileObject kid : configs.getChildren()) {
                Map c;
                if (!kid.hasExt("properties") || (c = (Map)m.get(kid.getName())) == null) continue;
                c.putAll(new HashMap(this.getUpdateHelper().getProperties(FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)kid))));
            }
        }
        return m;
    }

    protected void storeRunConfigs(Map<String, Map<String, String>> configs, EditableProperties projectProperties, EditableProperties privateProperties) throws IOException {
        Map<String, String> defaultConf = configs.get(null);
        for (String confProp : this.getConfigProperties()) {
            EditableProperties ep;
            String defConfValue = defaultConf.get(confProp);
            EditableProperties editableProperties = ep = this.isPrivateConfigProperty(confProp) ? privateProperties : projectProperties;
            if (Utilities.compareObjects((Object)defConfValue, (Object)ep.getProperty(confProp))) continue;
            if (defConfValue != null && defConfValue.length() > 0) {
                ep.setProperty(confProp, defConfValue);
                continue;
            }
            ep.remove((Object)confProp);
        }
        for (Map.Entry<String, Map<String, String>> entry : configs.entrySet()) {
            String config = entry.getKey();
            if (config == null) continue;
            String sharedPath = "nbproject/configs/" + config + ".properties";
            String privatePath = "nbproject/private/configs/" + config + ".properties";
            Map<String, String> c = entry.getValue();
            if (c == null) {
                this.updateHelper.putProperties(sharedPath, null);
                this.updateHelper.putProperties(privatePath, null);
                continue;
            }
            for (Map.Entry<String, String> entry2 : c.entrySet()) {
                String path;
                EditableProperties ep;
                String prop = entry2.getKey();
                String v = entry2.getValue();
                if (Utilities.compareObjects((Object)v, (Object)(ep = this.updateHelper.getProperties(path = this.isPrivateConfigProperty(prop) ? privatePath : sharedPath)).getProperty(prop))) continue;
                if (v != null && (v.length() > 0 || defaultConf.get(prop) != null && defaultConf.get(prop).length() > 0)) {
                    ep.setProperty(prop, v);
                } else {
                    ep.remove((Object)prop);
                }
                this.updateHelper.putProperties(path, ep);
            }
            this.updateHelper.putProperties(sharedPath, this.updateHelper.getProperties(sharedPath));
        }
    }

    public void putAdditionalProperty(String propertyName, String propertyValue) {
        this.additionalProperties.put(propertyName, propertyValue);
    }

    protected static boolean showModifiedMessage(String title) {
        String message = NbBundle.getMessage(SharedRubyProjectProperties.class, (String)"TXT_Regenerate");
        JButton regenerateButton = new JButton(NbBundle.getMessage(SharedRubyProjectProperties.class, (String)"CTL_RegenerateButton"));
        regenerateButton.setDefaultCapable(true);
        regenerateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SharedRubyProjectProperties.class, (String)"AD_RegenerateButton"));
        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)message, 2);
        d.setTitle(title);
        d.setOptionType(2);
        d.setOptions(new Object[]{regenerateButton, NotifyDescriptor.CANCEL_OPTION});
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == regenerateButton;
    }

    private void storeCommonProperties() throws IOException {
        String[] javac_cp = this.cs.encodeToStrings(SharedRubyProjectProperties.getIterator(this.JAVAC_CLASSPATH_MODEL));
        this.prePropertiesStore();
        EditableProperties projectProperties = this.getUpdateHelper().getProperties("nbproject/project.properties");
        EditableProperties privateProperties = this.getUpdateHelper().getProperties("nbproject/private/private.properties");
        this.storeProperties(projectProperties, privateProperties);
        SharedRubyProjectProperties.storePlatform(privateProperties, this.getPlatform());
        this.projectGroup.store(projectProperties);
        this.privateGroup.store(privateProperties);
        this.storeRunConfigs(this.runConfigs, projectProperties, privateProperties);
        EditableProperties configProperties = this.getUpdateHelper().getProperties("nbproject/private/config.properties");
        if (this.activeConfig == null) {
            configProperties.remove((Object)"config");
        } else {
            configProperties.setProperty("config", this.activeConfig);
        }
        this.getUpdateHelper().putProperties("nbproject/private/config.properties", configProperties);
        this.putGemRequirements(projectProperties);
        projectProperties.setProperty(JAVAC_CLASSPATH, javac_cp);
        projectProperties.putAll(this.additionalProperties);
        this.getUpdateHelper().putProperties("nbproject/project.properties", projectProperties);
        this.getUpdateHelper().putProperties("nbproject/private/private.properties", privateProperties);
        String encoding = this.additionalProperties.get(SOURCE_ENCODING);
        if (encoding != null) {
            try {
                FileEncodingQuery.setDefaultEncoding((Charset)Charset.forName(encoding));
            }
            catch (UnsupportedCharsetException e) {
                // empty catch block
            }
        }
    }

    private void putGemRequirements(EditableProperties projectProperties) {
        if (this.gemRequirements == null) {
            projectProperties.remove((Object)"required.gems");
        } else {
            projectProperties.put("required.gems", RequiredGems.asString(this.gemRequirements));
        }
        if (this.gemRequirementsTests == null) {
            projectProperties.remove((Object)"required.gems.tests");
        } else {
            projectProperties.put("required.gems.tests", RequiredGems.asString(this.gemRequirementsTests));
        }
    }

    public void save() {
        try {
            Boolean result = (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){
                final FileObject projectDir;
                {
                    this.projectDir = SharedRubyProjectProperties.this.getUpdateHelper().getRakeProjectHelper().getProjectDirectory();
                }

                public Boolean run() throws IOException {
                    if ((SharedRubyProjectProperties.this.genFileHelper.getBuildScriptState("nbproject/build-impl.xml", SharedRubyProjectProperties.this.project.getClass().getResource("resources/build-impl.xsl")) & 4) == 4) {
                        if (SharedRubyProjectProperties.showModifiedMessage(NbBundle.getMessage(SharedRubyProjectProperties.class, (String)"TXT_ModifiedTitle"))) {
                            FileObject fo = this.projectDir.getFileObject("nbproject/build-impl.xml");
                            if (fo != null) {
                                fo.delete();
                            }
                        } else {
                            return false;
                        }
                    }
                    SharedRubyProjectProperties.this.storeCommonProperties();
                    return true;
                }
            });
            if (result == Boolean.TRUE) {
                ProjectManager.getDefault().saveProject((Project)this.getProject());
            }
        }
        catch (MutexException e) {
            ErrorManager.getDefault().notify((Throwable)((IOException)e.getException()));
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private static DefaultListModel createListModel(Iterator it) {
        DefaultListModel model = new DefaultListModel();
        while (it.hasNext()) {
            model.addElement(it.next());
        }
        return model;
    }

    private static Iterator<ProjectPropertyExtender.Item> getIterator(DefaultListModel model) {
        return SharedRubyProjectProperties.getList(model).iterator();
    }

    private static List<ProjectPropertyExtender.Item> getList(DefaultListModel model) {
        ArrayList<ProjectPropertyExtender.Item> items = Collections.list(model.elements());
        return items;
    }

    private static boolean isEmpty(String options) {
        return options != null && options.trim().length() == 0;
    }
}

