/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.nbtasks;

import com.sun.javacard.nbtasks.JCPackagerTask;
import com.sun.javacard.nbtasks.JCTask;
import com.sun.javacard.nbtasks.JCToolTask;
import java.io.File;
import org.apache.tools.ant.BuildException;

public class ProxyTask
extends JCTask {
    public void execute() throws BuildException {
        if (!this.isClassicApplication() && !this.isClassicLibrary()) {
            return;
        }
        ProxyGenTask task = null;
        if (this.isClassicApplication() || this.isClassicLibrary()) {
            task = new ProxyGenTask(this.isClassicApplication());
            task.setProject(this.getProject());
            ((JCToolTask)task).execute();
        }
    }

    private static class ProxyGenTask
    extends JCPackagerTask {
        private final boolean classicApp;

        ProxyGenTask(boolean classicApp) {
            this.classicApp = classicApp;
        }

        protected void setAdditionalArguments() throws BuildException {
            if (this.classicApp) {
                this.setAdditionalArgumentsClassicApp();
            } else {
                this.setAdditionalArgumentsClassicLib();
            }
        }

        protected void setAdditionalArgumentsClassicApp() throws BuildException {
            this.createArg().setValue("--keepproxysource");
            File proxyDir = this.getProxyGenerationDir();
            this.log("Generating proxies to " + proxyDir.getAbsolutePath());
            this.createArg().setFile(proxyDir);
        }

        protected void setAdditionalArgumentsClassicLib() throws BuildException {
            this.createArg().setValue("--keepproxysource");
            this.createArg().setFile(this.getProxyGenerationDir());
        }

        private File getProxyGenerationDir() {
            File proxyDir = null;
            if (proxyDir == null) {
                proxyDir = this.getFileProp("proxy.generation.dir", false);
            }
            if (proxyDir == null) {
                proxyDir = new File(this.getProject().getBaseDir(), "dist" + File.separatorChar + "generated_proxies_src");
                this.log("Neither src.proxy.dir nor proxy.generation.dir set.  Defaulting to " + proxyDir.getAbsolutePath());
            }
            if (!proxyDir.exists()) {
                proxyDir.mkdirs();
            } else if (!proxyDir.isDirectory()) {
                throw new BuildException(proxyDir.getAbsolutePath() + " is not a folder");
            }
            return proxyDir;
        }
    }
}

