/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.encapsulation;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ReturnEncapsulation {
    private static final String COLLECTION = "java.util.Collection";
    private static final String MAP = "java.util.Map";
    private static final String DATE = "java.util.Date";
    private static final String CALENDAR = "java.util.Calendar";
    private static final String A_OBJ = "java.lang.Object[]";
    private static final String A_BOOL = "boolean[]";
    private static final String A_BYTE = "byte[]";
    private static final String A_CHAR = "char[]";
    private static final String A_SHORT = "short[]";
    private static final String A_INT = "int[]";
    private static final String A_LONG = "long[]";
    private static final String A_FLOAT = "float[]";
    private static final String A_DOUBLE = "double[]";

    public static ErrorDescription collection(HintContext hintContext) {
        assert (hintContext != null);
        return ReturnEncapsulation.create(hintContext, NbBundle.getMessage(ReturnEncapsulation.class, (String)"TXT_ReturnCollection"), "ReturnOfCollectionOrArrayField", new CollectionFix());
    }

    public static ErrorDescription array(HintContext hintContext) {
        assert (hintContext != null);
        return ReturnEncapsulation.create(hintContext, NbBundle.getMessage(ReturnEncapsulation.class, (String)"TXT_ReturnArray"), "ReturnOfCollectionOrArrayField", new FixProvider[0]);
    }

    public static ErrorDescription date(HintContext hintContext) {
        assert (hintContext != null);
        return ReturnEncapsulation.create(hintContext, NbBundle.getMessage(ReturnEncapsulation.class, (String)"TXT_ReturnDate"), "ReturnOfDateField", new FixProvider[0]);
    }

    private static ErrorDescription create(HintContext hintContext, String string, String string2, FixProvider ... fixProviderArray) {
        Fix[] fixArray;
        assert (hintContext != null);
        assert (string2 != null);
        CompilationInfo compilationInfo = hintContext.getInfo();
        TreePath treePath = hintContext.getPath();
        TreePath treePath2 = hintContext.getVariables().get("$expr");
        Element element = compilationInfo.getTrees().getElement(treePath2);
        TypeMirror typeMirror = compilationInfo.getTrees().getTypeMirror(treePath2);
        if (element == null || typeMirror == null || element.getKind() != ElementKind.FIELD || typeMirror.getKind() == TypeKind.ERROR) {
            return null;
        }
        Element element2 = ReturnEncapsulation.getElementOrNull(compilationInfo, ReturnEncapsulation.findEnclosingMethod(treePath));
        if (element2 == null || element2.getEnclosingElement() != element.getEnclosingElement()) {
            return null;
        }
        Fix fix = FixFactory.createSuppressWarningsFix(compilationInfo, treePath, string2);
        if (fixProviderArray.length == 0) {
            fixArray = new Fix[]{fix};
        } else {
            fixArray = new Fix[fixProviderArray.length + 1];
            for (int i = 0; i < fixProviderArray.length; ++i) {
                fixArray[i] = fixProviderArray[i].fixFor(compilationInfo, treePath2);
            }
            fixArray[fixProviderArray.length] = fix;
        }
        return ErrorDescriptionFactory.forTree(hintContext, treePath, string, fixArray);
    }

    private static final TreePath findEnclosingMethod(TreePath treePath) {
        while (treePath != null && treePath.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
            if (treePath.getLeaf().getKind() == Tree.Kind.METHOD) {
                return treePath;
            }
            treePath = treePath.getParentPath();
        }
        return null;
    }

    private static Element getElementOrNull(CompilationInfo compilationInfo, TreePath treePath) {
        return treePath == null ? null : compilationInfo.getTrees().getElement(treePath);
    }

    private static class CollectionFix
    implements Fix,
    FixProvider {
        private static final String UNMOD_COL = "unmodifiableCollection";
        private static final String UNMOD_LIST = "unmodifiableList";
        private static final String UNMOD_SET = "unmodifiableSet";
        private static final String UNMOD_MAP = "unmodifiableMap";
        private static final String LIST = "java.util.List";
        private static final String SET = "java.util.Set";
        private static final String COLLECTIONS = "java.util.Collections";
        private TreePathHandle handle;
        private String method;
        private String field;

        private CollectionFix() {
        }

        public String getText() {
            assert (this.handle != null);
            return NbBundle.getMessage(ReturnEncapsulation.class, (String)"FIX_ReplaceWithUC", (Object)this.method, (Object)this.field);
        }

        public ChangeInfo implement() throws Exception {
            assert (this.handle != null);
            FileObject fileObject = this.handle.getFileObject();
            if (fileObject == null) {
                return null;
            }
            JavaSource.forFileObject((FileObject)fileObject).runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws Exception {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath treePath = CollectionFix.this.handle.resolve((CompilationInfo)workingCopy);
                    if (treePath == null) {
                        return;
                    }
                    TreeMaker treeMaker = workingCopy.getTreeMaker();
                    String string = SourceUtils.resolveImport((CompilationInfo)workingCopy, (TreePath)treePath, (String)CollectionFix.COLLECTIONS);
                    workingCopy.rewrite(treePath.getLeaf(), (Tree)treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)string), (CharSequence)CollectionFix.this.method), Collections.singletonList((ExpressionTree)treePath.getLeaf())));
                }
            }).commit();
            return null;
        }

        @Override
        public Fix fixFor(CompilationInfo compilationInfo, TreePath treePath) {
            assert (compilationInfo != null);
            assert (treePath != null);
            assert (this.handle == null);
            this.handle = TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo);
            this.field = compilationInfo.getTrees().getElement(treePath).getSimpleName().toString();
            Types types = compilationInfo.getTypes();
            Elements elements = compilationInfo.getElements();
            TypeMirror typeMirror = types.erasure(compilationInfo.getTrees().getTypeMirror(treePath));
            TypeElement typeElement = elements.getTypeElement(LIST);
            TypeElement typeElement2 = elements.getTypeElement(SET);
            TypeElement typeElement3 = elements.getTypeElement(ReturnEncapsulation.MAP);
            this.method = typeElement != null && types.isSubtype(typeMirror, types.erasure(typeElement.asType())) ? UNMOD_LIST : (typeElement2 != null && types.isSubtype(typeMirror, types.erasure(typeElement2.asType())) ? UNMOD_SET : (typeElement3 != null && types.isSubtype(typeMirror, types.erasure(typeElement3.asType())) ? UNMOD_MAP : UNMOD_COL));
            return this;
        }
    }

    private static interface FixProvider {
        public Fix fixFor(CompilationInfo var1, TreePath var2);
    }
}

