/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.output;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.LibLayoutBoot;
import org.jfree.layouting.layouter.context.DocumentContext;
import org.jfree.layouting.layouter.feed.DefaultInputFeed;
import org.jfree.layouting.layouter.feed.InputFeed;
import org.jfree.layouting.normalizer.content.ContentNormalizer;
import org.jfree.layouting.normalizer.content.Normalizer;
import org.jfree.layouting.normalizer.displaymodel.FastDisplayModelBuilder;
import org.jfree.layouting.normalizer.displaymodel.ModelBuilder;
import org.jfree.layouting.normalizer.generator.DefaultContentGenerator;
import org.jfree.layouting.output.OutputProcessor;
import org.jfree.layouting.output.pageable.LogicalPageKey;
import org.jfree.layouting.renderer.model.page.LogicalPageBox;
import org.jfree.layouting.renderer.model.page.PageGrid;
import org.pentaho.reporting.libraries.base.config.Configuration;

public abstract class AbstractOutputProcessor
implements OutputProcessor {
    protected static final int PROCESSING_GLOBAL_CONTENT = 0;
    protected static final int PROCESSING_PAGES = 1;
    protected static final int PROCESSING_CONTENT = 2;
    private int processingState;
    private Configuration configuration;
    private List logicalPages;
    private int pageCursor;
    private DocumentContext documentContext;

    public AbstractOutputProcessor(Configuration configuration) {
        this.configuration = configuration == null ? LibLayoutBoot.getInstance().getGlobalConfig() : configuration;
        this.logicalPages = new ArrayList();
    }

    public boolean isPaginationFinished() {
        return this.processingState == 2;
    }

    public void processingFinished() {
        this.pageCursor = 0;
        if (this.processingState == 0) {
            this.processingGlobalContentFinished();
            this.processingState = 1;
        } else if (this.processingState == 1) {
            this.processingPagesFinished();
            this.processingState = 2;
        } else {
            this.processingContentFinished();
        }
        this.documentContext = null;
    }

    protected void processingContentFinished() {
    }

    public DocumentContext getDocumentContext() {
        return this.documentContext;
    }

    protected void processingPagesFinished() {
        this.logicalPages = Collections.unmodifiableList(this.logicalPages);
    }

    protected void processingGlobalContentFinished() {
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public InputFeed createInputFeed(LayoutProcess layoutProcess) {
        return new DefaultInputFeed(layoutProcess);
    }

    public Normalizer createNormalizer(LayoutProcess layoutProcess) {
        return new ContentNormalizer(layoutProcess);
    }

    public ModelBuilder createModelBuilder(LayoutProcess layoutProcess) {
        return new FastDisplayModelBuilder(new DefaultContentGenerator(layoutProcess), layoutProcess);
    }

    public int getLogicalPageCount() {
        return this.logicalPages.size();
    }

    public LogicalPageKey getLogicalPage(int n) {
        if (!this.isPaginationFinished()) {
            throw new IllegalStateException();
        }
        return (LogicalPageKey)this.logicalPages.get(n);
    }

    protected LogicalPageKey createLogicalPage(int n, int n2) {
        LogicalPageKey logicalPageKey = new LogicalPageKey(this.logicalPages.size(), n, n2);
        this.logicalPages.add(logicalPageKey);
        return logicalPageKey;
    }

    public int getPageCursor() {
        return this.pageCursor;
    }

    public void setPageCursor(int n) {
        this.pageCursor = n;
    }

    public boolean isGlobalStateComputed() {
        return this.processingState > 0;
    }

    protected int getProcessingState() {
        return this.processingState;
    }

    public boolean isContentGeneratable() {
        return this.processingState == 2;
    }

    public final void processContent(LogicalPageBox logicalPageBox) {
        if (!this.isGlobalStateComputed()) {
            return;
        }
        if (!this.isContentGeneratable()) {
            PageGrid pageGrid = logicalPageBox.getPageGrid();
            int n = pageGrid.getRowCount();
            int n2 = pageGrid.getColumnCount();
            LogicalPageKey logicalPageKey = this.createLogicalPage(n2, n);
            int n3 = this.getPageCursor();
            if (logicalPageKey.getPosition() != n3) {
                throw new IllegalStateException("Expected position " + n3 + " is not the key's position " + logicalPageKey.getPosition());
            }
            this.setPageCursor(n3 + 1);
            return;
        }
        if (this.isContentGeneratable()) {
            int n = this.getPageCursor();
            LogicalPageKey logicalPageKey = this.getLogicalPage(n);
            this.processPageContent(logicalPageKey, logicalPageBox);
            this.setPageCursor(n + 1);
        }
    }

    protected abstract void processPageContent(LogicalPageKey var1, LogicalPageBox var2);

    public void processDocumentMetaData(DocumentContext documentContext) {
        this.documentContext = documentContext;
    }
}

