/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.fonts;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.input.style.keys.font.FontWeight;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.ResolveHandler;

public class FontWeightResolveHandler
implements ResolveHandler {
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[0];
    }

    public void resolve(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        int n;
        LayoutContext layoutContext = layoutElement.getLayoutContext();
        CSSValue cSSValue = layoutContext.getValue(styleKey);
        if (FontWeight.BOLD.equals(cSSValue)) {
            n = 700;
        } else if (FontWeight.NORMAL.equals(cSSValue)) {
            n = 400;
        } else if (FontWeight.BOLDER.equals(cSSValue)) {
            int n2 = this.queryParent(layoutElement.getParent());
            n = Math.max(900, n2 + 100);
        } else if (FontWeight.LIGHTER.equals(cSSValue)) {
            int n3 = this.queryParent(layoutElement.getParent());
            n = Math.min(100, n3 - 100);
        } else {
            CSSNumericValue cSSNumericValue;
            n = cSSValue instanceof CSSNumericValue ? (!CSSNumericType.NUMBER.equals((cSSNumericValue = (CSSNumericValue)cSSValue).getType()) ? this.queryParent(layoutElement.getParent()) : (int)cSSNumericValue.getValue()) : this.queryParent(layoutElement.getParent());
        }
        layoutContext.setValue(FontStyleKeys.FONT_WEIGHT, CSSNumericValue.createValue(CSSNumericType.NUMBER, n));
    }

    private int queryParent(LayoutElement layoutElement) {
        if (layoutElement == null) {
            return 400;
        }
        return layoutElement.getLayoutContext().getFontSpecification().getFontWeight();
    }
}

