/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.PrefixGenerator;

public class PrefixFilter
extends Filter {
    protected final Term prefix;

    public PrefixFilter(Term prefix) {
        this.prefix = prefix;
    }

    public Term getPrefix() {
        return this.prefix;
    }

    public BitSet bits(IndexReader reader) throws IOException {
        final BitSet bitSet = new BitSet(reader.maxDoc());
        new PrefixGenerator(this.prefix){

            public void handleDoc(int doc) {
                bitSet.set(doc);
            }
        }.generate(reader);
        return bitSet;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("PrefixFilter(");
        buffer.append(this.prefix.toString());
        buffer.append(")");
        return buffer.toString();
    }
}

