/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.beans;

import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.BridgeExistsException;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.comp.beans.ContainerFactory;
import com.sun.star.comp.beans.LocalOfficeWindow;
import com.sun.star.comp.beans.NativeService;
import com.sun.star.comp.beans.OfficeConnection;
import com.sun.star.comp.beans.OfficeWindow;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lib.uno.helper.UnoUrl;
import com.sun.star.lib.util.NativeLibraryLoader;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.Container;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class LocalOfficeConnection
implements OfficeConnection {
    public static final String OFFICE_APP_NAME = "soffice";
    public static final String OFFICE_LIB_NAME = "officebean";
    public static final String OFFICE_ID_SUFFIX = "_Office";
    private static String mProgramPath;
    private Process mProcess;
    private ContainerFactory mContainerFactory;
    private XComponentContext mContext;
    private XBridge mBridge;
    private String mURL;
    private String mConnType;
    private String mPipe;
    private String mPort;
    private String mProtocol;
    private String mInitialObject;
    private List mComponents = new Vector();
    private static long m_nBridgeCounter;

    private void dbgPrint(String string) {
        System.err.println(string);
    }

    public LocalOfficeConnection() {
        try {
            this.setUnoUrl("uno:pipe,name=" + LocalOfficeConnection.getPipeName() + ";urp;StarOffice.ServiceManager");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    protected LocalOfficeConnection(XComponentContext xComponentContext) {
        this.mContext = xComponentContext;
    }

    public void setUnoUrl(String string) throws MalformedURLException {
        this.mURL = null;
        String string2 = "uno:localoffice";
        if (string.startsWith(string2)) {
            this.parseUnoUrlWithOfficePath(string, string2);
        } else {
            try {
                UnoUrl unoUrl = UnoUrl.parseUnoUrl((String)string);
                mProgramPath = null;
                this.mConnType = unoUrl.getConnection();
                this.mPipe = (String)unoUrl.getConnectionParameters().get("pipe");
                this.mPort = (String)unoUrl.getConnectionParameters().get("port");
                this.mProtocol = unoUrl.getProtocol();
                this.mInitialObject = unoUrl.getRootOid();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new MalformedURLException("Invalid UNO connection URL.");
            }
        }
        this.mURL = string;
    }

    public void setContainerFactory(ContainerFactory containerFactory) {
        this.mContainerFactory = containerFactory;
    }

    public synchronized XComponentContext getComponentContext() {
        if (this.mContext == null) {
            this.mContext = this.connect();
        }
        return this.mContext;
    }

    public OfficeWindow createOfficeWindow(Container container) {
        return new LocalOfficeWindow(this);
    }

    public void dispose() {
        Iterator iterator = this.mComponents.iterator();
        while (iterator.hasNext()) {
            try {
                ((XEventListener)iterator.next()).disposing(null);
            }
            catch (RuntimeException runtimeException) {}
        }
        this.mComponents.clear();
        if (this.mBridge != null) {
            XComponent xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.mBridge);
            if (xComponent != null) {
                xComponent.dispose();
            } else {
                System.err.println("LocalOfficeConnection: could not dispose bridge!");
            }
            this.mBridge = null;
        }
        this.mContainerFactory = null;
        this.mContext = null;
    }

    public void addEventListener(XEventListener xEventListener) {
        this.mComponents.add(xEventListener);
    }

    public void removeEventListener(XEventListener xEventListener) {
        this.mComponents.remove(xEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private XComponentContext connect() {
        try {
            Object object;
            XComponentContext xComponentContext = Bootstrap.createInitialComponentContext(null);
            XMultiComponentFactory xMultiComponentFactory = xComponentContext.getServiceManager();
            Object object2 = null;
            try {
                object2 = this.resolve(xComponentContext, this.mURL);
            }
            catch (NoConnectException noConnectException) {
                object = new OfficeService();
                ((OfficeService)object).startupService();
                long l = System.currentTimeMillis() + (long)(1000 * ((OfficeService)object).getStartupTime());
                while (object2 == null) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(500L);
                        object2 = this.resolve(xComponentContext, this.mURL);
                    }
                    catch (NoConnectException noConnectException2) {
                        if (System.currentTimeMillis() <= l) continue;
                        throw noConnectException2;
                    }
                }
            }
            if (null == object2) return null;
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)object2);
            object = xPropertySet.getPropertyValue("DefaultContext");
            return (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)object);
        }
        catch (NoConnectException noConnectException) {
            System.out.println("Couldn't connect to remote server");
            System.out.println(noConnectException.getMessage());
            return null;
        }
        catch (ConnectionSetupException connectionSetupException) {
            System.out.println("Couldn't access necessary local resource to establish the interprocess connection");
            System.out.println(connectionSetupException.getMessage());
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("uno-url is syntactical illegal ( " + this.mURL + " )");
            System.out.println(illegalArgumentException.getMessage());
            return null;
        }
        catch (com.sun.star.uno.RuntimeException runtimeException) {
            System.out.println("--- RuntimeException:");
            System.out.println(runtimeException.getMessage());
            runtimeException.printStackTrace();
            System.out.println("--- end.");
            throw runtimeException;
        }
        catch (Exception exception) {
            System.out.println("java.lang.Exception: ");
            System.out.println(exception);
            exception.printStackTrace();
            System.out.println("--- end.");
            throw new com.sun.star.uno.RuntimeException(exception.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object resolve(XComponentContext xComponentContext, String string) throws NoConnectException, ConnectionSetupException, IllegalArgumentException {
        String string2;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (string.indexOf(59) == -1) {
            string3 = string;
            string4 = "iiop";
            string5 = "classic_uno";
        } else {
            int n = string.indexOf(58);
            string2 = string.substring(0, n).trim();
            string = string.substring(n + 1).trim();
            n = string.indexOf(59);
            string3 = string.substring(0, n).trim();
            string = string.substring(n + 1).trim();
            n = string.indexOf(59);
            string4 = string.substring(0, n).trim();
            string = string.substring(n + 1).trim();
            string5 = string.trim().trim();
        }
        Object object = null;
        string2 = null;
        XMultiComponentFactory xMultiComponentFactory = xComponentContext.getServiceManager();
        try {
            string2 = (XBridgeFactory)UnoRuntime.queryInterface(XBridgeFactory.class, (Object)xMultiComponentFactory.createInstanceWithContext("com.sun.star.bridge.BridgeFactory", xComponentContext));
        }
        catch (com.sun.star.uno.Exception exception) {
            throw new com.sun.star.uno.RuntimeException(exception.getMessage());
        }
        LocalOfficeConnection localOfficeConnection = this;
        synchronized (localOfficeConnection) {
            if (this.mBridge == null) {
                Object object2 = null;
                try {
                    object2 = xMultiComponentFactory.createInstanceWithContext("com.sun.star.connection.Connector", xComponentContext);
                }
                catch (com.sun.star.uno.Exception exception) {
                    throw new com.sun.star.uno.RuntimeException(exception.getMessage());
                }
                XConnector xConnector = (XConnector)UnoRuntime.queryInterface(XConnector.class, (Object)object2);
                XConnection xConnection = xConnector.connect(string3);
                String string6 = "OOoBean_private_bridge_" + String.valueOf(m_nBridgeCounter++);
                try {
                    this.mBridge = string2.createBridge(string6, string4, xConnection, null);
                }
                catch (BridgeExistsException bridgeExistsException) {
                    throw new com.sun.star.uno.RuntimeException(bridgeExistsException.getMessage());
                }
            }
            object = this.mBridge.getInstance(string5);
            return object;
        }
    }

    private static String getProgramPath() {
        if (mProgramPath == null) {
            File file;
            String string = OFFICE_APP_NAME;
            String string2 = System.getProperty("os.name");
            if (string2.startsWith("Windows")) {
                string = "soffice.exe";
            }
            if ((file = NativeLibraryLoader.getResource((ClassLoader)LocalOfficeConnection.class.getClassLoader(), (String)string)) != null) {
                mProgramPath = file.getParent();
            }
            if (mProgramPath == null) {
                mProgramPath = "";
            }
        }
        return mProgramPath;
    }

    private void parseUnoUrlWithOfficePath(String string, String string2) throws MalformedURLException {
        int n = string.indexOf(";urp;StarOffice.NamingService");
        if (n < 0) {
            throw new MalformedURLException("Invalid UNO connection URL.");
        }
        String string3 = string.substring(string2.length(), n + 1);
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        block35: for (n = 0; n < string3.length(); ++n) {
            char c = string3.charAt(n);
            switch (n2) {
                case 0: {
                    switch (c) {
                        case ',': {
                            stringBuffer.delete(0, stringBuffer.length());
                            n2 = 1;
                            continue block35;
                        }
                        case ';': {
                            n2 = 7;
                            continue block35;
                        }
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append(c);
                    n2 = 1;
                    continue block35;
                }
                case 1: {
                    switch (c) {
                        case ' ': 
                        case '=': {
                            string4 = stringBuffer.toString();
                            n2 = c == ' ' ? 2 : 3;
                            continue block35;
                        }
                        case ',': 
                        case ';': {
                            n2 = -6;
                            continue block35;
                        }
                    }
                    stringBuffer.append(c);
                    continue block35;
                }
                case 2: {
                    switch (c) {
                        case '=': {
                            n2 = 3;
                            continue block35;
                        }
                        case ' ': {
                            continue block35;
                        }
                    }
                    n2 = -1;
                    continue block35;
                }
                case 3: {
                    switch (c) {
                        case ' ': {
                            continue block35;
                        }
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append(c);
                    n2 = 4;
                    continue block35;
                }
                case 4: {
                    switch (c) {
                        case ' ': 
                        case ',': 
                        case ';': {
                            --n;
                            n2 = 5;
                            if (string4.equals("path")) {
                                if (string5 == null) {
                                    string5 = stringBuffer.toString();
                                } else {
                                    n2 = -3;
                                }
                            } else if (string4.equals("pipe")) {
                                if (string6 == null) {
                                    string6 = stringBuffer.toString();
                                } else {
                                    n2 = -4;
                                }
                            } else {
                                n2 = -2;
                            }
                            stringBuffer.delete(0, stringBuffer.length());
                            continue block35;
                        }
                    }
                    stringBuffer.append(c);
                    continue block35;
                }
                case 5: {
                    switch (c) {
                        case ' ': {
                            continue block35;
                        }
                        case ',': {
                            n2 = 6;
                            continue block35;
                        }
                        case ';': {
                            n2 = 7;
                            continue block35;
                        }
                    }
                    n2 = -5;
                    continue block35;
                }
                case 6: {
                    switch (c) {
                        case ' ': {
                            continue block35;
                        }
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append(c);
                    n2 = 1;
                    continue block35;
                }
                default: {
                    throw new MalformedURLException("Invalid UNO connection URL.");
                }
            }
        }
        if (n2 != 7) {
            throw new MalformedURLException("Invalid UNO connection URL.");
        }
        if (string5 != null) {
            mProgramPath = string5;
        }
        if (string6 != null) {
            this.mPipe = string6;
        }
    }

    private static String replaceAll(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string.length();
        int n2 = string2.length();
        while ((n = string.lastIndexOf(string2, n - 1)) > -1) {
            stringBuffer.replace(n, n + n2, string3);
        }
        return stringBuffer.toString();
    }

    static String getPipeName() {
        String string = System.getProperty("user.name") + OFFICE_ID_SUFFIX;
        string = LocalOfficeConnection.replaceAll(string, "_", "%B7");
        return LocalOfficeConnection.replaceAll(LocalOfficeConnection.replaceAll(URLEncoder.encode(string), "+", "%20"), "%", "_");
    }

    static {
        m_nBridgeCounter = 0L;
        if (System.getProperty("os.name").startsWith("Windows")) {
            try {
                NativeLibraryLoader.loadLibrary((ClassLoader)LocalOfficeConnection.class.getClassLoader(), (String)"msvcr70");
            }
            catch (Throwable throwable) {
                System.err.println("cannot find msvcr70");
            }
            try {
                NativeLibraryLoader.loadLibrary((ClassLoader)LocalOfficeConnection.class.getClassLoader(), (String)"msvcr71");
            }
            catch (Throwable throwable) {
                System.err.println("cannot find msvcr71");
            }
            try {
                NativeLibraryLoader.loadLibrary((ClassLoader)LocalOfficeConnection.class.getClassLoader(), (String)"uwinapi");
            }
            catch (Throwable throwable) {
                System.err.println("cannot find uwinapi");
            }
            try {
                NativeLibraryLoader.loadLibrary((ClassLoader)LocalOfficeConnection.class.getClassLoader(), (String)"jawt");
            }
            catch (Throwable throwable) {
                System.err.println("cannot find jawt");
            }
        }
        NativeLibraryLoader.loadLibrary((ClassLoader)LocalOfficeConnection.class.getClassLoader(), (String)OFFICE_LIB_NAME);
    }

    class StreamProcessor
    extends Thread {
        InputStream m_in;
        PrintStream m_print;

        public StreamProcessor(InputStream inputStream, PrintStream printStream) {
            this.m_in = inputStream;
            this.m_print = printStream;
            this.start();
        }

        public void run() {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.m_in));
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    this.m_print.println(string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
            }
        }
    }

    private class OfficeService
    implements NativeService {
        private OfficeService() {
        }

        public String getIdentifier() {
            if (LocalOfficeConnection.this.mPipe == null) {
                return LocalOfficeConnection.getPipeName();
            }
            return LocalOfficeConnection.this.mPipe;
        }

        public void startupService() throws IOException {
            int n = 4;
            String string = null;
            try {
                string = System.getProperty("com.sun.star.officebean.Options");
                if (string != null) {
                    ++n;
                }
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            String[] stringArray = new String[n];
            String string2 = System.getenv("UNO_PATH");
            if (string2 == null) {
                throw new IOException("UNO_PATH environment variable is not set (required system path to the office program directory)");
            }
            stringArray[0] = new File(string2, LocalOfficeConnection.OFFICE_APP_NAME).getPath();
            stringArray[1] = "-nologo";
            stringArray[2] = "-nodefault";
            if (LocalOfficeConnection.this.mConnType.equals("pipe")) {
                stringArray[3] = "-accept=pipe,name=" + this.getIdentifier() + ";" + LocalOfficeConnection.this.mProtocol + ";" + LocalOfficeConnection.this.mInitialObject;
            } else if (LocalOfficeConnection.this.mConnType.equals("socket")) {
                stringArray[3] = "-accept=socket,port=" + LocalOfficeConnection.this.mPort + ";urp";
            } else {
                throw new IOException("not connection specified");
            }
            if (string != null) {
                stringArray[4] = string;
            }
            LocalOfficeConnection.this.mProcess = Runtime.getRuntime().exec(stringArray);
            if (LocalOfficeConnection.this.mProcess == null) {
                throw new RuntimeException("cannot start soffice: " + stringArray);
            }
            new StreamProcessor(LocalOfficeConnection.this.mProcess.getInputStream(), System.out);
            new StreamProcessor(LocalOfficeConnection.this.mProcess.getErrorStream(), System.err);
        }

        public int getStartupTime() {
            return 60;
        }
    }
}

