#!/bin/sh
echo 'name: snap-core
version: 0.5.3.1
id: snap-core-0.5.3.1-dffd36a79bf080ee537b61fe6fb81744

license: BSD3
copyright:
maintainer: snap@snapframework.com
stability:
homepage: http://snapframework.com/
package-url:
description: Snap is a simple and fast web development framework and server written in
             Haskell. For more information or to download the latest version, you can
             visit the Snap project website at <http://snapframework.com/>.
             .
             This library contains the core definitions and types for the Snap framework,
             including:
             .
             1. Primitive types and functions for HTTP (requests, responses, cookies,
             post/query parameters, etc)
             .
             2. Type aliases and helper functions for Iteratee I/O
             .
             3. A monad for programming web handlers called \"Snap\", inspired by
             happstack'\''s (<http://happstack.com/index.html>), which allows:
             .
             * Stateful access to the HTTP request and response objects
             .
             * Monadic failure (i.e. MonadPlus/Alternative instances) for declining
             to handle requests and chaining handlers together
             .
             * Early termination of the computation if you know early what you want
             to return and want to prevent further monadic processing
             .
             /Quick start/: The '\''Snap'\'' monad and HTTP definitions are in "Snap.Types",
             some iteratee utilities are in "Snap.Iteratee".
             .
             Higher-level facilities for building web applications (like user/session
             management, component interfaces, data modeling, etc.) are planned but not
             yet implemented, so this release will mostly be of interest for those who:
             .
             * need a fast and minimal HTTP API at roughly the same level of abstraction
             as Java servlets, or
             .
             * are interested in contributing to the Snap Framework project.
category: Web
author: James Sanders, Shu-yu Guo, Gregory Collins, Doug Beardsley
pkgpath: www/hs-snap-core
exposed: True
exposed-modules: Snap.Types Snap.Iteratee Snap.Internal.Debug
                 Snap.Internal.Http.Types Snap.Internal.Iteratee.Debug
                 Snap.Internal.Parsing Snap.Util.FileServe Snap.Util.FileUploads
                 Snap.Util.GZip Snap.Util.Readable
hidden-modules: Snap.Internal.Instances
                Snap.Internal.Iteratee.BoyerMooreHorspool Snap.Internal.Routing
                Snap.Internal.Types
import-dirs: /usr/local/lib/ghc/snap-core-0.5.3.1
library-dirs: /usr/local/lib/ghc/snap-core-0.5.3.1
hs-libraries: HSsnap-core-0.5.3.1
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: MonadCatchIO-transformers-0.2.2.0-f749ec9c65171550034463cf701d6100
         attoparsec-0.8.6.1-6571973e9a458e9ceb9b784270798e62
         attoparsec-enumerator-0.2.0.3-7161253b2694c3a63f8802608904707a
         base-4.3.1.0-4365831fa9af03083be195ed161cbbc1
         blaze-builder-0.2.1.4-a9a25d33e6d6a838e2cd173ee4fe6a2b
         bytestring-0.9.1.10-d11caeadd9605139e1a59850ce083826
         bytestring-nums-0.3.2-e640f226ab44e5f9048a33c04862e67f
         case-insensitive-0.3.0.1-a89b449b7d7ce6dd6c6d718d8bc83cb5
         containers-0.4.0.0-b4885363abca642443ccd842502a3b7e
         deepseq-1.1.0.2-0465f803f7d27d264907e7e03e72a71f
         directory-1.1.0.0-0764d4838863123df574e64d163bd619
         dlist-0.5-ca3cc433d5d17f6b2e98d32547d0f736
         enumerator-0.4.14-9c33aff818231fce81258e5fdfab7c93
         filepath-1.2.0.0-b4f4cf7e95546b00f075372f0ccb0653
         mtl-2.0.1.0-5b7a9cce5565d8cc8721ba4f95becf1b
         old-locale-1.0.0.2-161f79060c89cc16ca11576ceb440486
         old-time-1.0.0.6-088ba18f14be11f5303a5ce07fd2f643
         text-0.11.1.5-24dbc1ca0a1252804bf8bef893d5cf9c
         time-1.2.0.3-3493203919ef238f1a58223fa55b1ceb
         transformers-0.2.2.0-4bbbfde1fb5c4eb17cdb1963dda698f3
         unix-compat-0.2-9216f37afe4b8111ce6e5fd663b85f80
         vector-0.7.1-8801549ab29457801fbe1eca2f7ad3c5
         zlib-0.5.3.1-7e19941cbd00147a79723e25160ffc8b
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-snap-core-0.5.3.1/html/snap-core.haddock
haddock-html: /usr/local/share/doc/hs-snap-core-0.5.3.1/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
