#!/bin/sh
echo 'name: cryptohash
version: 0.7.0
id: cryptohash-0.7.0-f59ea148ba6fadfd32d16c0b11e0bb1f

license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability:
homepage: http://github.com/vincenthz/hs-cryptohash
package-url:
description: A collection of crypto hashes, with a practical incremental and one-pass, pure APIs,
             with performance close to the fastest implementations available in others languages.
             .
             The implementations are made in C with a haskell FFI wrapper that hide the C implementation.
category: Data, Cryptography
author: Vincent Hanquez <vincent@snarc.org>
pkgpath: security/hs-cryptohash
exposed: True
exposed-modules: Crypto.Hash.SHA1 Crypto.Hash.SHA224
                 Crypto.Hash.SHA256 Crypto.Hash.SHA384 Crypto.Hash.SHA512
                 Crypto.Hash.SHA512t Crypto.Hash.MD2 Crypto.Hash.MD4 Crypto.Hash.MD5
                 Crypto.Hash.RIPEMD160 Crypto.Hash.Skein256 Crypto.Hash.Skein512
                 Crypto.Hash.Tiger
hidden-modules:
import-dirs: /usr/local/lib/ghc/cryptohash-0.7.0
library-dirs: /usr/local/lib/ghc/cryptohash-0.7.0
hs-libraries: HScryptohash-0.7.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-4365831fa9af03083be195ed161cbbc1
         bytestring-0.9.1.10-d11caeadd9605139e1a59850ce083826
         cereal-0.3.0.0-c17ac2a70f89323d10af6f3ac87760ec
         crypto-api-0.8-05b728f3d677abca6e90bce525286739
         tagged-0.2-4db34a1a28b200ea54bef8eab1247bdb
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-cryptohash-0.7.0/html/cryptohash.haddock
haddock-html: /usr/local/share/doc/hs-cryptohash-0.7.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
