/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import gnu.java.lang.CPStringBuilder;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.QueryExp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectName
implements Serializable,
QueryExp {
    private static final long serialVersionUID = 1081892073854801359L;
    public static final ObjectName WILDCARD;
    private transient String domain;
    private transient TreeMap<String, String> properties;
    private transient String propertyListString;
    private transient boolean propertyListPattern;
    private transient boolean propertyValuePattern;
    private transient MBeanServer server;

    static {
        try {
            WILDCARD = new ObjectName("");
        }
        catch (MalformedObjectNameException e) {
            throw (InternalError)new InternalError("A problem occurred initializing the ObjectName wildcard.").initCause(e);
        }
    }

    public ObjectName(String name) throws MalformedObjectNameException {
        if (name.length() == 0) {
            name = "*:*";
        }
        this.parse(name);
    }

    private void parse(String name) throws MalformedObjectNameException {
        int domainSep = name.indexOf(58);
        if (domainSep == -1) {
            throw new MalformedObjectNameException("No domain separator was found.");
        }
        this.domain = name.substring(0, domainSep);
        String rest = name.substring(domainSep + 1);
        this.properties = new TreeMap();
        String[] pairs = rest.split(",");
        if (pairs.length == 0 && !this.isPattern()) {
            throw new MalformedObjectNameException("A name that is not a pattern must contain at least one key-value pair.");
        }
        this.propertyListString = "";
        int a = 0;
        while (a < pairs.length) {
            if (pairs[a].equals("*")) {
                if (this.propertyListPattern) {
                    throw new MalformedObjectNameException("Multiple wildcards in properties.");
                }
                this.propertyListPattern = true;
            } else {
                int sep = pairs[a].indexOf(61);
                if (sep == -1) {
                    throw new MalformedObjectNameException("A key must be followed by a value.");
                }
                String key = pairs[a].substring(0, sep);
                if (this.properties.containsKey(key)) {
                    throw new MalformedObjectNameException("The same key occurs more than once.");
                }
                String value = pairs[a].substring(sep + 1);
                this.properties.put(key, value);
                this.propertyListString = String.valueOf(this.propertyListString) + key + "=" + value + ",";
            }
            ++a;
        }
        if (this.propertyListString.length() > 0) {
            this.propertyListString = this.propertyListString.substring(0, this.propertyListString.length() - 1);
        }
        this.checkComponents();
    }

    public ObjectName(String domain, String key, String value) throws MalformedObjectNameException {
        this.domain = domain;
        this.properties = new TreeMap();
        this.properties.put(key, value);
        this.checkComponents();
    }

    public ObjectName(String domain, Hashtable<String, String> properties) throws MalformedObjectNameException {
        this.domain = domain;
        this.properties = new TreeMap();
        this.properties.putAll(properties);
        this.checkComponents();
    }

    private void checkComponents() throws MalformedObjectNameException {
        if (this.domain.indexOf(58) != -1) {
            throw new MalformedObjectNameException("The domain includes a ':' character.");
        }
        if (this.domain.indexOf(10) != -1) {
            throw new MalformedObjectNameException("The domain includes a newline character.");
        }
        char[] keychars = new char[]{'\n', ':', ',', '*', '?', '='};
        char[] valchars = new char[]{'\n', ':', ',', '='};
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            int a = 0;
            while (a < keychars.length) {
                if (entry.getKey().indexOf(keychars[a]) != -1) {
                    throw new MalformedObjectNameException("A key contains a '" + keychars[a] + "' " + "character.");
                }
                ++a;
            }
            String value = entry.getValue();
            int quote = value.indexOf(34);
            if (quote == 0) {
                try {
                    ObjectName.unquote(value);
                }
                catch (IllegalArgumentException e) {
                    throw (MalformedObjectNameException)new MalformedObjectNameException("The quoted value is invalid.").initCause(e);
                }
            } else {
                if (quote != -1) {
                    throw new MalformedObjectNameException("A value contains a '\"' character.");
                }
                int a2 = 0;
                while (a2 < valchars.length) {
                    if (value.indexOf(valchars[a2]) != -1) {
                        throw new MalformedObjectNameException("A value contains a '" + valchars[a2] + "' " + "character.");
                    }
                    ++a2;
                }
            }
            if (value.indexOf(42) == -1 && value.indexOf(63) == -1) continue;
            this.propertyValuePattern = true;
        }
    }

    @Override
    public boolean apply(ObjectName name) {
        if (name.isPattern()) {
            return false;
        }
        if (!this.isPattern()) {
            return this.equals(name);
        }
        if (this.isDomainPattern() ? !ObjectName.domainMatches(this.domain, 0, name.getDomain(), 0) : !this.domain.equals(name.getDomain())) {
            return false;
        }
        if (this.isPropertyPattern()) {
            Hashtable<String, String> oProps = name.getKeyPropertyList();
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                String key = entry.getKey();
                if (!oProps.containsKey(key)) {
                    return false;
                }
                String val = entry.getValue();
                if (val.equals(oProps.get(key))) continue;
                return false;
            }
        } else if (!this.getCanonicalKeyPropertyListString().equals(name.getCanonicalKeyPropertyListString())) {
            return false;
        }
        return true;
    }

    private static boolean domainMatches(String pattern2, int patternindex, String domain, int domainindex) {
        while (patternindex < pattern2.length()) {
            char c;
            if ((c = pattern2.charAt(patternindex++)) == '*') {
                int i = domain.length();
                while (i >= domainindex) {
                    if (ObjectName.domainMatches(pattern2, patternindex, domain, i)) {
                        return true;
                    }
                    --i;
                }
                return false;
            }
            if (domainindex >= domain.length()) {
                return false;
            }
            if (c != '?' && c != domain.charAt(domainindex)) {
                return false;
            }
            ++domainindex;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectName) {
            ObjectName o = (ObjectName)obj;
            return this.getCanonicalName().equals(o.getCanonicalName());
        }
        return false;
    }

    public String getCanonicalKeyPropertyListString() {
        CPStringBuilder builder = new CPStringBuilder();
        Iterator<Map.Entry<String, String>> i = this.properties.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, String> entry = i.next();
            builder.append(String.valueOf(entry.getKey()) + "=" + entry.getValue());
            if (!i.hasNext()) continue;
            builder.append(",");
        }
        return builder.toString();
    }

    public String getCanonicalName() {
        return String.valueOf(this.domain) + ":" + this.getCanonicalKeyPropertyListString() + (this.isPropertyPattern() ? (this.properties.isEmpty() ? "*" : ",*") : "");
    }

    public String getDomain() {
        return this.domain;
    }

    public static ObjectName getInstance(ObjectName name) {
        try {
            return new ObjectName(name.getCanonicalName());
        }
        catch (MalformedObjectNameException e) {
            throw (InternalError)new InternalError("The canonical name of the given name is invalid.").initCause(e);
        }
    }

    public static ObjectName getInstance(String name) throws MalformedObjectNameException {
        return new ObjectName(name);
    }

    public static ObjectName getInstance(String domain, String key, String value) throws MalformedObjectNameException {
        return new ObjectName(domain, key, value);
    }

    public static ObjectName getInstance(String domain, Hashtable<String, String> properties) throws MalformedObjectNameException {
        return new ObjectName(domain, properties);
    }

    public String getKeyProperty(String key) {
        if (key == null) {
            throw new NullPointerException("Null key given in request for a value.");
        }
        return this.properties.get(key);
    }

    public Hashtable<String, String> getKeyPropertyList() {
        return new Hashtable<String, String>(this.properties);
    }

    public String getKeyPropertyListString() {
        if (this.propertyListString != null) {
            return this.propertyListString;
        }
        return this.getCanonicalKeyPropertyListString();
    }

    public int hashCode() {
        return this.domain.hashCode() + this.properties.hashCode();
    }

    public boolean isDomainPattern() {
        return this.domain.contains("?") || this.domain.contains("*");
    }

    public boolean isPattern() {
        return this.isDomainPattern() || this.isPropertyPattern();
    }

    public boolean isPropertyPattern() {
        return this.propertyListPattern || this.propertyValuePattern;
    }

    public boolean isPropertyListPattern() {
        return this.propertyListPattern;
    }

    public boolean isPropertyValuePattern() {
        return this.propertyValuePattern;
    }

    public boolean isPropertyValuePattern(String key) {
        String value = this.getKeyProperty(key);
        if (value == null) {
            throw new IllegalArgumentException(String.valueOf(key) + " is not a valid property.");
        }
        return value.indexOf(63) != -1 || value.indexOf(42) != -1;
    }

    public static String quote(String string) {
        CPStringBuilder builder = new CPStringBuilder();
        builder.append('\"');
        int a = 0;
        while (a < string.length()) {
            char s = string.charAt(a);
            switch (s) {
                case '\"': {
                    builder.append("\\\"");
                    break;
                }
                case '*': {
                    builder.append("\\*");
                    break;
                }
                case '?': {
                    builder.append("\\?");
                    break;
                }
                case '\\': {
                    builder.append("\\\\");
                    break;
                }
                case '\n': {
                    builder.append("\\\n");
                    break;
                }
                default: {
                    builder.append(s);
                }
            }
            ++a;
        }
        builder.append('\"');
        return builder.toString();
    }

    @Override
    public void setMBeanServer(MBeanServer server) {
        this.server = server;
    }

    public String toString() {
        return this.getCanonicalName();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        CPStringBuilder buffer = new CPStringBuilder(this.getDomain());
        buffer.append(':');
        String properties = this.getKeyPropertyListString();
        buffer.append(properties);
        if (this.isPropertyPattern()) {
            if (properties.length() == 0) {
                buffer.append("*");
            } else {
                buffer.append(",*");
            }
        }
        out.writeObject(buffer.toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        String objectName = (String)in.readObject();
        try {
            this.parse(objectName);
        }
        catch (MalformedObjectNameException x) {
            throw new InvalidObjectException(x.toString());
        }
    }

    public static String unquote(String q) {
        if (q.charAt(0) != '\"') {
            throw new IllegalArgumentException("The string does not start with a quote.");
        }
        if (q.charAt(q.length() - 1) != '\"') {
            throw new IllegalArgumentException("The string does not end with a quote.");
        }
        CPStringBuilder builder = new CPStringBuilder();
        int a = 1;
        while (a < q.length() - 1) {
            char n = q.charAt(a);
            if (n == '\\') {
                if ((n = q.charAt(++a)) != '\"' && n != '?' && n != '*' && n != 'n' && n != '\\') {
                    throw new IllegalArgumentException("Illegal escaped character: " + n);
                }
            } else if (n == '\"' || n == '\n') {
                throw new IllegalArgumentException("Illegal character: " + n);
            }
            builder.append(n);
            ++a;
        }
        return builder.toString();
    }
}

