/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashSet<T>
extends AbstractSet<T>
implements Set<T>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5024744406713321676L;
    private transient HashMap<T, String> map;

    public HashSet() {
        this(11, 0.75f);
    }

    public HashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public HashSet(int initialCapacity, float loadFactor) {
        this.map = this.init(initialCapacity, loadFactor);
    }

    public HashSet(Collection<? extends T> c) {
        this(Math.max(2 * c.size(), 11));
        this.addAll(c);
    }

    @Override
    public boolean add(T o) {
        return this.map.put(o, "") == null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        HashSet copy = null;
        try {
            copy = (HashSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        copy.map = (HashMap)this.map.clone();
        return copy;
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean isEmpty() {
        return this.map.size == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.iterator(0);
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public int size() {
        return this.map.size;
    }

    HashMap init(int capacity, float load) {
        return new HashMap(capacity, load);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Iterator it = this.map.iterator(0);
        s.writeInt(this.map.buckets.length);
        s.writeFloat(this.map.loadFactor);
        s.writeInt(this.map.size);
        while (it.hasNext()) {
            s.writeObject(it.next());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.map = this.init(s.readInt(), s.readFloat());
        int size = s.readInt();
        while (size > 0) {
            this.map.put(s.readObject(), "");
            --size;
        }
    }
}

