/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.awt.font.NumericShaper;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;

public final class Bidi {
    public static final int DIRECTION_DEFAULT_LEFT_TO_RIGHT = -2;
    public static final int DIRECTION_DEFAULT_RIGHT_TO_LEFT = -1;
    public static final int DIRECTION_LEFT_TO_RIGHT = 0;
    public static final int DIRECTION_RIGHT_TO_LEFT = 1;
    private static final int LTOR = 1;
    private static final int RTOL = 2;
    private char[] text;
    private int textOffset;
    private byte[] embeddings;
    private int embeddingOffset;
    private int length;
    private int flags;
    private int baseEmbedding;
    private byte[] types;
    private byte[] levels;
    private ArrayList formatterIndices;
    private int[] runs;
    private int resultFlags;

    public Bidi(AttributedCharacterIterator iter) {
        Object val = iter.getAttribute(TextAttribute.RUN_DIRECTION);
        this.flags = val == TextAttribute.RUN_DIRECTION_LTR ? 0 : (val == TextAttribute.RUN_DIRECTION_RTL ? 1 : -2);
        NumericShaper shaper = null;
        val = iter.getAttribute(TextAttribute.NUMERIC_SHAPING);
        if (val instanceof NumericShaper) {
            shaper = (NumericShaper)val;
        }
        char[] text = new char[iter.getEndIndex() - iter.getBeginIndex()];
        this.embeddings = new byte[this.text.length];
        this.embeddingOffset = 0;
        this.length = text.length;
        int i = 0;
        while (i < this.text.length) {
            this.text[i] = iter.current();
            val = iter.getAttribute(TextAttribute.BIDI_EMBEDDING);
            if (val instanceof Integer) {
                int ival = (Integer)val;
                byte bval = ival < -62 || ival > 62 ? (byte)0 : (byte)ival;
                this.embeddings[i] = bval;
            }
            ++i;
        }
        if (shaper != null) {
            shaper.shape(this.text, 0, this.length);
        }
        this.runBidi();
    }

    public Bidi(char[] text, int offset, byte[] embeddings, int embedOffset, int length, int flags) {
        if (flags != -2 && flags != -1 && flags != 0 && flags != 1) {
            throw new IllegalArgumentException("unrecognized 'flags' argument: " + flags);
        }
        this.text = text;
        this.textOffset = offset;
        this.embeddings = embeddings;
        this.embeddingOffset = embedOffset;
        this.length = length;
        this.flags = flags;
        this.runBidi();
    }

    public Bidi(String text, int flags) {
        if (flags != -2 && flags != -1 && flags != 0 && flags != 1) {
            throw new IllegalArgumentException("unrecognized 'flags' argument: " + flags);
        }
        this.text = text.toCharArray();
        this.textOffset = 0;
        this.embeddings = null;
        this.embeddingOffset = 0;
        this.length = text.length();
        this.flags = flags;
        this.runBidi();
    }

    private void computeTypes() {
        this.types = new byte[this.length];
        int i = 0;
        while (i < this.length) {
            this.types[i] = Character.getDirectionality(this.text[this.textOffset + i]);
            ++i;
        }
    }

    private int computeParagraphEmbeddingLevel() {
        if (this.flags == 0 || this.flags == 1) {
            return this.flags;
        }
        int i = 0;
        while (i < this.length) {
            byte dir = this.types[i];
            if (dir == 0) {
                return 0;
            }
            if (dir == 1 || dir == 1) {
                return 1;
            }
            ++i;
        }
        return this.flags == -2 ? 0 : 1;
    }

    private void computeExplicitLevels() {
        this.levels = new byte[this.length];
        byte currentEmbedding = (byte)this.baseEmbedding;
        int directionalOverride = -1;
        byte[] embeddingStack = new byte[62];
        int sp = 0;
        int i = 0;
        while (i < this.length) {
            if (this.embeddings != null && this.embeddings[this.embeddingOffset + i] != 0) {
                currentEmbedding = this.embeddings[this.embeddingOffset + i];
                directionalOverride = currentEmbedding < 0 ? ((currentEmbedding = (byte)(-currentEmbedding)) % 2 == 0 ? 0 : 1) : -1;
            } else {
                boolean isLtoR = false;
                boolean isSpecial = true;
                switch (this.types[i]) {
                    case 14: 
                    case 15: {
                        isLtoR = true;
                    }
                    case 16: 
                    case 17: {
                        byte newEmbedding = isLtoR ? (byte)((currentEmbedding & 0xFFFFFFFE) + 2) : (byte)(currentEmbedding + 1 | 1);
                        if (newEmbedding >= 62) break;
                        if (directionalOverride != -1) {
                            currentEmbedding = (byte)(currentEmbedding | 0xFFFFFF80);
                        }
                        embeddingStack[sp++] = currentEmbedding;
                        currentEmbedding = newEmbedding;
                        if (this.types[i] == 15) {
                            directionalOverride = 0;
                            break;
                        }
                        if (this.types[i] == 17) {
                            directionalOverride = 1;
                            break;
                        }
                        directionalOverride = -1;
                        break;
                    }
                    case 18: {
                        if (sp == 0) break;
                        byte newEmbedding = embeddingStack[--sp];
                        currentEmbedding = (byte)(newEmbedding & 0x7F);
                        if (newEmbedding < 0) {
                            directionalOverride = (newEmbedding & 1) == 0 ? 0 : 1;
                            break;
                        }
                        directionalOverride = -1;
                        break;
                    }
                    default: {
                        isSpecial = false;
                    }
                }
                this.levels[i] = currentEmbedding;
                if (isSpecial) {
                    if (this.formatterIndices == null) {
                        this.formatterIndices = new ArrayList();
                    }
                    this.formatterIndices.add(i);
                } else if (directionalOverride != -1) {
                    this.types[i] = directionalOverride;
                }
            }
            ++i;
        }
        if (this.formatterIndices == null) {
            return;
        }
        int output = 0;
        int input = 0;
        int size = this.formatterIndices.size();
        int i2 = 0;
        while (i2 <= size) {
            int nextFmt = i2 == size ? this.length : (Integer)this.formatterIndices.get(i2);
            int len = nextFmt - input;
            System.arraycopy(this.levels, input, this.levels, output, len);
            System.arraycopy(this.types, input, this.types, output, len);
            output += len;
            input = nextFmt + 1;
            ++i2;
        }
        this.length -= this.formatterIndices.size();
    }

    private void computeRuns() {
        int runCount = 0;
        int currentEmbedding = this.baseEmbedding;
        int i = 0;
        while (i < this.length) {
            if (this.levels[i] != currentEmbedding) {
                currentEmbedding = this.levels[i];
                ++runCount;
            }
            ++i;
        }
        if (this.runs == null || this.runs.length != runCount + 1) {
            this.runs = new int[runCount + 1];
        }
        int where = 0;
        int lastRunStart = 0;
        currentEmbedding = this.baseEmbedding;
        int i2 = 0;
        while (i2 < this.length) {
            if (this.levels[i2] != currentEmbedding) {
                this.runs[where++] = lastRunStart;
                lastRunStart = i2;
                currentEmbedding = this.levels[i2];
            }
            ++i2;
        }
        this.runs[where++] = lastRunStart;
    }

    private void resolveWeakTypes() {
        int runCount = this.getRunCount();
        int previousLevel = this.baseEmbedding;
        int run = 0;
        while (run < runCount) {
            int start = this.getRunStart(run);
            int end = this.getRunLimit(run);
            int level = this.getRunLevel(run);
            byte sor = Math.max(previousLevel, level) % 2 == 0 ? (byte)0 : 1;
            int nextLevel = run == runCount - 1 ? this.baseEmbedding : this.getRunLevel(run + 1);
            byte eor = Math.max(level, nextLevel) % 2 == 0 ? (byte)0 : 1;
            byte prevType = sor;
            byte prevStrongType = sor;
            int i = start;
            while (i < end) {
                byte nextType;
                byte by = nextType = i == end - 1 ? eor : this.types[i + 1];
                if (this.types[i] == 8) {
                    this.types[i] = prevType;
                } else {
                    prevType = this.types[i];
                }
                if (this.types[i] == 3) {
                    if (prevStrongType == 2) {
                        this.types[i] = 6;
                    }
                } else if (this.types[i] == 0 || this.types[i] == 1 || this.types[i] == 2) {
                    prevStrongType = this.types[i];
                }
                if (this.types[i] == 2) {
                    this.types[i] = 1;
                }
                if (prevType == 3 && nextType == 3) {
                    if (this.types[i] == 4 || this.types[i] == 7) {
                        this.types[i] = nextType;
                    }
                } else if (prevType == 6 && nextType == 6 && this.types[i] == 7) {
                    this.types[i] = nextType;
                }
                if (this.types[i] == 5 || this.types[i] == 9) {
                    if (prevType == 3) {
                        this.types[i] = prevType;
                    } else {
                        int j = i + 1;
                        while (j < end && (this.types[j] == 5 || this.types[j] == 9)) {
                            ++j;
                        }
                        if (j < end && this.types[j] == 3) {
                            int k = i;
                            while (k < j) {
                                this.types[k] = 3;
                                ++k;
                            }
                        }
                    }
                }
                if (this.types[i] == 5 || this.types[i] == 5 || this.types[i] == 7 || this.types[i] == 9) {
                    this.types[i] = 13;
                }
                if (prevStrongType == 0 && this.types[i] == 3) {
                    this.types[i] = prevStrongType;
                }
                ++i;
            }
            previousLevel = level;
            ++run;
        }
    }

    private void resolveNeutralTypes() {
        int runCount = this.getRunCount();
        int previousLevel = this.baseEmbedding;
        int run = 0;
        while (run < runCount) {
            int start = this.getRunStart(run);
            int end = this.getRunLimit(run);
            int level = this.getRunLevel(run);
            int embeddingDirection = level % 2 == 0 ? 0 : 1;
            int sor = Math.max(previousLevel, level) % 2 == 0 ? 0 : 1;
            int nextLevel = run == runCount - 1 ? this.baseEmbedding : this.getRunLevel(run + 1);
            byte eor = Math.max(level, nextLevel) % 2 == 0 ? (byte)0 : 1;
            int prevStrong = sor;
            int neutralStart = -1;
            int i = start;
            while (i <= end) {
                int newStrong = -1;
                byte thisType = i == end ? eor : this.types[i];
                switch (thisType) {
                    case 0: {
                        newStrong = 0;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 6: {
                        newStrong = 1;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        if (neutralStart != -1) break;
                        neutralStart = i;
                    }
                }
                if (newStrong != -1) {
                    if (neutralStart != -1) {
                        int override = prevStrong == newStrong ? prevStrong : embeddingDirection;
                        int j = neutralStart;
                        while (j < i) {
                            this.types[j] = override;
                            ++j;
                        }
                    }
                    prevStrong = newStrong;
                    neutralStart = -1;
                }
                ++i;
            }
            previousLevel = level;
            ++run;
        }
    }

    private void resolveImplicitLevels() {
        int i = 0;
        while (i < this.length) {
            if ((this.levels[i] & 1) == 0) {
                if (this.types[i] == 1) {
                    int n = i;
                    this.levels[n] = (byte)(this.levels[n] + 1);
                } else if (this.types[i] == 6 || this.types[i] == 3) {
                    int n = i;
                    this.levels[n] = (byte)(this.levels[n] + 2);
                }
            } else if (this.types[i] == 0 || this.types[i] == 6 || this.types[i] == 3) {
                int n = i;
                this.levels[n] = (byte)(this.levels[n] + 1);
            }
            this.resultFlags |= 1 << (this.levels[i] & 1);
            ++i;
        }
        this.resultFlags |= 1 << this.baseEmbedding;
    }

    private void reinsertFormattingCodes() {
        if (this.formatterIndices == null) {
            return;
        }
        int input = this.length;
        int output = this.levels.length;
        int index = this.formatterIndices.size() - 1;
        while (index >= 0) {
            int nextFmt = (Integer)this.formatterIndices.get(index);
            int len = output - nextFmt - 1;
            output = nextFmt;
            input -= len;
            if (nextFmt + 1 < this.levels.length) {
                System.arraycopy(this.levels, input, this.levels, nextFmt + 1, len);
            }
            int rightLevel = output == this.levels.length - 1 ? this.baseEmbedding : this.levels[output + 1];
            int leftLevel = input == 0 ? this.baseEmbedding : this.levels[input];
            this.levels[output] = (byte)Math.max(leftLevel, rightLevel);
            --index;
        }
        this.length = this.levels.length;
    }

    private void runBidi() {
        this.computeTypes();
        this.baseEmbedding = this.computeParagraphEmbeddingLevel();
        this.computeExplicitLevels();
        this.computeRuns();
        this.resolveWeakTypes();
        this.resolveNeutralTypes();
        this.resolveImplicitLevels();
        this.types = null;
        this.reinsertFormattingCodes();
        this.computeRuns();
    }

    public boolean baseIsLeftToRight() {
        return this.baseEmbedding == 0;
    }

    public Bidi createLineBidi(int start, int end) {
        int level = this.getLevelAt(start);
        int flag = level % 2 == 0 ? 0 : 1;
        return new Bidi(this.text, this.textOffset + start, this.embeddings, this.embeddingOffset + start, end - start, flag);
    }

    public int getBaseLevel() {
        return this.baseEmbedding;
    }

    public int getLength() {
        return this.length;
    }

    public int getLevelAt(int offset) {
        if (offset < 0 || offset >= this.length) {
            return this.getBaseLevel();
        }
        return this.levels[offset];
    }

    public int getRunCount() {
        return this.runs.length;
    }

    public int getRunLevel(int which) {
        return this.levels[this.runs[which]];
    }

    public int getRunLimit(int which) {
        if (which == this.runs.length - 1) {
            return this.length;
        }
        return this.runs[which + 1];
    }

    public int getRunStart(int which) {
        return this.runs[which];
    }

    public boolean isLeftToRight() {
        return this.resultFlags == 1;
    }

    public boolean isMixed() {
        return this.resultFlags == 3;
    }

    public boolean isRightToLeft() {
        return this.resultFlags == 2;
    }

    public String toString() {
        return "Bidi Bidi Bidi I like you, Buck!";
    }

    /*
     * Unable to fully structure code
     */
    public static void reorderVisually(byte[] levels, int levelOffset, Object[] objs, int objOffset, int count) {
        levelCopy = new byte[count];
        max = 0;
        lowestOdd = 63;
        i = 0;
        while (i < count) {
            levelCopy[i] = levels[levelOffset + i];
            max = Math.max(levelCopy[i], max);
            if (levelCopy[i] % 2 != 0) {
                lowestOdd = Math.min(lowestOdd, levelCopy[i]);
            }
            ++i;
        }
        depth = max;
        while (depth >= lowestOdd) {
            start = 0;
            ** GOTO lbl35
            {
                ++start;
                do {
                    if (start < count && levelCopy[start] < depth) continue block2;
                    if (start == count) break block2;
                    end = start + 1;
                    while (end < count && levelCopy[end] >= depth) {
                        ++end;
                    }
                    i = 0;
                    while (i < (end - start) / 2) {
                        tmpb = levelCopy[end - i - 1];
                        levelCopy[end - i - 1] = levelCopy[start + i];
                        levelCopy[start + i] = tmpb;
                        tmpo = objs[objOffset + end - i - 1];
                        objs[objOffset + end - i - 1] = objs[objOffset + start + i];
                        objs[objOffset + start + i] = tmpo;
                        ++i;
                    }
                    start = end + 1;
lbl35:
                    // 2 sources

                } while (start < count);
            }
            --depth;
        }
    }

    public static boolean requiresBidi(char[] text, int start, int end) {
        int i = start;
        while (i < end) {
            byte dir = Character.getDirectionality(text[i]);
            if (dir != 0 && dir != 3 && dir != 4 && dir != 5 && dir != 6 && dir != 7 && dir != 11 && dir != 12 && dir != 10) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

