/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.classpath.Configuration;
import gnu.classpath.SystemProperties;
import gnu.classpath.VMStackWalker;
import gnu.java.security.provider.Gnu;
import gnu.javax.crypto.jce.GnuCrypto;
import gnu.javax.crypto.jce.GnuSasl;
import gnu.javax.net.ssl.provider.Jessie;
import gnu.javax.security.auth.callback.GnuCallbacks;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidParameterException;
import java.security.Provider;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Security {
    private static final String ALG_ALIAS = "Alg.Alias.";
    private static Vector providers = new Vector();
    private static Properties secprops = new Properties();

    static {
        String base = SystemProperties.getProperty("gnu.classpath.home.url");
        String vendor = SystemProperties.getProperty("gnu.classpath.vm.shortname");
        boolean loaded = Security.loadProviders(base, vendor);
        if (!Security.loadProviders(base, "classpath") && !loaded && providers.size() == 0) {
            if (Configuration.DEBUG) {
                System.err.println("WARNING: could not properly read security provider files:");
                System.err.println("         " + base + "/security/" + vendor + ".security");
                System.err.println("         " + base + "/security/" + "classpath" + ".security");
                System.err.println("         Falling back to standard GNU security provider");
            }
            providers.addElement(new Gnu());
            providers.addElement(new GnuCrypto());
            providers.addElement(new GnuSasl());
            providers.addElement(new Jessie());
            providers.addElement(new GnuCallbacks());
        }
    }

    private Security() {
    }

    private static boolean loadProviders(String baseUrl, String vendor) {
        if (baseUrl == null || vendor == null) {
            return false;
        }
        boolean result = true;
        String secfilestr = String.valueOf(baseUrl) + "/security/" + vendor + ".security";
        try {
            String name;
            InputStream fin = new URL(secfilestr).openStream();
            secprops.load(fin);
            int i = 1;
            while ((name = secprops.getProperty("security.provider." + i)) != null) {
                Exception exception = null;
                try {
                    ClassLoader sys = ClassLoader.getSystemClassLoader();
                    providers.addElement(Class.forName(name, true, sys).newInstance());
                }
                catch (ClassNotFoundException x) {
                    exception = x;
                }
                catch (InstantiationException x) {
                    exception = x;
                }
                catch (IllegalAccessException x) {
                    exception = x;
                }
                if (exception != null) {
                    System.err.println("WARNING: Error loading security provider " + name + ": " + exception);
                    result = false;
                }
                ++i;
            }
        }
        catch (IOException iOException) {
            result = false;
        }
        return result;
    }

    public static String getAlgorithmProperty(String algName, String propName) {
        if (algName == null || propName == null) {
            return null;
        }
        String property = String.valueOf(String.valueOf(propName)) + "." + String.valueOf(algName);
        for (Provider p : providers) {
            for (String key : p.keySet()) {
                if (!key.equalsIgnoreCase(property)) continue;
                return p.getProperty(key);
            }
        }
        return null;
    }

    public static int insertProviderAt(Provider provider, int position) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("insertProvider." + provider.getName());
        }
        --position;
        int max = providers.size();
        int i = 0;
        while (i < max) {
            if (((Provider)providers.elementAt(i)).getName().equals(provider.getName())) {
                return -1;
            }
            ++i;
        }
        if (position < 0) {
            position = 0;
        }
        if (position > max) {
            position = max;
        }
        providers.insertElementAt(provider, position);
        return position + 1;
    }

    public static int addProvider(Provider provider) {
        return Security.insertProviderAt(provider, providers.size() + 1);
    }

    public static void removeProvider(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("removeProvider." + name);
        }
        int max = providers.size();
        int i = 0;
        while (i < max) {
            if (((Provider)providers.elementAt(i)).getName().equals(name)) {
                providers.remove(i);
                break;
            }
            ++i;
        }
    }

    public static Provider[] getProviders() {
        Object[] array = new Provider[providers.size()];
        providers.copyInto(array);
        return array;
    }

    public static Provider getProvider(String name) {
        if (name == null) {
            return null;
        }
        if ((name = name.trim()).length() == 0) {
            return null;
        }
        int max = providers.size();
        int i = 0;
        while (i < max) {
            Provider p = (Provider)providers.elementAt(i);
            if (p.getName().equals(name)) {
                return p;
            }
            ++i;
        }
        return null;
    }

    public static String getProperty(String key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && VMStackWalker.getCallingClassLoader() != null) {
            sm.checkSecurityAccess("getProperty." + key);
        }
        return secprops.getProperty(key);
    }

    public static void setProperty(String key, String datum) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkSecurityAccess("setProperty." + key);
        }
        if (datum == null) {
            secprops.remove(key);
        } else {
            secprops.put(key, datum);
        }
    }

    public static Set<String> getAlgorithms(String serviceName) {
        HashSet<String> result = new HashSet<String>();
        if (serviceName == null || serviceName.length() == 0) {
            return result;
        }
        if ((serviceName = serviceName.trim()).length() == 0) {
            return result;
        }
        serviceName = String.valueOf(serviceName.toUpperCase()) + ".";
        Provider[] providers = Security.getProviders();
        int i = 0;
        while (i < providers.length) {
            Enumeration<?> e = providers[i].propertyNames();
            while (e.hasMoreElements()) {
                String service = ((String)e.nextElement()).trim();
                if (!service.toUpperCase().startsWith(serviceName)) continue;
                int ndx = (service = service.substring(serviceName.length()).trim()).indexOf(32);
                if (ndx != -1) {
                    service = service.substring(0, ndx);
                }
                result.add(service);
            }
            ++i;
        }
        return Collections.unmodifiableSet(result);
    }

    public static Provider[] getProviders(String filter) {
        if (providers == null || providers.isEmpty()) {
            return null;
        }
        if (filter == null || filter.length() == 0) {
            return Security.getProviders();
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        int i = filter.indexOf(58);
        if (i == -1) {
            map.put(filter, "");
        } else {
            map.put(filter.substring(0, i), filter.substring(i + 1));
        }
        return Security.getProviders(map);
    }

    public static Provider[] getProviders(Map<String, String> filter) {
        if (providers == null || providers.isEmpty()) {
            return null;
        }
        if (filter == null) {
            return Security.getProviders();
        }
        Set<String> querries = filter.keySet();
        if (querries == null || querries.isEmpty()) {
            return Security.getProviders();
        }
        LinkedHashSet<Provider> result = new LinkedHashSet<Provider>(providers);
        LinkedHashSet serviceProviders = new LinkedHashSet();
        for (String querry : querries) {
            String algorithm;
            String service;
            String attribute;
            if (querry == null || (querry = querry.trim()).length() == 0) continue;
            int dot = querry.indexOf(46);
            if (dot == -1) {
                throw new InvalidParameterException("missing dot in '" + String.valueOf(querry) + "'");
            }
            String value = filter.get(querry);
            if (value == null || value.trim().length() == 0) {
                value = null;
                attribute = null;
                service = querry.substring(0, dot).trim();
                algorithm = querry.substring(dot + 1).trim();
            } else {
                int ws = querry.indexOf(32);
                if (ws == -1) {
                    throw new InvalidParameterException("value (" + String.valueOf(value) + ") is not empty, but querry (" + String.valueOf(querry) + ") is missing at least one space character");
                }
                value = value.trim();
                attribute = querry.substring(ws + 1).trim();
                if (attribute.indexOf(46) != -1) {
                    throw new InvalidParameterException("attribute_name (" + String.valueOf(attribute) + ") in querry (" + String.valueOf(querry) + ") contains a dot");
                }
                querry = querry.substring(0, ws).trim();
                service = querry.substring(0, dot).trim();
                algorithm = querry.substring(dot + 1).trim();
            }
            if (service.length() == 0) {
                throw new InvalidParameterException("<crypto_service> in querry (" + String.valueOf(querry) + ") is empty");
            }
            if (algorithm.length() == 0) {
                throw new InvalidParameterException("<algorithm_or_type> in querry (" + String.valueOf(querry) + ") is empty");
            }
            Security.selectProviders(service, algorithm, attribute, value, result, serviceProviders);
            result.retainAll(serviceProviders);
            if (result.isEmpty()) break;
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new Provider[result.size()]);
    }

    private static void selectProviders(String svc, String algo, String attr, String val, LinkedHashSet providerSet, LinkedHashSet result) {
        result.clear();
        for (Provider p : providerSet) {
            if (!Security.provides(p, svc, algo, attr, val)) continue;
            result.add(p);
        }
    }

    private static boolean provides(Provider p, String svc, String algo, String attr, String val) {
        String serviceDotAlgorithm = null;
        String key2 = null;
        boolean found = false;
        int r = 0;
        block0: while (r < 3) {
            serviceDotAlgorithm = (String.valueOf(svc) + "." + String.valueOf(algo)).trim();
            for (String key2 : p.keySet()) {
                if (key2.equalsIgnoreCase(serviceDotAlgorithm)) {
                    found = true;
                    break block0;
                }
                if (!key2.equalsIgnoreCase(ALG_ALIAS + serviceDotAlgorithm)) continue;
                algo = p.getProperty(key2);
                break;
            }
            ++r;
        }
        if (!found) {
            return false;
        }
        if (val == null) {
            return true;
        }
        int limit = serviceDotAlgorithm.length() + 1;
        for (String key2 : p.keySet()) {
            String realAttr;
            if (key2.length() <= limit || !key2.substring(0, limit).equalsIgnoreCase(String.valueOf(serviceDotAlgorithm) + " ") || !(realAttr = key2.substring(limit).trim()).equalsIgnoreCase(attr)) continue;
            String realVal = p.getProperty(key2);
            if (realVal == null) {
                return false;
            }
            if (val.equalsIgnoreCase(realVal = realVal.trim())) {
                return true;
            }
            return Integer.parseInt(val) >= Integer.parseInt(realVal);
        }
        return false;
    }
}

