/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;

public final class DataBufferFloat
extends DataBuffer {
    private float[] data;
    private float[][] bankData;

    public DataBufferFloat(int size) {
        super(4, size, 1, 0);
        this.bankData = new float[1][];
        this.data = new float[size];
        this.bankData[0] = this.data;
    }

    public DataBufferFloat(int size, int numBanks) {
        super(4, size, numBanks);
        this.bankData = new float[numBanks][size];
        this.data = this.bankData[0];
    }

    public DataBufferFloat(float[] dataArray, int size) {
        super(4, size, 1, 0);
        this.bankData = new float[1][];
        this.data = dataArray;
        this.bankData[0] = this.data;
    }

    public DataBufferFloat(float[] dataArray, int size, int offset) {
        super(4, size, 1, offset);
        this.bankData = new float[1][];
        this.data = dataArray;
        this.bankData[0] = this.data;
    }

    public DataBufferFloat(float[][] dataArray, int size) {
        super(4, size, dataArray.length);
        this.bankData = dataArray;
        this.data = this.bankData[0];
    }

    public DataBufferFloat(float[][] dataArray, int size, int[] offsets) {
        super(4, size, dataArray.length, offsets);
        this.bankData = dataArray;
        this.data = this.bankData[0];
    }

    public float[] getData() {
        return this.data;
    }

    public float[] getData(int bank) {
        return this.bankData[bank];
    }

    public float[][] getBankData() {
        return this.bankData;
    }

    public int getElem(int i) {
        return (int)this.data[i + this.offset];
    }

    public int getElem(int bank, int i) {
        return (int)this.bankData[bank][i + this.offsets[bank]];
    }

    public void setElem(int i, int val) {
        this.data[i + this.offset] = val;
    }

    public void setElem(int bank, int i, int val) {
        this.bankData[bank][i + this.offsets[bank]] = val;
    }

    public float getElemFloat(int i) {
        return this.data[i + this.offset];
    }

    public float getElemFloat(int bank, int i) {
        return this.bankData[bank][i + this.offsets[bank]];
    }

    public void setElemFloat(int i, float val) {
        this.data[i + this.offset] = val;
    }

    public void setElemFloat(int bank, int i, float val) {
        this.bankData[bank][i + this.offsets[bank]] = val;
    }

    public double getElemDouble(int i) {
        return this.getElemFloat(i);
    }

    public double getElemDouble(int bank, int i) {
        return this.getElemFloat(bank, i);
    }

    public void setElemDouble(int i, double val) {
        this.setElemFloat(i, (float)val);
    }

    public void setElemDouble(int bank, int i, double val) {
        this.setElemFloat(bank, i, (float)val);
    }
}

