/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.peer.TextComponentPeer;
import java.io.Serializable;
import java.text.BreakIterator;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.text.AttributeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextComponent
extends Component
implements Serializable,
Accessible {
    private static final long serialVersionUID = -2214773872412987419L;
    boolean editable;
    int selectionStart;
    int selectionEnd;
    String text;
    protected transient TextListener textListener;

    TextComponent(String text) {
        this.text = text == null ? "" : text;
        this.editable = true;
    }

    public synchronized String getText() {
        TextComponentPeer tcp = (TextComponentPeer)this.getPeer();
        if (tcp != null) {
            this.text = tcp.getText();
        }
        return this.text;
    }

    public synchronized void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.text = text;
        TextComponentPeer tcp = (TextComponentPeer)this.getPeer();
        if (tcp != null) {
            tcp.setText(text);
        }
        this.setCaretPosition(0);
    }

    public synchronized String getSelectedText() {
        String alltext = this.getText();
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        return alltext.substring(start, end);
    }

    public synchronized int getSelectionStart() {
        TextComponentPeer tcp = (TextComponentPeer)this.getPeer();
        if (tcp != null) {
            this.selectionStart = tcp.getSelectionStart();
        }
        return this.selectionStart;
    }

    public synchronized void setSelectionStart(int selectionStart) {
        this.select(selectionStart, this.getSelectionEnd() < selectionStart ? selectionStart : this.getSelectionEnd());
    }

    public synchronized int getSelectionEnd() {
        TextComponentPeer tcp = (TextComponentPeer)this.getPeer();
        if (tcp != null) {
            this.selectionEnd = tcp.getSelectionEnd();
        }
        return this.selectionEnd;
    }

    public synchronized void setSelectionEnd(int selectionEnd) {
        this.select(this.getSelectionStart(), selectionEnd);
    }

    public synchronized void select(int selectionStart, int selectionEnd) {
        if (selectionStart < 0) {
            selectionStart = 0;
        }
        if (selectionStart > this.getText().length()) {
            selectionStart = this.text.length();
        }
        if (selectionEnd > this.text.length()) {
            selectionEnd = this.text.length();
        }
        if (selectionStart > selectionEnd) {
            selectionStart = selectionEnd;
        }
        this.selectionStart = selectionStart;
        this.selectionEnd = selectionEnd;
        TextComponentPeer tcp = (TextComponentPeer)this.getPeer();
        if (tcp != null) {
            tcp.select(selectionStart, selectionEnd);
        }
    }

    public synchronized void selectAll() {
        this.select(0, this.getText().length());
    }

    public synchronized int getCaretPosition() {
        TextComponentPeer tcp = (TextComponentPeer)this.getPeer();
        if (tcp != null) {
            return tcp.getCaretPosition();
        }
        return 0;
    }

    public synchronized void setCaretPosition(int caretPosition) {
        if (caretPosition < 0) {
            throw new IllegalArgumentException();
        }
        TextComponentPeer tcp = (TextComponentPeer)this.getPeer();
        if (tcp != null) {
            tcp.setCaretPosition(caretPosition);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public synchronized void setEditable(boolean editable) {
        this.editable = editable;
        TextComponentPeer tcp = (TextComponentPeer)this.getPeer();
        if (tcp != null) {
            tcp.setEditable(editable);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
    }

    public synchronized void addTextListener(TextListener listener) {
        this.textListener = AWTEventMulticaster.add(this.textListener, listener);
        this.enableEvents(1024L);
    }

    public synchronized void removeTextListener(TextListener listener) {
        this.textListener = AWTEventMulticaster.remove(this.textListener, listener);
    }

    @Override
    protected void processEvent(AWTEvent event) {
        if (event instanceof TextEvent) {
            this.processTextEvent((TextEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processTextEvent(TextEvent event) {
        if (this.textListener != null) {
            this.textListener.textValueChanged(event);
        }
    }

    @Override
    void dispatchEventImpl(AWTEvent e) {
        if (e.id <= 900 && e.id >= 900 && (this.textListener != null || (this.eventMask & 0x400L) != 0L)) {
            this.processEvent(e);
        } else {
            super.dispatchEventImpl(e);
        }
    }

    @Override
    protected String paramString() {
        return String.valueOf(this.getClass().getName()) + "(text=" + this.getText() + ")";
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        if (listenerType == TextListener.class) {
            return AWTEventMulticaster.getListeners((EventListener)this.textListener, listenerType);
        }
        return super.getListeners(listenerType);
    }

    public TextListener[] getTextListeners() {
        return (TextListener[])this.getListeners(TextListener.class);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTTextComponent();
        }
        return this.accessibleContext;
    }

    synchronized int getIndexAtPoint(Point p) {
        TextComponentPeer tcp = (TextComponentPeer)this.getPeer();
        if (tcp != null) {
            return tcp.getIndexAtPoint(p.x, p.y);
        }
        return -1;
    }

    synchronized Rectangle getCharacterBounds(int i) {
        TextComponentPeer tcp = (TextComponentPeer)this.getPeer();
        if (tcp != null) {
            return tcp.getCharacterBounds(i);
        }
        return null;
    }

    static boolean ignoreOldMouseEvents() {
        return true;
    }

    protected class AccessibleAWTTextComponent
    extends Component.AccessibleAWTComponent
    implements AccessibleText,
    TextListener {
        private static final long serialVersionUID = 3631432373506317811L;

        public AccessibleAWTTextComponent() {
            super(TextComponent.this);
            TextComponent.this.addTextListener(this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet ss = super.getAccessibleStateSet();
            if (TextComponent.this.editable) {
                ss.add(AccessibleState.EDITABLE);
            }
            return ss;
        }

        public AccessibleText getAccessibleText() {
            return this;
        }

        public int getIndexAtPoint(Point point) {
            return TextComponent.this.getIndexAtPoint(point);
        }

        public Rectangle getCharacterBounds(int index) {
            return TextComponent.this.getCharacterBounds(index);
        }

        public int getCharCount() {
            return TextComponent.this.text.length();
        }

        public int getCaretPosition() {
            return TextComponent.this.getCaretPosition();
        }

        public String getAtIndex(int part, int index) {
            int end;
            if (index < 0 || index >= TextComponent.this.text.length()) {
                return null;
            }
            BreakIterator it = null;
            switch (part) {
                case 1: {
                    return TextComponent.this.text.substring(index, index + 1);
                }
                case 2: {
                    it = BreakIterator.getWordInstance();
                    break;
                }
                case 3: {
                    it = BreakIterator.getSentenceInstance();
                    break;
                }
                default: {
                    return null;
                }
            }
            it.setText(TextComponent.this.text);
            if (!it.isBoundary(index)) {
                it.preceding(index);
            }
            if ((end = it.following(index)) == -1) {
                return TextComponent.this.text.substring(index);
            }
            return TextComponent.this.text.substring(index, end);
        }

        public String getAfterIndex(int part, int index) {
            if (index < 0 || index >= TextComponent.this.text.length()) {
                return null;
            }
            BreakIterator it = null;
            switch (part) {
                case 1: {
                    return TextComponent.this.text.substring(index, index + 1);
                }
                case 2: {
                    it = BreakIterator.getWordInstance();
                    break;
                }
                case 3: {
                    it = BreakIterator.getSentenceInstance();
                    break;
                }
                default: {
                    return null;
                }
            }
            it.setText(TextComponent.this.text);
            int start = index;
            if (!it.isBoundary(index)) {
                start = it.following(index);
            }
            if (start == -1) {
                return null;
            }
            int end = it.following(start);
            if (end == -1) {
                return TextComponent.this.text.substring(index);
            }
            return TextComponent.this.text.substring(index, end);
        }

        public String getBeforeIndex(int part, int index) {
            if (index < 1 || index >= TextComponent.this.text.length()) {
                return null;
            }
            BreakIterator it = null;
            switch (part) {
                case 1: {
                    return TextComponent.this.text.substring(index - 1, index);
                }
                case 2: {
                    it = BreakIterator.getWordInstance();
                    break;
                }
                case 3: {
                    it = BreakIterator.getSentenceInstance();
                    break;
                }
                default: {
                    return null;
                }
            }
            it.setText(TextComponent.this.text);
            int end = index;
            if (!it.isBoundary(index)) {
                end = it.preceding(index);
            }
            if (end == -1) {
                return null;
            }
            int start = it.preceding(end);
            if (start == -1) {
                return TextComponent.this.text.substring(0, end);
            }
            return TextComponent.this.text.substring(start, end);
        }

        public AttributeSet getCharacterAttribute(int index) {
            return null;
        }

        public int getSelectionStart() {
            return TextComponent.this.selectionStart;
        }

        public int getSelectionEnd() {
            return TextComponent.this.selectionEnd;
        }

        public String getSelectedText() {
            if (TextComponent.this.selectionEnd - TextComponent.this.selectionStart > 0) {
                return TextComponent.this.text.substring(TextComponent.this.selectionStart, TextComponent.this.selectionEnd);
            }
            return null;
        }

        public void textValueChanged(TextEvent event) {
        }
    }
}

