/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.util;

import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Resolver
implements EntityResolver,
Cloneable {
    private Dictionary pubidMapping;

    public static void addDirectoryMapping(Dictionary table, String[][] mappings, File directory) throws IOException {
        int i = 0;
        while (i < mappings.length) {
            File file = new File(directory, mappings[i][1]);
            if (file.exists()) {
                String temp = Resolver.fileToURL(file);
                table.put(mappings[i][0], temp);
            }
            ++i;
        }
    }

    public static String fileNameToURL(String filename) throws IOException {
        return Resolver.fileToURL(new File(filename));
    }

    public static String fileToURL(File f) throws IOException {
        if (!f.exists()) {
            throw new IOException("no such file: " + f.getName());
        }
        String temp = f.getAbsolutePath();
        if (File.separatorChar != '/') {
            temp = temp.replace(File.separatorChar, '/');
        }
        if (!temp.startsWith("/")) {
            temp = "/" + temp;
        }
        if (!temp.endsWith("/") && f.isDirectory()) {
            temp = String.valueOf(temp) + "/";
        }
        return "file:" + temp;
    }

    public static String getURL(String fileOrURL) {
        try {
            return Resolver.fileNameToURL(fileOrURL);
        }
        catch (Exception exception) {
            return fileOrURL;
        }
    }

    public Resolver(Dictionary dict) {
        this.pubidMapping = dict;
    }

    public static String getEncoding(String contentType) {
        String encoding;
        int temp;
        String defValue = null;
        if (contentType.startsWith("text/")) {
            String string = defValue = contentType.startsWith("text/html") ? "ISO-8859-1" : "US-ASCII";
        }
        if ((temp = contentType.indexOf("charset")) != -1) {
            if ((temp = contentType.indexOf(61, temp)) == -1) {
                return defValue;
            }
            encoding = contentType.substring(temp + 1);
            if ((temp = encoding.indexOf(59)) != -1) {
                encoding = encoding.substring(0, temp);
            }
            if ((temp = encoding.indexOf(40)) != -1) {
                encoding = encoding.substring(0, temp);
            }
            if ((encoding = encoding.trim()).charAt(0) == '\"') {
                encoding = encoding.substring(1, encoding.length() - 1);
            }
        } else {
            encoding = defValue;
        }
        return encoding;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        String uri;
        InputSource retval = null;
        if (publicId != null && (uri = (String)this.pubidMapping.get(publicId)) != null) {
            retval = new InputSource(uri);
            retval.setPublicId(publicId);
        }
        return retval;
    }
}

